/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class StringSelector
extends JPanel
implements ItemListener {
    public static final String STRING_ARRAY_DELIMITER = ",";
    private JCheckBox[] check_box_;
    private PropertyEditor editor_;
    private String[] values_;

    public StringSelector(PropertyEditor pe) {
        this(pe, pe.getTags(), null);
    }

    public StringSelector(PropertyEditor pe, String[] values, String[] titles) {
        this(pe, values, titles, 3);
    }

    public StringSelector(PropertyEditor pe, String[] values, String[] titles, int vis_columns) {
        if (titles == null) {
            titles = new String[]{};
        }
        this.setLayout(new BorderLayout());
        this.editor_ = pe;
        this.values_ = values;
        JPanel panel = new JPanel();
        int raws = values.length / vis_columns;
        if (values.length % vis_columns != 0) {
            ++raws;
        }
        panel.setLayout(new GridLayout(raws, vis_columns));
        this.add((Component)panel, "West");
        this.check_box_ = new JCheckBox[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                if (titles[i] == null) {
                    titles[i] = values[i];
                }
                this.check_box_[i] = new JCheckBox(titles[i]);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                this.check_box_[i] = new JCheckBox(values[i]);
            }
            panel.add(this.check_box_[i]);
            this.check_box_[i].addItemListener(this);
        }
        this.select((String[])this.editor_.getValue());
    }

    private void select(String[] values) {
        if (values == null) {
            values = new String[]{};
        }
        for (int i = 0; i < this.values_.length; ++i) {
            this.check_box_[i].removeItemListener(this);
            this.check_box_[i].setSelected(false);
            this.check_box_[i].addItemListener(this);
        }
        for (int count = 0; count < values.length; ++count) {
            String token = values[count];
            for (int i = 0; i < this.values_.length; ++i) {
                if (!values[count].equals(this.values_[i])) continue;
                this.check_box_[i].removeItemListener(this);
                this.check_box_[i].setSelected(true);
                this.check_box_[i].addItemListener(this);
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.changed();
    }

    private void changed() {
        String[] ret = new String[this.check_box_.length];
        int length = 0;
        for (int count = 0; count < this.check_box_.length; ++count) {
            if (!this.check_box_[count].isSelected()) continue;
            ret[length++] = this.values_[count];
        }
        String[] values = new String[length];
        System.arraycopy(ret, 0, values, 0, length);
        this.editor_.setValue(values);
    }

    public void repaint() {
        if (this.check_box_ != null && this.editor_ != null) {
            this.select((String[])this.editor_.getValue());
        }
    }
}

