/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class StringChooser
extends JPanel
implements ItemListener {
    private JComboBox selector_;
    private PropertyEditor editor_;
    private String[] values_;

    public StringChooser(PropertyEditor pe) {
        this(pe, pe.getTags(), null);
    }

    public StringChooser(PropertyEditor pe, String[] values, String[] titles) {
        if (titles == null) {
            titles = new String[]{};
        }
        this.setLayout(new BorderLayout());
        this.editor_ = pe;
        this.selector_ = new JComboBox();
        this.values_ = values;
        this.add((Component)this.selector_, "West");
        for (int i = 0; i < values.length; ++i) {
            try {
                if (titles[i] == null) {
                    titles[i] = values[i];
                }
                this.selector_.addItem(titles[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                this.selector_.addItem(values[i]);
            }
        }
        String to_select = this.editor_.getAsText();
        this.select(to_select);
        if (to_select == null) {
            this.editor_.setAsText(this.values_[0]);
        }
        this.selector_.addItemListener(this);
    }

    public void select(String value) {
        if (value == null) {
            this.selector_.setSelectedIndex(0);
        } else {
            for (int count = 0; count < this.values_.length; ++count) {
                if (!this.values_[count].equals(value)) continue;
                this.selector_.setSelectedIndex(count);
                break;
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.editor_.setAsText(this.values_[this.selector_.getSelectedIndex()]);
    }

    public void repaint() {
        if (this.selector_ != null && this.editor_ != null) {
            this.select(this.editor_.getAsText());
        }
    }
}

