/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class SelectedButtonActionSynchronizer
implements ItemListener,
PropertyChangeListener {
    WeakReference weak_action_;
    WeakReference weak_button_;
    public static final String SELECTED = "selected";

    public SelectedButtonActionSynchronizer(AbstractButton button, Action action) {
        this.setAction(action);
        this.setButton(button);
        button.addItemListener(this);
        action.addPropertyChangeListener(this);
    }

    public void itemStateChanged(ItemEvent event) {
        AbstractButton button = (AbstractButton)event.getSource();
        Action action = this.getAction();
        if (action != null) {
            action.putValue(SELECTED, new Boolean(event.getStateChange() == 1));
        } else {
            button.removeItemListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property_name = event.getPropertyName();
        if (SELECTED.equals(property_name)) {
            AbstractButton button = this.getButton();
            Action action = (Action)event.getSource();
            if (button != null) {
                Object selected = action.getValue(SELECTED);
                if (selected != null && selected instanceof Boolean) {
                    button.setSelected((Boolean)selected);
                }
            } else {
                action.removePropertyChangeListener(this);
            }
        }
    }

    public void setAction(Action action) {
        this.weak_action_ = new WeakReference<Action>(action);
    }

    public Action getAction() {
        return (Action)this.weak_action_.get();
    }

    public void setButton(AbstractButton button) {
        this.weak_button_ = new WeakReference<AbstractButton>(button);
    }

    public AbstractButton getButton() {
        return (AbstractButton)this.weak_button_.get();
    }
}

