/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLViewerFrame
extends JFrame
implements HyperlinkListener {
    protected JEditorPane editor_pane_ = new JEditorPane();

    public HTMLViewerFrame() {
        this.editor_pane_.setEditable(false);
        JScrollPane editor_scroll_pane = new JScrollPane(this.editor_pane_);
        editor_scroll_pane.setPreferredSize(new Dimension(640, 480));
        this.getContentPane().add(editor_scroll_pane);
        this.setDefaultCloseOperation(2);
        this.editor_pane_.addHyperlinkListener(this);
    }

    public HTMLViewerFrame(URL url) throws IOException {
        this();
        this.setPage(url);
    }

    public void setPage(URL url) throws IOException {
        this.editor_pane_.setPage(url);
        this.setTitle(url.toString());
    }

    public void setText(String text) {
        this.editor_pane_.setText(text);
    }

    public void setProxyHost(String proxy_host) {
        System.getProperties().put("http.proxyHost", proxy_host);
    }

    public void setProxyPort(int proxy_port) {
        System.getProperties().put("http.proxyPort", Integer.toString(proxy_port));
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)event.getSource();
            if (event instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)event;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(event.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println(HTMLViewerFrame.class.getName() + " [<proxyhost> <proxyport>] <url>");
        }
        String proxy_host = args[0];
        String proxy_port = args[1];
        HTMLViewerFrame viewer = new HTMLViewerFrame();
        if (args.length == 3) {
            viewer.setProxyHost(proxy_host);
            viewer.setProxyPort(Integer.parseInt(proxy_port));
        }
        try {
            viewer.setPage(new URL(args[args.length - 1]));
            viewer.setVisible(true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

