/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.debug;

import [Ljava.lang.String;;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.dinopolis.util.commandarguments.CommandArgumentException;
import org.dinopolis.util.commandarguments.CommandArguments;
import org.dinopolis.util.debug.DebugMessageFormatFactory;
import org.dinopolis.util.debug.DebugMessageFormatObject;
import org.dinopolis.util.debug.Timer;

public class Debug {
    static Debug debug_instance_ = null;
    static Writer out_ = new PrintWriter(System.err);
    protected TreeSet levels_to_print_ = new TreeSet();
    private boolean enabled_ = true;
    private boolean print_all_levels_ = false;
    protected long last_message_time_ = System.currentTimeMillis();
    private TreeMap timers_ = new TreeMap();
    private File user_property_file_ = null;
    private Object user_property_file_lock_ = new Object();
    protected String user_property_file_name_ = "debug.properties";
    protected long property_file_last_modified_ = 0L;
    protected RefreshPropertiesThread refresh_properties_thread_;
    static final int REFRESH_PROPERTIES_THREAD_PRIORITY = 3;
    static final String KEYWORD_DELIMITER = "%";
    protected Vector message_format_;
    protected Object message_format_lock_ = new Object();
    protected boolean write_to_file_ = false;
    protected String filename_ = "";
    protected static final String CR = System.getProperty("line.separator");
    public static final boolean DEBUG = true;
    public static final boolean DEBUG_DEBUG = false;

    public Debug() {
        this.user_property_file_ = new File((String)System.getProperties().get("user.home"), this.user_property_file_name_);
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() {
        block11: {
            Properties properties = null;
            Object props_file = null;
            try {
                long props_file_modified = this.user_property_file_.lastModified();
                if (this.property_file_last_modified_ >= props_file_modified) break block11;
                this.property_file_last_modified_ = props_file_modified;
                properties = new Properties();
                Object object = this.user_property_file_lock_;
                synchronized (object) {
                    properties.load(new BufferedInputStream(new FileInputStream(this.user_property_file_)));
                }
                this.enable(new Boolean((String)properties.get("Debug.enabled")));
                this.removeAllLevelsToPrint();
                String levels = (String)properties.get("Debug.printLevels");
                if (levels != null) {
                    this.addLevelsToPrint(levels);
                }
                this.printAllLevels(new Boolean((String)properties.get("Debug.printAllLevels")));
                String msg_format = (String)properties.get("Debug.messageFormat");
                if (msg_format == null) {
                    msg_format = "%message%";
                }
                this.setMessageFormat(msg_format);
                try {
                    long refresh = new Long((String)properties.get("Debug.refreshPropertyTime"));
                    this.startRefreshPropertiesThread(refresh);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                String file_name = (String)properties.get("Debug.fileName");
                if (file_name != null) {
                    this.setWriterToFile(file_name);
                }
            }
            catch (IOException ioe) {
                System.err.println("users property file '" + this.user_property_file_ + "' couldn't be read");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFormat(String format_string) {
        StringTokenizer tokenizer = new StringTokenizer(format_string, KEYWORD_DELIMITER, true);
        int len = tokenizer.countTokens();
        if (len == 0) {
            this.message_format_ = null;
            return;
        }
        Vector<Object> message_format = new Vector<Object>();
        boolean in_variable = false;
        boolean count = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(KEYWORD_DELIMITER)) {
                in_variable = !in_variable;
                continue;
            }
            if (in_variable) {
                token = token.toLowerCase();
                try {
                    DebugMessageFormatObject message_obj = DebugMessageFormatFactory.getMessageFormatObject(token);
                    message_format.addElement(message_obj);
                }
                catch (Exception e) {
                    System.err.println("ERROR: " + this.getClass().getName() + " Unknown keyword '" + token + "'!");
                }
                continue;
            }
            message_format.addElement(token);
        }
        Object object = this.message_format_lock_;
        synchronized (object) {
            this.message_format_ = message_format;
        }
    }

    public void printAllLevels(boolean print_all) {
        this.print_all_levels_ = print_all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLevelsToPrint(String levels) {
        String[] tokens = Debug.tokenize(levels.toLowerCase());
        TreeSet treeSet = this.levels_to_print_;
        synchronized (treeSet) {
            for (int i = 0; i < tokens.length; ++i) {
                this.levels_to_print_.add(tokens[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLevelsToPrint(String levels) {
        String[] tokens = Debug.tokenize(levels.toLowerCase());
        TreeSet treeSet = this.levels_to_print_;
        synchronized (treeSet) {
            for (int i = 0; i < tokens.length; ++i) {
                this.levels_to_print_.remove(tokens[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLevelsToPrint() {
        TreeSet treeSet = this.levels_to_print_;
        synchronized (treeSet) {
            this.levels_to_print_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(String name) {
        if (!this.enabled_) {
            return;
        }
        String my_name = name.toLowerCase();
        Timer mytimer = new Timer(my_name);
        TreeMap treeMap = this.timers_;
        synchronized (treeMap) {
            this.timers_.put(my_name, mytimer);
        }
        mytimer.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String stopTimer(String name) {
        if (!this.enabled_) {
            return "";
        }
        String my_name = name.toLowerCase();
        TreeMap treeMap = this.timers_;
        synchronized (treeMap) {
            Timer mytimer = (Timer)this.timers_.get(my_name);
            if (mytimer == null) {
                return "Unknown Timer '" + my_name + "' " + this.getStackTrace(3, 1);
            }
            String timer_value = "";
            mytimer.stopTimer();
            timer_value = mytimer.toString();
            this.timers_.remove(my_name);
            mytimer = null;
            return timer_value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimer(String name) {
        Timer mytimer;
        if (!this.enabled_) {
            return "";
        }
        String my_name = name.toLowerCase();
        TreeMap treeMap = this.timers_;
        synchronized (treeMap) {
            mytimer = (Timer)this.timers_.get(my_name);
        }
        if (mytimer == null) {
            return "Unknown Timer '" + my_name + "' " + this.getStackTrace(3, 1);
        }
        mytimer.stopTimer();
        return mytimer.toString();
    }

    public void enable(boolean flag) {
        this.enabled_ = flag;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public boolean isEnabled(String level) {
        return this.enabled_ && this.isLevelEnabled(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLevelEnabled(String level) {
        TreeSet treeSet = this.levels_to_print_;
        synchronized (treeSet) {
            return this.print_all_levels_ || this.levels_to_print_.contains(level.toLowerCase());
        }
    }

    public void print(Object obj) {
        if (this.enabled_) {
            this.printMsg("", this.formatMessage("", Debug.objectToString(obj)));
        }
    }

    public void print(String level, Object obj) {
        if (this.enabled_ && this.isLevelEnabled(level)) {
            this.printMsg(level, this.formatMessage(level, Debug.objectToString(obj)) + CR);
        }
    }

    public void println(Object obj) {
        if (this.enabled_) {
            this.printMsg("", this.formatMessage("", Debug.objectToString(obj)) + CR);
        }
    }

    public void println(String level, Object obj) {
        if (this.enabled_ && this.isLevelEnabled(level)) {
            this.printMsg(level, this.formatMessage(level, Debug.objectToString(obj)) + CR);
        }
    }

    public String getStackTrace() {
        return this.getStackTrace(new Throwable(), 4, 10000);
    }

    public String getStackTrace(Throwable throwable) {
        return this.getStackTrace(throwable, 2, 10000);
    }

    public String getStackTraceLine() {
        return this.getStackTrace(4, 1);
    }

    public String getStackTrace(int from_line, int num_lines) {
        return this.getStackTrace(new Throwable(), from_line, num_lines);
    }

    public String getStackTrace(Throwable throwable, int from_line, int num_lines) {
        if (!this.enabled_) {
            return "";
        }
        StringBuffer stack_trace = new StringBuffer();
        PrintReaderWriter readerwriter = new PrintReaderWriter(4096);
        throwable.printStackTrace(readerwriter);
        while (from_line-- > 0) {
            readerwriter.readln();
        }
        while (num_lines-- > 0 && readerwriter.ready()) {
            String line = readerwriter.readln();
            stack_trace.append(line);
        }
        try {
            stack_trace.setLength(stack_trace.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
        return stack_trace.toString();
    }

    public static String objectToString(Object obj) {
        StringBuffer sbuf = new StringBuffer(30);
        if (obj == null) {
            sbuf.append("[null]");
            return sbuf.toString();
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            Class<?> type = c.getComponentType();
            int length = Array.getLength(obj);
            sbuf.append("(");
            sbuf.append(type.getName());
            sbuf.append("[");
            sbuf.append(length);
            sbuf.append("])");
            for (int count = 0; count < length - 1; ++count) {
                sbuf.append(Debug.objectToString(Array.get(obj, count)));
                sbuf.append(",");
            }
            if (length > 0) {
                sbuf.append(Debug.objectToString(Array.get(obj, length - 1)));
            }
        } else {
            sbuf.append(obj.toString());
        }
        return sbuf.toString();
    }

    public static void waitEnterPressed() {
        System.err.print("Press 'enter' to continue...");
        try {
            while (System.in.read() == -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String[] tokenize(String str) {
        StringTokenizer st = new StringTokenizer(str, " \t\n\r,");
        int len = st.countTokens();
        String[] tokens = new String[len];
        for (int i = 0; i < len; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public void startRefreshPropertiesThread(long refresh_time) {
        if (refresh_time > 0L) {
            if (this.refresh_properties_thread_ == null) {
                this.refresh_properties_thread_ = new RefreshPropertiesThread(this);
                this.refresh_properties_thread_.setRefreshTime(refresh_time);
                this.refresh_properties_thread_.setName("Debug - Refresh Properties");
                this.refresh_properties_thread_.setPriority(3);
                this.refresh_properties_thread_.setDaemon(true);
                this.refresh_properties_thread_.startThread();
            } else {
                this.refresh_properties_thread_.setRefreshTime(refresh_time);
            }
        } else {
            this.stopRefreshPropertiesThread();
        }
    }

    public void stopRefreshPropertiesThread() {
        if (this.refresh_properties_thread_ != null && this.refresh_properties_thread_.isAlive()) {
            this.refresh_properties_thread_.stopThread();
        }
    }

    public void setWriterToFile(String filename) {
        this.write_to_file_ = true;
        this.filename_ = filename;
        try {
            FileWriter file = new FileWriter(filename);
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFile(String filename) {
        File new_prop_file = new File(filename);
        if (!new_prop_file.exists()) {
            System.err.println("ERROR: Debug property file '" + filename + "' does not exist! Ignoring the setting!");
        } else {
            Object object = this.user_property_file_lock_;
            synchronized (object) {
                this.user_property_file_name_ = filename;
                this.user_property_file_ = new_prop_file;
                this.property_file_last_modified_ = 0L;
            }
            this.loadProperties();
        }
    }

    public void setWriter(Writer out) {
        out_ = out;
        this.write_to_file_ = false;
    }

    public Writer getWriter() {
        return out_;
    }

    public static Debug getInstance() {
        if (debug_instance_ == null) {
            debug_instance_ = new Debug();
        }
        return debug_instance_;
    }

    public void startDebugApplication(String[] arguments) {
        String[] valid_debug_args = new String[]{"debuglevels*", "debugmessage*", "debugfilename*", "debugrefresh#", "debugpropertiesfile*"};
        CommandArguments args = null;
        try {
            args = new CommandArguments(arguments, valid_debug_args);
        }
        catch (CommandArgumentException cae) {
            cae.printStackTrace();
        }
        if (args != null) {
            if (args.isSet("debuglevels")) {
                this.addLevelsToPrint((String)args.getValue("debuglevels"));
            }
            if (args.isSet("debugmessage")) {
                this.setMessageFormat((String)args.getValue("debugmessage"));
            }
            if (args.isSet("debugfilename")) {
                this.setWriterToFile((String)args.getValue("debugfilename"));
            }
            if (args.isSet("debugpropertiesfile")) {
                this.setPropertyFile((String)args.getValue("debugpropertiesfile"));
            }
            if (args.isSet("debugrefresh")) {
                this.refresh_properties_thread_.setRefreshTime(((Integer)args.getValue("debugrefresh")).longValue());
            }
        }
        String application_cmd_line = args.getArgumentAt(0);
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(application_cmd_line));
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        Vector<String> tokens = new Vector<String>();
        try {
            block9: while (true) {
                int code = tokenizer.nextToken();
                switch (code) {
                    case -1: {
                        break block9;
                    }
                    case 10: {
                        continue block9;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        tokens.addElement(tokenizer.sval);
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown token (code 0x0" + Integer.toHexString(code) + ") string=" + tokenizer.sval);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("Parse Error: ");
            e.printStackTrace();
        }
        if (this.isEnabled("debug_start_application")) {
            this.println("cmd line = " + application_cmd_line);
            this.println("tokens=" + tokens);
        }
        if (tokens.size() > 0) {
            String classname = (String)tokens.elementAt(0);
            String[] application_arguments = new String[tokens.size() - 1];
            application_arguments = tokens.toArray(application_arguments);
            this.executeMainMethod(classname, application_arguments);
        }
    }

    protected void executeMainMethod(String classname, String[] arguments) {
        try {
            Class[] paramtypes = new Class[]{String;.class};
            Class<?> application_class = Class.forName(classname);
            Method main_method = application_class.getDeclaredMethod("main", paramtypes);
            try {
                main_method.invoke(null, new Object[]{arguments});
            }
            catch (InvocationTargetException ite) {
                System.err.println("Invokation of class '" + classname + "' threw an exception:");
                throw ite.getTargetException();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Debug debug = Debug.getInstance();
        debug.startDebugApplication(args);
        debug.stopRefreshPropertiesThread();
    }

    protected void printRawMsg(String msg) {
        if (!this.enabled_) {
            return;
        }
        try {
            if (this.write_to_file_) {
                out_ = new FileWriter(this.filename_, true);
            }
            out_.write(msg);
            out_.flush();
            if (this.write_to_file_) {
                out_.close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.last_message_time_ = System.currentTimeMillis();
    }

    protected void printMsg(String level, String msg) {
        if (this.enabled_ && (this.isLevelEnabled(level) || level.length() == 0)) {
            this.printRawMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String formatMessage(String level, String msg) {
        if (this.message_format_ == null) {
            return msg;
        }
        StringBuffer message = new StringBuffer();
        Object object = this.message_format_lock_;
        synchronized (object) {
            for (int count = 0; count < this.message_format_.size(); ++count) {
                Object message_obj = this.message_format_.elementAt(count);
                if (message_obj instanceof String) {
                    message.append((String)message_obj);
                    continue;
                }
                message.append(((DebugMessageFormatObject)message_obj).getEvaluatedKeyword(level, msg, this));
            }
        }
        return message.toString();
    }

    protected long getLastDebugMessageTime() {
        return this.last_message_time_;
    }

    class PrintReaderWriter
    extends PrintWriter {
        char[] buf_;
        int pos_;

        public PrintReaderWriter(int len) {
            super(System.err);
            this.buf_ = new char[len];
            this.pos_ = 0;
        }

        public synchronized void println(char[] input) {
            System.arraycopy(input, 0, this.buf_, this.pos_, input.length);
            this.pos_ += input.length;
            this.buf_[this.pos_++] = 10;
        }

        public synchronized String readln() {
            int count;
            for (count = 0; this.buf_[count] != '\n' && count < this.pos_; ++count) {
            }
            char[] first_line = new char[count + 1];
            System.arraycopy(this.buf_, 0, first_line, 0, count + 1);
            this.pos_ -= count + 1;
            System.arraycopy(this.buf_, count + 1, this.buf_, 0, this.pos_);
            return new String(first_line);
        }

        public boolean ready() {
            return this.pos_ > 0;
        }
    }

    class RefreshPropertiesThread
    extends Thread {
        long refresh_time_;
        Debug debug_;
        boolean loop_ = true;

        public RefreshPropertiesThread(Debug debug) {
            this.debug_ = debug;
        }

        public void setRefreshTime(long refresh_time) {
            this.refresh_time_ = refresh_time;
        }

        public void startThread() {
            this.loop_ = true;
            super.start();
        }

        public void stopThread() {
            this.loop_ = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.loop_) {
                this.debug_.loadProperties();
                RefreshPropertiesThread refreshPropertiesThread = this;
                synchronized (refreshPropertiesThread) {
                    try {
                        this.wait(this.refresh_time_);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

