/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.widgets;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import static org.nuiton.i18n.I18n._;

public class MultipleSelectionPane<D, B extends BusinessEntity> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_LBL = "lbl";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_FILE_ENABLED = "addFile.enabled";
    public static final String BINDING_LIST_ENABLED = "list.enabled";
    public static final String BINDING_REMOVE_FILE_ENABLED = "removeFile.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQU8TQRSeFtrSAoIQEANGVDR6cKsJB5MSRCEVSVFCORB7cdoZ2yHT3XF2FpaL8Sf4E/TuxcSbJ+PBswcvxr9gjAevxjezbbcLW6mhh20z733f+963817f/kApV6JLe9j3LenZijWptXFvd/dxdY/W1Bp1a5IJ5UgUfBJJlKygYdI5dxW6UilpeL4Fz686TeHY1O5CF0oo56pDTt0GpUqhC1FEzXXz5U644AtPtlk7ouJYX//6mXxFXr5JIuQLUDcKrcyfhAo7GSyhJCMKTUClfZzn2K6DDMnsOugd1WerHLvuI9ykz9ELlCmhtMASyBS63H/LhsPgfaHQVNPjiglOy5SDwcyxt7BNFbrtyLpVaziSNq19iQmzPGYdMFKnyrU24zBCGNa0QlnOXLXpEMoVmtOyfcs9gC6sNfoMA7TUDoeQcQ1ZpZxvU5tQSSW8xh7I7iyNznZIBngVKo5rnKXNswLzwiqZBrYJ1+SL/9XeegALiYaqFNs7hwKMGgvLGWe7qi3s4CqntxSaidyBoCMTi+ofWtgo4SrlgJjobj441Umz3bna9OO55jSam8GEFBkHsZOR1PueUo4dzc2BI84+1en65Fo0OrqwUa5Jh3NdBUqfi/CFoWhfg/rlKnQ22hOc6fgNAUMyGzEIxs8Kxy+cj0QFpaQHx+Bo5fjEbkMomNWZI7OqCU30z/Tk1w/f3xfbA5qF2lOxqV37BQZHSEfAtWG69FgwnZ5iPL+JRaECLOaimOUzFyOs3AqDOKhnbLA03FrHbgMoUplvHz9NP/0ygJJFlOMOJkWs8x+irGpIcMHhxBd3V4yikYMheI5rbQqlOT504C2iM0sEKzxfZTYBd5d9MGEuxoSOkmr28+/J8ruVthEJEHa+Z3poRuoJSjObM5uaXdVaQ7G7aVi41CNOuG7iFlBCf+dEa2gWzfNOXKeDivrmvhR8T38tGdH617LhuNgPB6sF170Hx9U+ODLU1oNLTkWjjx/8g+F6XwylUzEoNFI7skl7cN08tZqTGRRKNfU/wgkkfwH8XH9gHwgAAA==";
    private static final Log log = LogFactory.getLog(MultipleSelectionPane.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addFile;
    protected Class<B> beanType;
    protected MultipleSelectionHandler<D, B, ?> handler;
    protected String lbl;
    protected JList list;
    protected DefaultListCellRenderer listCellRenderer;
    protected DefaultListModel listModel;
    protected MultipleSelectionPane<D, B> multipleSelectionPane = this;
    protected JButton removeFile;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        addPropertyChangeListener("handler", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getHandler() != null && getBean() != null) {
                    init();
                }
            }
        });
    
        list.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListSelectionModel selectionModel = list.getSelectionModel();
                    int selectionIndex = selectionModel.getLeadSelectionIndex();
                    String selected = (String)listModel.get(selectionIndex);
    
                    getHandler().openSelected(selected);
                }
            }
        });
    }
    
    public void init() {
        if (handler != null) {
            handler.init();
        }
    }
    
    public B getBean() {
        return getContextValue(getBeanType());
    }
    
    public void setBean(B bean) {
        if (bean != null) {
            setContextValue(bean);
        }
    }
    
    public Collection<D> getAddedDatas() {
        return handler.getAddedDatas();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultipleSelectionPane(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MultipleSelectionPane(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionPane(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MultipleSelectionPane(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionPane(boolean param0) {
        super(param0);
        $initialize();
    }

    public MultipleSelectionPane(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MultipleSelectionPane() {
        $initialize();
    }

    public MultipleSelectionPane(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.add();
    }

    public void doActionPerformed__on__removeFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.remove();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddFile() {
        return addFile;
    }

    public Class<B> getBeanType() {
        return beanType;
    }

    public MultipleSelectionHandler<D, B, ?> getHandler() {
        return handler;
    }

    public String getLbl() {
        return lbl;
    }

    public JList getList() {
        return list;
    }

    public DefaultListCellRenderer getListCellRenderer() {
        return listCellRenderer;
    }

    public DefaultListModel getListModel() {
        return listModel;
    }

    public JButton getRemoveFile() {
        return removeFile;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanType(Class<B> beanType) {
        Class<B> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setHandler(MultipleSelectionHandler<D, B, ?> handler) {
        MultipleSelectionHandler<D, B, ?> oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setLbl(String lbl) {
        String oldValue = this.lbl;
        this.lbl = lbl;
        firePropertyChange(PROPERTY_LBL, oldValue, lbl);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMultipleSelectionPane() {
        if (!allComponentsCreated) {
            return;
        }
        add(listCellRenderer);
        add($Table0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createAddFile() {
        $objectMap.put("addFile", addFile = new JButton());
        
        addFile.setName("addFile");
        addFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFile"));
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createLbl() {
        $objectMap.put("lbl", lbl = StringUtils.EMPTY);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListCellRenderer() {
        $objectMap.put("listCellRenderer", listCellRenderer = new DefaultListCellRenderer());
        
        listCellRenderer.setName("listCellRenderer");
    }

    protected void createListModel() {
        $objectMap.put("listModel", listModel = new DefaultListModel());
    }

    protected void createRemoveFile() {
        $objectMap.put("removeFile", removeFile = new JButton());
        
        removeFile.setName("removeFile");
        removeFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeFile"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMultipleSelectionPane();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(removeFile, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        addFile.setIcon(SwingUtil.getUIManagerActionIcon("add"));
        removeFile.setIcon(SwingUtil.getUIManagerActionIcon("remove"));
        list.setCellRenderer(listCellRenderer);
        list.setModel(listModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("multipleSelectionPane", multipleSelectionPane);
        createListModel();
        createListCellRenderer();
        createLbl();
        createHandler();
        createBeanType();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAddFile();
        createRemoveFile();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        // inline creation of multipleSelectionPane
        setName("multipleSelectionPane");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"lbl") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getLbl()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_FILE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                addFile.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_FILE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.chorem.vradi.ui.widgets.MultipleSelectionPane.this, BINDING_REMOVE_FILE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    removeFile.setEnabled(isEnabled() && (list.getSelectedIndex() != -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.chorem.vradi.ui.widgets.MultipleSelectionPane.this, BINDING_REMOVE_FILE_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                list.setEnabled(isEnabled());
            }
        });
    }

}