/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiTreeTableNode.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/tree/VradiTreeTableNode.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.tree;

import jaxx.runtime.swing.nav.treetable.NavTreeTableNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;

/**
 * Vradi node use to fill vradi tree table.
 * <p/>
 * User: sletellier
 */
public class VradiTreeTableNode extends NavTreeTableNode<VradiTreeTableNode> {

    private static final long serialVersionUID = 1L;

    public VradiTreeTableNode(String id) {
        super(id);
    }

    public VradiTreeTableNode(Class<?> internalClass,
                              String id,
                              String context,
                              NavTreeTableNodeChildLoador<?, ?, VradiTreeTableNode> loador) {
        super(internalClass, id, context, loador);
    }

    @Override
    public VradiTreeTableNode getContainerNode() {
        if (isRoot()) {
            // si on arrive sur le root, quelque chose ne va pas,
            // on bloque par null, a defaut de declancher une exception
            return this;
        }

        // cas final : sur un noeud de donnee + classe interne de donnee
        return super.getContainerNode();
    }
}
