/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusDataProvider.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/thesaurus/ThesaurusDataProvider.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.thesaurus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.beans.FormPagedResult;
import org.chorem.vradi.beans.QueryParameters;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.services.search.UnsupportedQueryException;
import org.chorem.vradi.ui.helpers.ToolTipHelper;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.tree.VradiDataProvider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/** @author sletellier */
public class ThesaurusDataProvider extends VradiDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(ThesaurusDataProvider.class);

    protected QueryParameters queryParameters;

    protected Map<Thesaurus, Integer> cachedMap;

    public ThesaurusDataProvider() {
    }

    public ThesaurusDataProvider(QueryParameters queryParameters) {
        cachedMap = new HashMap<Thesaurus, Integer>();
        this.queryParameters = queryParameters;
    }

    public boolean isCartography() {
        return queryParameters != null;
    }

    public Integer getNbFormsForThesaurus(Thesaurus thesaurus) {
        int result = 0;

        if (isCartography()) {
            Integer nb = cachedMap.get(thesaurus);
            if (nb != null) {
                result = nb;
            }
        } else {
            result = ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus);
        }
        return result;
    }

    public Collection<Thesaurus> getChildrenThesaurus(String thesaurusId) {
        if (isCartography()) {
            Set<Thesaurus> thesauruses = getChildrenCartography(thesaurusId).keySet();

            List<Thesaurus> sortedList = new ArrayList<Thesaurus>(thesauruses);
            Collections.sort(sortedList, VradiComparators.THESAURUS_COMPARATOR);
            return sortedList;
        }
        try {
            return VradiService.getVradiDataService().getChildrenThesaurus(thesaurusId);
        } catch (VradiException eee) {
            log.error("Cant get thesaurus children of node " + thesaurusId, eee);
        }
        return null;
    }

    protected Map<Thesaurus, Integer> getChildrenCartography(String thesaurusId) {
        Map<Thesaurus, Integer> map = null;
        try {
            map = VradiService.getVradiDataService().getChildrenCartography(thesaurusId, queryParameters);
        } catch (VradiException eee) {
            log.error("Exception occured on get children cartography of node " + thesaurusId, eee);
        } catch (UnsupportedQueryException eee) {
            log.error("Exception occured on get children cartography of node " + thesaurusId, eee);
        }
        if (map != null) {
            cachedMap.putAll(map);
        }
        return map;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String getCartographyToolTip(Thesaurus thesaurus) {

        Integer formsForThesaurus = getNbFormsForThesaurus(thesaurus);
        if (formsForThesaurus == null || formsForThesaurus == 0) {
            return null;
        }

        FormPagedResult pagedResult = new FormPagedResult();

        // Search only for this thesaurus
        List<Thesaurus> thesauruses = queryParameters.getThesaurus();
        queryParameters.clearThesaurus();
        queryParameters.addThesaurus(thesaurus);
        try {
            pagedResult = VradiService.getVradiDataService().findForms(queryParameters, pagedResult);
        } catch (VradiException eee) {
            log.error("Cant get tool tip for thesaurus " + thesaurus.getName(), eee);
        } catch (UnsupportedQueryException eee) {
            log.error("Cant get tool tip for thesaurus " + thesaurus.getName(), eee);
        }
        List<String> formToShow = pagedResult.getFormsIdsToShow();
        List<Form> formList = VradiService.getWikittyProxy().restore(Form.class, formToShow);

        // Revert
        queryParameters.setThesaurus(thesauruses);
        return ToolTipHelper.getToolTip(formList);
    }
}
