/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.task;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public abstract class AbstractProgressBarUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_SHOW_CANCEL_BUTTON = "showCancelButton";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_BUTTON_VISIBLE = "cancelButton.visible";
    public static final String BINDING_MSG_LABEL_TEXT = "msgLabel.text";
    public static final String BINDING_MSG_LABEL_VISIBLE = "msgLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRBdO7ET5wNCrESJCJL5kEAU64YGJQpJjCISGYKIkCLcsL5b7A3r22V3Lrk0iJ/AT4CeBomOClFQU9Ag/gJCFLSI2TvHF8OFWHDF3WnmvbdvZmdefSUFa8j5XRZF1IQBiA6nm6s7O1vNXe7BTW49IzQoQ5Inlyf5Bhn3e3EL5GKj7ujVLr1aUx2tAh4cYS/WyZiFA8ltm3MAcq6f4Vlb3e6lFyMdmkPVnqks1Rffv+Wf+89e5gmJNLorYimVk1hpJcN1khc+kGk8aY9VJQtaaMOIoIV+J12sJpm1d1iHPyFPyUidFDUzKAbkwuAlxxoxP9JAZljTgmEe3DWqZbi1a8zc3wBClWlRr60M79A9w3xBQ0GB2cd0NYugdSxZBDJl22q/xgKPy7UQQAVAzjjr1JVD15SSnAUpfKhjW0hKEUnBKWAUAXXW5BL74lARtfsIoJtx0IFKPey4Tj0BmeuDH7HbT5rw+syW+1hJtEsw5GzfZeKY0HRM0nvMNUjBhBhGD40/J+seppKZmvttppxgnP05W/709sub9cNBKuHZM5nQI3uAF4z1a25AuKNPJ1MUgpDV20wvNlCFS1yieEkWMoxtd9NoDs9Lbs3R6S1m2yhRGPn87v3sw49DJL9OxqRi/jpz+A1Sgjb2tq2kH+kbK7Gjif1RfE85bzhlPn/EQgk1qSzfQosMhGv2qSWfAas0ReBju5cj7MlCRk96xpqlDz/K269XDvuSQ5/zx8LT3hQekKIIpAh4vGLd7clcqXFteeirdEuy9ibnvmO6O6WV+H0pq/CiZAcqBJe/HIXucyW27f6uDqxSAAESJ2x6KSmiwgC3pBkCX/530WHg0d+MlQfQGNkTVjQl/0+ZSbx/Dtx0RMAgFruWLTY7SF3CSzb2GEPzJ2q48PW/uBhMYfkED78AJQMKc+sGAAA=";
    private static final Log log = LogFactory.getLog(AbstractProgressBarUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AbstractProgressBarUI abstractProgressBarUI = this;
    protected JButton cancelButton;
    protected String msg;
    protected JLabel msgLabel;
    protected JProgressBar progressBar;
    protected Boolean showCancelButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public abstract void cancel();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractProgressBarUI() {
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractProgressBarUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractProgressBarUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel();
    }

    public void doWindowClosing__on__abstractProgressBarUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public String getMsg() {
        return msg;
    }

    public JLabel getMsgLabel() {
        return msgLabel;
    }

    public JProgressBar getProgressBar() {
        return progressBar;
    }

    public Boolean getShowCancelButton() {
        return showCancelButton;
    }

    public Boolean isShowCancelButton() {
        return showCancelButton !=null && showCancelButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setMsg(String msg) {
        String oldValue = this.msg;
        this.msg = msg;
        firePropertyChange(PROPERTY_MSG, oldValue, msg);
    }

    public void setShowCancelButton(Boolean showCancelButton) {
        Boolean oldValue = this.showCancelButton;
        this.showCancelButton = showCancelButton;
        firePropertyChange(PROPERTY_SHOW_CANCEL_BUTTON, oldValue, showCancelButton);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAbstractProgressBarUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(msgLabel, BorderLayout.NORTH);
        add(progressBar, BorderLayout.CENTER);
        add(cancelButton, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("vradi.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createMsg() {
        $objectMap.put("msg", msg = null);
    }

    protected void createMsgLabel() {
        $objectMap.put("msgLabel", msgLabel = new JLabel());
        
        msgLabel.setName("msgLabel");
    }

    protected void createProgressBar() {
        $objectMap.put("progressBar", progressBar = new JProgressBar());
        
        progressBar.setName("progressBar");
        progressBar.setIndeterminate(true);
    }

    protected void createShowCancelButton() {
        $objectMap.put("showCancelButton", showCancelButton = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAbstractProgressBarUI();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cancelButton.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        // late initializer
        abstractProgressBarUI.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("abstractProgressBarUI", abstractProgressBarUI);
        createShowCancelButton();
        createMsg();
        createMsgLabel();
        createProgressBar();
        createCancelButton();
        // inline creation of abstractProgressBarUI
        setName("abstractProgressBarUI");
        abstractProgressBarUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.progressBar.title"));
        abstractProgressBarUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__abstractProgressBarUI"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_TEXT, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setText(_(getMsg()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MSG_LABEL_VISIBLE, true ,"msg") {
        
            @Override
            public void processDataBinding() {
                msgLabel.setVisible(getMsg() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CANCEL_BUTTON_VISIBLE, true ,"showCancelButton") {
        
            @Override
            public void processDataBinding() {
                cancelButton.setVisible(isShowCancelButton());
            }
        });
    }

}