/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.models.RequestFieldMenu;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.nuiton.widget.editor.Editor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SearchUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_OFFER_LIST_UI = "offerListUI";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_REQUEST_MODEL = "requestModel";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUPS_VISIBLE = "groups.visible";
    public static final String BINDING_REQUESTS_VISIBLE = "requests.visible";
    public static final String BINDING_REQUEST_AREA_TEXT = "requestArea.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$HIDOR_BUTTON0_VISIBLE = "$HidorButton0.visible";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28TRxSeuNiJCaEhEZSKXwHMoUIal/44BRVIIODIgQonCNWXjnfH9qD1zjDzNtlcqv4J/RPKnQsSt56qHnruoRfEv4AQB66IN7trrzcsjqX1Ydcz773vffPmvc9+/oaUjSYXn7AwpDrwQQw43bz1+PGDzhPuwG1uHC0USE3iz0yJlNpk3h3tGyCX200bXk/C6+tyoKTP/bHo1SY5amDf46bPOQA5l41wjKm3RubVUAV6iDoilYf657u3pT/c35+VCAkVslvCo6wcFpWe5EiTlIQLZAkz7bK6x/we0tDC7yHfBbu37jFj7rMBf0p+I7NNUlFMIxiQS9MfOcKI4kMFZLa2zToe/xbLJnWPOn2p+YDuauYKGghqONNOn7ai105DqSiygnGaPw24wdSLlhi1ZGlMNnWal90u101hYKcB5ETquCalx5k/BtcXruVhlyfS7UXNTeBBRHFLutwD8kMezSgPHVgPQx8Mk6ZhKeKxhHeCtmI5hdTsIW96m3cZZsPideSaDA9EztU2m6zDPSzV0nhUvGudqiPfSk/LQGEvnsx4DpGzznMJpWh9IWtLrucakNOZPooBt4clSwMWapstR0vP+5n59la/yhBITdb9UnpRCYVbmjMgV22Ju6LLbWm12feBhcBDwF5j9GErWm/j2npbgCsH6X5nl7VsikrcSkCWM4zWAgDpW5+rKRuHaZA9zVR/327Vs+ayg72jcwwLtXvClTqGxLOfzynZmEc2uIpzAlwLhrd2ZcIorCduO42k8JqcyeRB8aCpeKTTPdMmZR3gNt5l+1O9eYimWGlOH1AaCxhZP5xa/v+v1y83hvKyjLlP5rqOqSOOvdJScQ3Cpv4y1pYAhFffYmq1TaqGeyitkXSezSHWSsxIDvPFQ2zD6T1m+ghRnn319z+nfv3vC1LaIEc9ydwNZv0bpAp9nN++9NxQ3bgZMTq2N4fPRcsNyBHbVDhN14XvCZ+vMED96ATAfwqxDGdzyjDi0qn++3659eLmsBQzSO3rz7qn5Sj/QipxtkhrExnN1dZ5ZXjgylQu8wR0xr7PqEQlbkTP9byzzu4KI3A0gBy/7jJgKx3hu9iQeFQbczc6g/3WmBqyHOmdNd/PBzk/BQiKj+9yzXUhHLu9VRihNQHhYmEOhyNgK8Zid8cVgHcTTfEExG+m4nSnEAJOiXBirfoMBp2exUYRhEkdcq0wh+II308zhfg3g28LNeEoP04Dg6K2Vxymgr+oPQ4FURZilEexvhQCO2yELMJHHml+A6ILAAA=";
    private static final Log log = LogFactory.getLog(SearchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cartography;
    protected JButton clear;
    protected CriteriaUI criterias;
    protected JComboBox groups;
    protected Boolean hidable;
    protected Boolean offerListUI;
    protected String request;
    protected RSyntaxTextArea requestArea;
    protected DefaultComboBoxModel requestModel;
    protected JComboBox requests;
    protected OfferListTableModel resultTableModel;
    protected JButton search;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SearchUI $Table0 = this;
    private JLabel $JLabel0;
    private Table $Table1;
    private JScrollPane $JScrollPane0;
    private Table $Table2;
    private HidorButton $HidorButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchHandler getHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        requestArea.getDocument().addDocumentListener(new DocumentListener() {
    
            @Override
            public void insertUpdate(DocumentEvent e) {
                textAsChanged();
            }
    
            @Override
            public void removeUpdate(DocumentEvent e) {
                textAsChanged();
            }
    
            @Override
            public void changedUpdate(DocumentEvent e) {
                textAsChanged();
            }
        });
        requests.setRenderer(new ListCellRenderer(){
    
            public static final int TEXT_LENGTH_LIMIT = 130;
    
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                JLabel label = new JLabel();
                if (value instanceof String) {
                    text = (String)value;
                } else {
    
                    QueryBean bean = (QueryBean) value;
    
                    if (bean == null) {
                        return new JLabel("");
                    }
    
                    StringBuffer buf = new StringBuffer();
                    buf.append("[");
                    buf.append(bean.getName());
                    buf.append("] ");
                    buf.append(bean.getQuery());
    
                    text = buf.toString();
                    label.setToolTipText(bean.getDescription());
                }
                text = StringUtils.abbreviate(text, TEXT_LENGTH_LIMIT);
                label.setText(text);
    
                return label;
            }
        });
    
        // Add items to menu
        JPopupMenu popupMenu = requestArea.getPopupMenu();
        popupMenu.add(new JSeparator());
        popupMenu.add(new RequestFieldMenu(this));
    }
    
    protected void textAsChanged() {
        setRequest(requestArea.getText());
    }
    
    protected void keyReleased(KeyEvent keyEvent) {
        if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
            executeQuery();
        }
    }
    
    public void executeQuery() {
        getHandler().executeQuery(this, 1);
    }
    
    protected void executeCartography() {
        getHandler().executeCartography(this);
    }
    
    protected void updateRequests() {
        getHandler().updateRequests(this);
    }
    
    protected String getRequestAsString(Object selected) {
        if (selected == null) {
            return null;
        }
        if (selected instanceof String) {
            return (String)selected;
        }
        QueryBean queryBean = (QueryBean) selected;
        return queryBean.getQuery();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchUI() {
        $initialize();
    }

    public SearchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cartography(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        executeCartography();
    }

    public void doActionPerformed__on__clear(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setRequest("");
    }

    public void doActionPerformed__on__groups(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateRequests();
    }

    public void doActionPerformed__on__requests(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setRequest(getRequestAsString(requests.getSelectedItem()));
    }

    public void doActionPerformed__on__search(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        executeQuery();
    }

    public void doKeyReleased__on__requestArea(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        keyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCartography() {
        return cartography;
    }

    public JButton getClear() {
        return clear;
    }

    public CriteriaUI getCriterias() {
        return criterias;
    }

    public JComboBox getGroups() {
        return groups;
    }

    public Boolean getHidable() {
        return hidable;
    }

    public Boolean getOfferListUI() {
        return offerListUI;
    }

    public String getRequest() {
        return request;
    }

    public RSyntaxTextArea getRequestArea() {
        return requestArea;
    }

    public DefaultComboBoxModel getRequestModel() {
        return requestModel;
    }

    public JComboBox getRequests() {
        return requests;
    }

    public OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public JButton getSearch() {
        return search;
    }

    public Boolean isHidable() {
        return hidable !=null && hidable;
    }

    public Boolean isOfferListUI() {
        return offerListUI !=null && offerListUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHidable(Boolean hidable) {
        Boolean oldValue = this.hidable;
        this.hidable = hidable;
        firePropertyChange(PROPERTY_HIDABLE, oldValue, hidable);
    }

    public void setOfferListUI(Boolean offerListUI) {
        Boolean oldValue = this.offerListUI;
        this.offerListUI = offerListUI;
        firePropertyChange(PROPERTY_OFFER_LIST_UI, oldValue, offerListUI);
    }

    public void setRequest(String request) {
        String oldValue = this.request;
        this.request = request;
        firePropertyChange(PROPERTY_REQUEST, oldValue, request);
    }

    public void setRequestModel(DefaultComboBoxModel requestModel) {
        DefaultComboBoxModel oldValue = this.requestModel;
        this.requestModel = requestModel;
        firePropertyChange(PROPERTY_REQUEST_MODEL, oldValue, requestModel);
    }

    public void setResultTableModel(OfferListTableModel resultTableModel) {
        OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = resultTableModel;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, resultTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCartography() {
        $objectMap.put("cartography", cartography = new JButton());
        
        cartography.setName("cartography");
        cartography.setText(_("vradi.criteria.cartography"));
        cartography.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cartography"));
    }

    protected void createClear() {
        $objectMap.put("clear", clear = new JButton());
        
        clear.setName("clear");
        clear.setText(_("vradi.criteria.clear"));
        clear.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clear"));
    }

    protected void createCriterias() {
        $objectMap.put("criterias", criterias = new CriteriaUI(this));
        
        criterias.setName("criterias");
    }

    protected void createGroups() {
        $objectMap.put("groups", groups = new JComboBox());
        
        groups.setName("groups");
        groups.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groups"));
    }

    protected void createHidable() {
        $objectMap.put("hidable", hidable = true);
    }

    protected void createOfferListUI() {
        $objectMap.put("offerListUI", offerListUI = false);
    }

    protected void createRequest() {
        $objectMap.put("request", request = "");
    }

    protected void createRequestArea() {
        $objectMap.put("requestArea", requestArea = new RSyntaxTextArea());
        
        requestArea.setName("requestArea");
        requestArea.setColumns(15);
        requestArea.setLineWrap(true);
        requestArea.setWrapStyleWord(true);
        requestArea.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__requestArea"));
    }

    protected void createRequestModel() {
        $objectMap.put("requestModel", requestModel = getHandler().getRequestModel());
    }

    protected void createRequests() {
        $objectMap.put("requests", requests = new JComboBox());
        
        requests.setName("requests");
        requests.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__requests"));
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearch() {
        $objectMap.put("search", search = new JButton());
        
        search.setName("search");
        search.setText(_("vradi.criteria.search"));
        search.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__search"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(groups, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(requests, new GridBagConstraints(2, 0, 1, 1, 0.7, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(criterias, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(requestArea);
        // inline complete setup of $Table2
        $Table2.add(search, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(cartography, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(clear, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($HidorButton0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        groups.setModel(UIHelper.getGroupModel(true));
        groups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        requests.setModel(requestModel);
        requestArea.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_SQL);
        search.setIcon(SwingUtil.getUIManagerActionIcon("search"));
        cartography.setIcon(SwingUtil.getUIManagerActionIcon("search"));
        $HidorButton0.setHideTip(_("vradi.criteria.collapse"));
        $HidorButton0.setShowTip(_("vradi.criteria.notCollapse"));
        $HidorButton0.setTarget(criterias);
        $HidorButton0.setTargetVisible(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createRequest();
        createOfferListUI();
        createHidable();
        createResultTableModel();
        createRequestModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.list.requests"));
        createGroups();
        createRequests();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createRequestArea();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSearch();
        createCartography();
        createClear();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createCriterias();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                groups.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUESTS_VISIBLE, true ,"offerListUI") {
        
            @Override
            public void processDataBinding() {
                requests.setVisible(isOfferListUI());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_AREA_TEXT, true ,"request") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(requestArea, getRequest());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$HIDOR_BUTTON0_VISIBLE, true ,"hidable") {
        
            @Override
            public void processDataBinding() {
                $HidorButton0.setVisible(isHidable());
            }
        });
    }

}