/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.search;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.nuiton.wikitty.entities.WikittyExtension;
import static org.nuiton.i18n.I18n._;

public class CriteriaUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATE_SELECTION_MODEL = "dateSelectionModel";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_TYPE_SELECTION_MODEL = "dateTypeSelection.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXQW8bRRTHJ6Z24qSlNKFpAymktFWFQOuQlEYiUUmbEJJgQ1UHFNUIMfZO4kl3d5bZ2WTDAfER+Ahw54LErSfEgTMHLogvwAFQD70i3qzXu9l6Mh6xOdjxvvd+839/z7xJvv8LlQOOrh7gKLJ46AnqEmv77u7uR+0D0hHrJOhw6gvGUe9npIRKLTRhp88Dga616rK8lpTX1pjrM494J6qX62g8EMcOCbqECIGu5Cs6QVBrpuHlyA95n5qKUlG/ffJP6Rv76+9KCEU+qHsFWpkbVpV1cqaOStQWaBJWOsQ1B3v7IINTbx/0npPP1hwcBB9il3yBvkKjdVTxMQeYQK+Ztxwz4vrIF6iyRx1BuEA3GN+3Ol3GiWsdcmxTK6RWQDDvdK01TiGH4o+3fD8urYBIGwvSJA58K5R5DWYTR8hmD3FkBUeg2Vonezh0BGhps3ssilOy+uk9xt2dY3+AMXOScUrx6PUd3HbIvECXc/b2iuKYzKymBWPXt+u4TRyomDzJ7z2VSZNZ7h5n7jp0B/1IUw5gdz0SzO+VRNb2rgzep51HhCsqN1kIdl7MrdJv45n0RNRb8vOlfGxcohrUC0XcyRV15YKisiKY1Cc/vTQQkeI0vEUFb0ywU3Uk30PcwIt5x8s7IONYoKmcEfdCIZgnU97MILAhBeTKj/P5UFWGGswTXUVwXAYX5218HCiiibQFhbR+t7fSbpfS2IWBbZm2vTQAeFsFkOdiGCARt6gRdztl383OXOQ6MBAIdlO4QAuag9uA80d9J9Pynk1hFuSp/RWXFCueDwQWYZDr5f18yrlOMh3uY0+e30uKE7mZ7H1ok6OXcwkwa61s1mbDcKSFyjyEx3DGW4Pj+QGEeoP58jODWQLj6L/TU789/uPHjf40vglrX1SmnrhMYEr6nPkwEalc+nxvFIeCOrUG9pdbqBrEXsQ3zaxCWDMJgzhY74Ist2S5tYmDLiDKo7//9PP0578+h0obsIUZtjewzN9CVdHl4AJz7Mh/dzVWdPZoDF5fkNoEOiNIBKN+coV6DvXIHBZwN7ThYN6JwIZZhQ2plnb1l6dTzR9W+1aMgLSZU9MzO8oPUaW3Wnw1JbeO8iqa8AMS2iy7XVT3zYh8n/aTQb4Tv+4qe7Xj+fv8CrzjuTb1bNhG0Kcs+DRuQP72WcybMeCVXXmByHBHDZk1gIzBXWsT3pv6BThne1uI2FuCuIVY8vFD+dJSE141InQ1Gq4aEXRdmBF0npoRdD5cMyK0NRpuFHbyZmEnzQg6J80IOidfL+zDG4V9MCPofDAj6HyoFSYsFCbcKky4bTCtJlzqUTd0m/RLorH0ncJihhPgPnZxJMU8YEdrDK4uDW6l8E41I+h2qhnhsYZwp7CtZgSdD6uFfTAj6HxYL+zDcAL8v4Ed5xPshCTQSNkwAbUJ9tK/fP43aJgrW4VdMSP8qdHwgRHh7yGE/wB27enb+REAAA==";
    private static final Log log = LogFactory.getLog(CriteriaUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton ToDay;
    protected HBox criteriaPanel;
    protected DefaultComboBoxModel dateSelectionModel;
    protected JComboBox dateTypeSelection;
    protected CriteriaUI filter = this;
    protected JComboBox formTypeSelection;
    protected ComboBoxModel formTypeSelectionModel;
    protected JXDatePicker fromDate;
    protected JComboBox fromHour;
    protected JComboBox fromMinute;
    protected JButton last30days;
    protected JButton lastDay;
    protected JButton lastMonth;
    protected MultipleSelectionEditor<Status> statusSelection;
    protected JXDatePicker toDate;
    protected JComboBox toHour;
    protected JComboBox toMinute;
    protected MultipleSelectionEditor<XmlStream> xmlStreamSelection;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private Table $Table3;
    private JLabel $JLabel6;
    private JLabel $JLabel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    void $afterCompleteSetup() {
        updateDateSelectionModel();
    }
    protected void updateDateSelectionModel() {
        setDateSelectionModel(getHandler().updateDateSelectionModel(
                (WikittyExtension)formTypeSelection.getSelectedItem()));
        if (log.isDebugEnabled()) {
            for(int i = 0 ; i < dateSelectionModel.getSize() ; i++) {
                log.debug(dateSelectionModel.getElementAt(i));
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CriteriaUI() {
        $initialize();
    }

    public CriteriaUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__ToDay(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        fromDate.setDate(new Date()); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                  toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__formTypeSelection(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateDateSelectionModel();
    }

    public void doActionPerformed__on__last30days(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        fromDate.setDate(DateUtils.addDays(new Date(), -30)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                  toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__lastDay(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        fromDate.setDate(DateUtils.truncate(DateUtils.addDays(new Date(), -1), Calendar.DAY_OF_MONTH)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                  toDate.setDate(DateUtils.truncate(DateUtils.addDays(new Date(), -1), Calendar.DAY_OF_MONTH)); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__lastMonth(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        fromDate.setDate(DateUtils.truncate(new Date(), Calendar.MONTH)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                  toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public HBox getCriteriaPanel() {
        return criteriaPanel;
    }

    public DefaultComboBoxModel getDateSelectionModel() {
        return dateSelectionModel;
    }

    public JComboBox getDateTypeSelection() {
        return dateTypeSelection;
    }

    public JComboBox getFormTypeSelection() {
        return formTypeSelection;
    }

    public ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public JXDatePicker getFromDate() {
        return fromDate;
    }

    public JComboBox getFromHour() {
        return fromHour;
    }

    public JComboBox getFromMinute() {
        return fromMinute;
    }

    public JButton getLast30days() {
        return last30days;
    }

    public JButton getLastDay() {
        return lastDay;
    }

    public JButton getLastMonth() {
        return lastMonth;
    }

    public MultipleSelectionEditor<Status> getStatusSelection() {
        return statusSelection;
    }

    public JXDatePicker getToDate() {
        return toDate;
    }

    public JButton getToDay() {
        return ToDay;
    }

    public JComboBox getToHour() {
        return toHour;
    }

    public JComboBox getToMinute() {
        return toMinute;
    }

    public MultipleSelectionEditor<XmlStream> getXmlStreamSelection() {
        return xmlStreamSelection;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDateSelectionModel(DefaultComboBoxModel dateSelectionModel) {
        DefaultComboBoxModel oldValue = this.dateSelectionModel;
        this.dateSelectionModel = dateSelectionModel;
        firePropertyChange(PROPERTY_DATE_SELECTION_MODEL, oldValue, dateSelectionModel);
    }

    public void setFormTypeSelectionModel(ComboBoxModel formTypeSelectionModel) {
        ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = formTypeSelectionModel;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, formTypeSelectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilter() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($Table3, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(criteriaPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createCriteriaPanel() {
        $objectMap.put("criteriaPanel", criteriaPanel = new HBox());
        
        criteriaPanel.setName("criteriaPanel");
    }

    protected void createDateSelectionModel() {
        $objectMap.put("dateSelectionModel", dateSelectionModel = new DefaultComboBoxModel());
    }

    protected void createDateTypeSelection() {
        $objectMap.put("dateTypeSelection", dateTypeSelection = new JComboBox());
        
        dateTypeSelection.setName("dateTypeSelection");
    }

    protected void createFormTypeSelection() {
        $objectMap.put("formTypeSelection", formTypeSelection = new JComboBox());
        
        formTypeSelection.setName("formTypeSelection");
        formTypeSelection.setMaximumRowCount(30);
        formTypeSelection.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeSelection"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel(true));
    }

    protected void createFromDate() {
        $objectMap.put("fromDate", fromDate = new JXDatePicker());
        
        fromDate.setName("fromDate");
    }

    protected void createFromHour() {
        $objectMap.put("fromHour", fromHour = new JComboBox());
        
        fromHour.setName("fromHour");
    }

    protected void createFromMinute() {
        $objectMap.put("fromMinute", fromMinute = new JComboBox());
        
        fromMinute.setName("fromMinute");
    }

    protected void createLast30days() {
        $objectMap.put("last30days", last30days = new JButton());
        
        last30days.setName("last30days");
        last30days.setText(_("vradi.criteria.searchLast30days"));
        last30days.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__last30days"));
    }

    protected void createLastDay() {
        $objectMap.put("lastDay", lastDay = new JButton());
        
        lastDay.setName("lastDay");
        lastDay.setText(_("vradi.criteria.searchLastDay"));
        lastDay.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastDay"));
    }

    protected void createLastMonth() {
        $objectMap.put("lastMonth", lastMonth = new JButton());
        
        lastMonth.setName("lastMonth");
        lastMonth.setText(_("vradi.criteria.searchThisMonth"));
        lastMonth.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastMonth"));
    }

    protected void createStatusSelection() {
        $objectMap.put("statusSelection", statusSelection = new MultipleSelectionEditor<Status>());
        
        statusSelection.setName("statusSelection");
    }

    protected void createToDate() {
        $objectMap.put("toDate", toDate = new JXDatePicker());
        
        toDate.setName("toDate");
    }

    protected void createToDay() {
        $objectMap.put("ToDay", ToDay = new JButton());
        
        ToDay.setName("ToDay");
        ToDay.setText(_("vradi.criteria.searchToDay"));
        ToDay.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ToDay"));
    }

    protected void createToHour() {
        $objectMap.put("toHour", toHour = new JComboBox());
        
        toHour.setName("toHour");
    }

    protected void createToMinute() {
        $objectMap.put("toMinute", toMinute = new JComboBox());
        
        toMinute.setName("toMinute");
    }

    protected void createXmlStreamSelection() {
        $objectMap.put("xmlStreamSelection", xmlStreamSelection = new MultipleSelectionEditor<XmlStream>());
        
        xmlStreamSelection.setName("xmlStreamSelection");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFilter();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(fromDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(fromHour, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(fromMinute, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(toDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(toHour, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(toMinute, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(ToDay, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(lastDay, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(lastMonth, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(last30days, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(formTypeSelection, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(dateTypeSelection, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(xmlStreamSelection, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(statusSelection, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        fromDate.setDate(new java.util.Date());
        fromHour.setModel(UIHelper.getHourModel());
        fromHour.setRenderer(UIHelper.get2DigitsRenderer());
        fromHour.setSelectedItem(0);
        fromMinute.setModel(UIHelper.getMinuteModel());
        fromMinute.setRenderer(UIHelper.get2DigitsRenderer());
        fromMinute.setSelectedItem(0);
        toDate.setDate(new java.util.Date());
        toHour.setModel(UIHelper.getHourModel());
        toHour.setRenderer(UIHelper.get2DigitsRenderer());
        toHour.setSelectedItem(23);
        toMinute.setModel(UIHelper.getMinuteModel());
        toMinute.setRenderer(UIHelper.get2DigitsRenderer());
        toMinute.setSelectedItem(59);
        $JLabel4.setMinimumSize(new Dimension(0,0));
        formTypeSelection.setModel(formTypeSelectionModel);
        formTypeSelection.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel5.setMinimumSize(new Dimension(0,0));
        dateTypeSelection.setRenderer(getHandler().getDateTypeComboBoxRenderer());
        $JLabel6.setMinimumSize(new Dimension(0,0));
        xmlStreamSelection.setAllValues(getHandler().getAllStreams());
        xmlStreamSelection.setBeanClass(XmlStream.class);
        $JLabel7.setMinimumSize(new Dimension(0,0));
        statusSelection.setAllValues(getHandler().getAllStatuses());
        statusSelection.setBeanClass(Status.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("filter", filter);
        createDateSelectionModel();
        createFormTypeSelectionModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.criteria.from"));
        createFromDate();
        createFromHour();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createFromMinute();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.criteria.to"));
        createToDate();
        createToHour();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.common.timeseparator"));
        createToMinute();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createToDay();
        createLastDay();
        createLastMonth();
        createLast30days();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.criteria.formType"));
        createFormTypeSelection();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.criteria.typeDate"));
        createDateTypeSelection();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.criteria.xmlStream"));
        createXmlStreamSelection();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.criteria.status"));
        createStatusSelection();
        createCriteriaPanel();
        // inline creation of filter
        setName("filter");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DATE_TYPE_SELECTION_MODEL, true ,"dateSelectionModel") {
        
            @Override
            public void processDataBinding() {
                dateTypeSelection.setModel(getDateSelectionModel());
            }
        });
    }

}