/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.search;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.helpers.UIHelper;
import static org.nuiton.i18n.I18n._;

public class CriteriaField extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIF = "actif";
    public static final String PROPERTY_DELETABLE = "deletable";
    public static final String PROPERTY_LABEL_NAME = "labelName";
    public static final String PROPERTY_ROOT_THESAURUS = "rootThesaurus";
    public static final String PROPERTY_THESAURUS = "thesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_ENABLED = "combo.enabled";
    public static final String BINDING_LABEL_ENABLED = "label.enabled";
    public static final String BINDING_LABEL_TEXT = "label.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TsW4TQRAdO3GMEwIBKyGIgBJAkAKtI9ogCDGySGRAilNEuGF9t9gbrW+X3b3koEB8Ap8APQ0SHRWioKagQfwCQhS0iNk722eTC8TF3XnmzZu3s2/efIeC0bC0S6OI6DCwvMvI5u2dnQetXebZO8x4misrNSS/XB7yTZjyB3Fj4VKz7sorvfJKVXaVDFgwVL1ah0ljnwpmOoxZC+dHKzxjKo1BejVSoe6zDkRlsb76+SP/0n/xOg8QKVRXwqMs/q8qPcl4HfLct3AaO+3RiqBBG2VoHrRR77SLVQU15j7tsifwHIp1mFBUI5mFi0c/cswR10cKe+1p6vOq5pZpTmucCRSwLHWbeB2pWZfEeRJyYhjVXoeMQJWKmSYslARtMeGkWZhxUomTTxL5QzDbYYaGOnT3dKALCuaWM0O2+6i0clpLabfT6quHV28NI4d6+0wwS1v4gFOpxHUpBaNBiitQz/LH7s+ZNFi+3IgHuRFgDyr4M6ZXLFyJL9fDaXPBNElmTQ4gh7jjMeHYXf+ImH2cDtmsu6BDlFIgkrakhdkRYNUF12XUw2o4N+Iu9C1JfZsaK9eEgg4xbGG+edDqW5hKTD7/l8kdYZz9PVf+8v7bu1rf2WPYezYTOrSY6DilpWLa3YqFk4mtQ8tF5R5Vq03cD7wRL9nahQxhjV4axWG/5M5cOblLTQcpCsWvHz7OPfo8BvkaTApJ/Rp1+A3nM41TkMKP1K21WNHx/WP4nHHaLBRZ4IyAXj9xw6eWLrZ44OOIb0Y4hYWMKQyktEqffpUbb9f6k8ihsrOHwtNpFB7CBA8ED1i85b0FztzqKWVY6Mt0UbNWN+feF1TPWsvx81rWUccti6zLVqLQvVZi0e7r+hE5XJj8g2EJGf4AesuMSbkFAAA=";
    private static final Log log = LogFactory.getLog(CriteriaField.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean actif;
    protected JComboBox combo;
    protected Boolean deletable;
    protected JLabel label;
    protected String labelName;
    protected RootThesaurus rootThesaurus;
    protected Thesaurus thesaurus;
    protected CriteriaField vradiCriteriaField = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Item rootItem;
    
    
    protected SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    public void init(){
        if (isDeletable()){
            addMouseListener(new MouseAdapter() {
    
                @Override
                public void mouseClicked(final MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuRemoveCriteria = new JMenuItem();
                        menuRemoveCriteria.setText(_("vradi.menu.removeCriteria"));
                        menuRemoveCriteria.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                removeCriteriaSelected();
                            }
                        });
                        popup.add(menuRemoveCriteria);
                        popup.show(vradiCriteriaField, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }
    
    protected void removeCriteriaSelected(){
        if (getThesaurus() != null) {
            getHandler().removeCriteriaAndPersist(this, getThesaurus());
        } else {
            getHandler().removeRootCriteriaAndPersist(this, getRootThesaurus());
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CriteriaField() {
        $initialize();
    }

    public CriteriaField(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getActif() {
        return actif;
    }

    public JComboBox getCombo() {
        return combo;
    }

    public Boolean getDeletable() {
        return deletable;
    }

    public JLabel getLabel() {
        return label;
    }

    public String getLabelName() {
        return labelName;
    }

    public RootThesaurus getRootThesaurus() {
        return rootThesaurus;
    }

    public Thesaurus getThesaurus() {
        return thesaurus;
    }

    public Boolean isActif() {
        return actif !=null && actif;
    }

    public Boolean isDeletable() {
        return deletable !=null && deletable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActif(Boolean actif) {
        Boolean oldValue = this.actif;
        this.actif = actif;
        firePropertyChange(PROPERTY_ACTIF, oldValue, actif);
    }

    public void setDeletable(Boolean deletable) {
        Boolean oldValue = this.deletable;
        this.deletable = deletable;
        firePropertyChange(PROPERTY_DELETABLE, oldValue, deletable);
    }

    public void setLabelName(String labelName) {
        String oldValue = this.labelName;
        this.labelName = labelName;
        firePropertyChange(PROPERTY_LABEL_NAME, oldValue, labelName);
    }

    public void setRootThesaurus(RootThesaurus rootThesaurus) {
        RootThesaurus oldValue = this.rootThesaurus;
        this.rootThesaurus = rootThesaurus;
        firePropertyChange(PROPERTY_ROOT_THESAURUS, oldValue, rootThesaurus);
    }

    public void setThesaurus(Thesaurus thesaurus) {
        Thesaurus oldValue = this.thesaurus;
        this.thesaurus = thesaurus;
        firePropertyChange(PROPERTY_THESAURUS, oldValue, thesaurus);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVradiCriteriaField() {
        if (!allComponentsCreated) {
            return;
        }
        add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        add(combo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createActif() {
        $objectMap.put("actif", actif = true);
    }

    protected void createCombo() {
        $objectMap.put("combo", combo = new JComboBox());
        
        combo.setName("combo");
    }

    protected void createDeletable() {
        $objectMap.put("deletable", deletable = false);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
    }

    protected void createLabelName() {
        $objectMap.put("labelName", labelName = "");
    }

    protected void createRootThesaurus() {
        $objectMap.put("rootThesaurus", rootThesaurus = null);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToVradiCriteriaField();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("vradiCriteriaField", vradiCriteriaField);
        createLabelName();
        createThesaurus();
        createRootThesaurus();
        createDeletable();
        createActif();
        rootItem = null;
        createLabel();
        createCombo();
        // inline creation of vradiCriteriaField
        setName("vradiCriteriaField");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_ENABLED, true ,"actif") {
        
            @Override
            public void processDataBinding() {
                label.setEnabled(isActif());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"labelName") {
        
            @Override
            public void processDataBinding() {
                label.setText(_(getLabelName()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_ENABLED, true ,"actif") {
        
            @Override
            public void processDataBinding() {
                combo.setEnabled(isActif());
            }
        });
    }

}