/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EntityRenderer.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/renderers/EntityRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.renderers;

import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import java.awt.Component;

/** @author sletellier <letellier@codelutin.com> */
public class EntityRenderer extends ObjectToStringConverter implements
        ListCellRenderer {

    private static EntityRenderer instance = null;

    protected DefaultListCellRenderer delegate = new DefaultListCellRenderer();

    @Override
    public String getPreferredStringForItem(Object item) {
        String result = null;
        if (item != null) {

            if (item instanceof User) {
                User user = (User) item;
                String clientId = user.getClient();
                Client client = VradiService.getWikittyProxy().restore(
                        Client.class, clientId);
                String clientString = "";
                if (client != null) {
                    clientString = client.getName() + " - ";
                }
                result = clientString + user.getName();
            } else if (item instanceof Group) {
                Group group = (Group) item;
                result = group.getName();
            }
        }
        return result;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
                                                  int index, boolean isSelected, boolean cellHasFocus) {

        return delegate.getListCellRendererComponent(list,
                                                     getPreferredStringForItem(value), index, isSelected,
                                                     cellHasFocus);
    }

    public static EntityRenderer getInstance() {
        if (instance == null) {
            instance = new EntityRenderer();
        }
        return instance;
    }
}
