/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferListColumnFactory;
import org.chorem.vradi.ui.offer.OfferTable;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.search.PaginationUI;
import org.chorem.vradi.ui.search.SearchHandler;
import org.chorem.vradi.ui.search.SearchUI;
import static org.nuiton.i18n.I18n._;

public class SelectFormUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FORM_ID = "formId";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectFormUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String formId;
    protected OfferListColumnFactory offerListColumnFactory;
    protected PaginationUI paginationUI;
    protected OfferTable resultTable;
    protected OfferListTableModel resultTableModel;
    protected JPanel searchPanel;
    protected SelectFormUI selectFormUI = this;
    protected Boolean selected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
    
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        // Add listener select
        resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
    
            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int selectionIndex = selectionModel.getLeadSelectionIndex();
                setSelected(selectionIndex != -1);
            }
        });
    
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void selectAndClose() {
        int selectedRow = resultTable.getSelectedRow();
        setFormId(resultTableModel.getFormIdAt(selectedRow));
        close();
    }
    
    protected void close() {
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectFormUI() {
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Window param0) {
        super(param0);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectFormUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getFormId() {
        return formId;
    }

    public OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public OfferTable getResultTable() {
        return resultTable;
    }

    public OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public JPanel getSearchPanel() {
        return searchPanel;
    }

    public Boolean getSelected() {
        return selected;
    }

    public Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFormId(String formId) {
        String oldValue = this.formId;
        this.formId = formId;
        firePropertyChange(PROPERTY_FORM_ID, oldValue, formId);
    }

    public void setOfferListColumnFactory(OfferListColumnFactory offerListColumnFactory) {
        OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = offerListColumnFactory;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, offerListColumnFactory);
    }

    public void setResultTableModel(OfferListTableModel resultTableModel) {
        OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = resultTableModel;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, resultTableModel);
    }

    public void setSelected(Boolean selected) {
        Boolean oldValue = this.selected;
        this.selected = selected;
        firePropertyChange(PROPERTY_SELECTED, oldValue, selected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectFormUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createFormId() {
        $objectMap.put("formId", formId = null);
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectFormUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        resultTable.setShowGrid(true);
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        selectFormUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("selectFormUI", selectFormUI);
        createFormId();
        createSelected();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.action.select"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of selectFormUI
        setName("selectFormUI");
        selectFormUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.selectForm.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelected());
            }
        });
    }

}