/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: RelatedFormHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/offer/widgets/RelatedFormHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.widgets;

import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.OfferEditHandler;
import org.chorem.vradi.ui.offer.OfferListHandler;
import org.chorem.vradi.ui.offer.OfferListUI;
import org.chorem.vradi.ui.widgets.MultipleSelectionHandler;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;

import java.util.ArrayList;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/** @author sletellier */
public class RelatedFormHandler extends MultipleSelectionHandler<FormLink, Form, OfferEditHandler> {

    /** Logger */
    static private final Log log = LogFactory.getLog(RelatedFormHandler.class);

    protected FormLinkCellRenderer linkCellRenderer;

    protected List<FormLink> toSave = new ArrayList<FormLink>();

    public RelatedFormHandler(MultipleSelectionPane ui) {
        super(ui, OfferEditHandler.class);
        ui.setLbl(_("vradi.offerEdit.relatedForm"));
        linkCellRenderer = new FormLinkCellRenderer(ui);
        ui.getList().setCellRenderer(linkCellRenderer);
    }

    @Override
    public void init() {
        List<String> relatedFormsLinkIds = null;
        String wikittyId = getBean().getWikittyId();
        try {
            relatedFormsLinkIds = VradiService.getVradiDataService().getRelatedFormsLinkIds(wikittyId);
        } catch (VradiException eee) {
            log.error("Cant get related form for form id : " + wikittyId, eee);
            ErrorDialogUI.showError(eee);
        }
        fillList(relatedFormsLinkIds);
    }

    @Override
    public void add() {
        FormLink formLink = getHandler().addRelatedForm(ui, getBean());
        if (formLink != null) {
            addToList(formLink, formLink.getWikittyId());
            linkCellRenderer.addAdded(formLink);
        }
    }

    @Override
    public void remove() {
        List<String> formLinkIds = getHandler().removeLinkForm(getSelectedInList());
        removeFromList(formLinkIds);
    }

    @Override
    public void openSelected(String selected) {
        OfferListHandler listHandler = UIHelper.getHandler(ui, OfferListHandler.class);
        if (selected != null) {
            FormLink formLink = VradiService.getWikittyProxy().restore(FormLink.class, selected);
            if (formLink == null) {
                formLink = getAddedData(selected);
            }
            OfferListUI offerListUI = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(VradiContext.get());
            listHandler.addEditPane(offerListUI, formLink.getToForm());
        }
    }
}
