/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormLinkCellRenderer.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/offer/widgets/FormLinkCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.widgets;

import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.FormLink;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.ToolTipHelper;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;
import org.nuiton.widget.tooltip.FocusableTip;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;

/** @author sletellier */
public class FormLinkCellRenderer extends DefaultListCellRenderer {

    protected FocusableTip focusableTip = null;

    protected MultipleSelectionPane ui;

    protected Map<String, String> cachedRendered = new HashMap<String, String>();

    protected Map<String, String> cachedToolTip = new HashMap<String, String>();

    public FormLinkCellRenderer(MultipleSelectionPane ui) {
        super();
        this.ui = ui;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String rendered = " ";
        String formToolTip = null;
        String formLinkId = (String) value;
        if (formLinkId != null) {
            rendered = cachedRendered.get(formLinkId);
            formToolTip = cachedToolTip.get(formLinkId);
            if (rendered == null) {
                FormLink formLink = VradiService.getWikittyProxy().restore(FormLink.class, formLinkId);
                if (formLink != null) {
                    rendered = formLink.getName();
                    cachedRendered.put(formLinkId, rendered);

                    // ToolTip
                    formToolTip = loadFormToolTip(formLink);
                }
            }
        }

        JLabel renderedComponant = (JLabel) super.getListCellRendererComponent(list, rendered, index, isSelected, cellHasFocus);

        if (formToolTip != null) {
            renderedComponant.setToolTipText(formToolTip);
        }

        return renderedComponant;
    }

    public void addAdded(FormLink formLink) {
        cachedRendered.put(formLink.getWikittyId(), formLink.getName());

        // ToolTip
        loadFormToolTip(formLink);
    }

    protected String loadFormToolTip(FormLink formLink) {

        Form form = VradiService.getWikittyProxy().restore(Form.class, formLink.getToForm());
        String formToolTip = ToolTipHelper.getToolTip(form);
        cachedToolTip.put(formLink.getWikittyId(), formToolTip);

        return formToolTip;
    }

    /*
     * @see javax.swing.JComponent#getToolTipText()
     */
    @Override
    public String getToolTipText(MouseEvent e) {

        // get original text
        String text = super.getToolTipText(e);

        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(ui, true);
            focusableTip.setSize(600, 400);
        }
        focusableTip.toolTipRequested(e, text);

        return null;
    }
}
