/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiEditorModel.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/offer/editors/VradiEditorModel.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import org.chorem.vradi.VradiHelper;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

/**
 * User: chemit
 * Date: 26 nov. 2009
 * Time: 21:48:47
 */
public class VradiEditorModel<O extends Serializable> implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_FIELD_NAME = "fieldName";

    public static final String PROPERTY_FIELD_DESCRIPTION = "fieldDescription";

    public static final String PROPERTY_EXTENSION_NAME = "extensionName";

    public static final String PROPERTY_EXTENSION_FIELD_NAME = "extensionFieldName";

    public static final String PROPERTY_VALIDATOR_CONTEXT = "validatorContext";

    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected O value;

    protected String fieldName;

    protected String fieldDescription;

    protected String extensionName;

    protected String extensionFieldName;

    protected String validatorContext;

    public O getValue() {
        return value;
    }

    public String getExtensionName() {
        return extensionName;
    }

    public String getExtensionFieldName() {
        return extensionFieldName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getFieldDescription() {
        return fieldDescription;
    }

    public String getValidatorContext() {
        return validatorContext;
    }

    public void setValue(O value) {
        O oldValue = this.value;
        this.value = value;
        pcs.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public void setExtensionName(String extensionName) {
        String oldValue = this.extensionName;
        this.extensionName = extensionName;
        pcs.firePropertyChange(PROPERTY_EXTENSION_NAME, oldValue, extensionName);
    }

    public void setExtensionFieldName(String extensionFieldName) {
        String oldValue = this.extensionFieldName;
        this.extensionFieldName = extensionFieldName;
        pcs.firePropertyChange(PROPERTY_EXTENSION_FIELD_NAME, oldValue, extensionFieldName);
    }

    public void setFieldName(String fieldName) {
        String oldValue = this.fieldName;
        this.fieldName = VradiHelper.getTraduction(fieldName);
        pcs.firePropertyChange(PROPERTY_FIELD_NAME, oldValue, fieldName);
    }

    public void setFieldDescription(String fieldDescription) {
        String oldValue = this.fieldDescription;
        this.fieldDescription = fieldDescription;
        pcs.firePropertyChange(PROPERTY_FIELD_DESCRIPTION, oldValue, fieldDescription);
    }

    public void setValidatorContext(String validatorContext) {
        String oldValue = this.validatorContext;
        this.validatorContext = validatorContext;
        pcs.firePropertyChange(PROPERTY_FIELD_NAME, oldValue, validatorContext);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }
}

