/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public abstract class VradiEditor<O extends Serializable, M extends VradiEditorModel<O>> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_NAME_LABEL_ENABLED = "fieldNameLabel.enabled";
    public static final String BINDING_FIELD_NAME_LABEL_TEXT = "fieldNameLabel.text";
    public static final String BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT = "fieldNameLabel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TPW9TMRS9SZukSUj5qChFLdACKw57EBQFIojCh0iFKrLgxE7iyu/Z2H7tKwPiJ/ATYGdBYmNCDMwMLIi/gBADK8J2vhp4qJVKhveSa59zzz335PU3yGgFa1s4jpGKQsMCiurXNzfvtbdox9yguqOYNELB4JNKQ7oFRTKuawMXWg0HLw/h5aoIpAhpuAddaUBBm11OdZ9SY+DMNKKjdbk5Pq7EMlIj1rGoJNaXP76nX5Dnr9IAsbTqZuwoq/uhJpPMNiDNiIETttM2LnMc9qwMxcKe1VtytSrHWt/FAX0CzyDXgKzEypIZOH/wkT2Hx8fSwNzF+n0cUn7ZwCWheqjTF4oGaFthwlDEkOh2qUKUMOcteujKN/0PKT1J1sB8l1FOnKoGblNu9TupMdI7Vjmq+6K7mh8jSgO+qgiNVz8N8HqGAAXLU/7ZzaDJZibWpVqQUZEtG1hq/b3MB/ZosMalP9boCP3pr8WFz+++vq2Ndpe1vU8mXt0TPeupVEJSZZhrfXSwuMgwXr6DZaUFeU25za3P5UqCsObw2Iqz/Y47OHJwdAvrvqXI5L68/7D4+NMMpGtQ4AKTGnb3b0Pe9JV1QXASy2vrXtGRnTn7POa0GchyvCsia+78FYINXm2zkFh7r8bWhJUEE8ZK2vmPPxeab9ZHRqSssNP/vD4xI/MIsizkLKQ+xsOEJsa2KDWNiJgkMSmbKfcuyGHOTvnnctKkORriNqe+49k4cq9zXrf7tuZpSgegKQYsZEEUNNlTekiqklTU/m0UJf+BbNbQ2Bx2NiME32ByY3+q3+O+rdCCBQAA";
    private static final Log log = LogFactory.getLog(VradiEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel editorContent;
    protected JLabel fieldNameLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiEditor<O, M> $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Initialize the editor, must be call before any use of it.
     */
    public void init() {
        // model is null, when coming here from parent
        applyDataBinding("fieldNameLabel.text");
    }
    
    public abstract VradiEditorModel<O> getModel();
    
    public String getFieldName() {
        return getModel().getFieldName();
    }
    
    public void setFieldName(String newValue) {
        getModel().setFieldName(newValue);
    }
    
    public String getFieldDescription() {
        return getModel().getFieldDescription();
    }
    
    public void setFieldDescription(String newValue) {
        getModel().setFieldDescription(newValue);
    }
    
    public String getExtensionName() {
        return getModel().getExtensionName();
    }
    
    public void setExtensionName(String newValue) {
        getModel().setExtensionName(newValue);
    }
    
    public String getExtensionFieldName() {
        return getModel().getExtensionFieldName();
    }
    
    public void setExtensionFieldName(String newValue) {
        getModel().setExtensionFieldName(newValue);
    }
    
    public O getValue() {
        return getModel().getValue();
    }
    
    public void setValue(O newValue) {
        getModel().setValue(newValue);
    }
    
    public String getValidatorContext() {
        return getModel().getValidatorContext();
    }
    
    public void setValidatorContext(String newValue) {
        getModel().setValidatorContext(newValue);
        registerValidator();
    }
    
    abstract void registerValidator();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiEditor() {
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getEditorContent() {
        return editorContent;
    }

    public JLabel getFieldNameLabel() {
        return fieldNameLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new JPanel());
        
        editorContent.setName("editorContent");
    }

    protected void createFieldNameLabel() {
        $objectMap.put("fieldNameLabel", fieldNameLabel = new JLabel());
        
        fieldNameLabel.setName("fieldNameLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(fieldNameLabel, BorderLayout.WEST);
        add(editorContent, BorderLayout.CENTER);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        fieldNameLabel.setMinimumSize(new Dimension(0,28));
        fieldNameLabel.setPreferredSize(new Dimension(140,28));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createFieldNameLabel();
        createEditorContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_NAME_LABEL_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                fieldNameLabel.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setText(_(getModel().getFieldName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setToolTipText(_(getModel().getFieldDescription() != null ?                     SwingUtil.getStringValue(getModel().getFieldDescription()) :                     SwingUtil.getStringValue(getModel().getFieldName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
    }

}