/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;

public class IdEditor extends VradiEditor<String, IdEditorModel> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_WIKITTY_ID_TEXT = "wikittyId.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UPW8TQRAdm9iJE8yHI0wigggEgQDpjESDlCgEAhaJHEAYRRFuWHs38Ya722VvL7lQIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZtcfF8NBTgIXd9bMvDdvZ+fdyy+QCxSc3CRR5KjQ19xjzvLVtbXbzU3W0tdZ0FJcaqGg88tkIduAMdqPBxpmGjUDr3ThlUXhSeEzfxd6tgajgd5xWdBmTGs4PohoBUGl3k/PRjJUPda+qCTW59++Zp/Rpy+yAJFEdXk8yvReqPgkQzXIcqqhhJ22SMUl/gbKUNzfQL1FE1t0SRDcIh57BE9guAZ5SRSSaTiV/siWw+IjqaF4elURym9QjjUXNZwXasNptYVinrNlMk7IHbG+zpTDbE3gLNFOtZSWJq8h5wnKXA2V9OAVg4gZClvE5ZRgQsOFgYn1E06wjZNw6ua52gvGDMVOh0XhazuRkplX1AUt3yH+7nb5TrGG8kDVPRbpKmcuNWWlWNw2f8i13lmy8aPdpIJjA0JxaZx4aeJbzTQgp0IMa5ho/L5ndzHV2bCJXzbMENrsj/L4xzefX1d7a1XA3kcSS3e5Aq9bKiGZ0ty0PtjZqVBzt7JC5GwDWZiLlrKWmUoQVu+mURz2O2zgjoE7N0nQRorc8Ke378oPPuyDbBVGXUFolZj6JSjotsIpCJdG8sqCVbR/ewSfh4w2nL5LdkSId3RgDi+RTDe5T3H+8xEOYSphCH0lzcL77+P1Vwu9QWRQ2OQfy+Nh5O5Dnvsu95l1WNc8iY4akwELqYhNkmSbjHmPy+4+nbDPmaSTjnkk4l7o1flj2+BMFJrXWavd/DuXmmq4JdzQ8/GySnOds0wTjR+HZqjZfDJtOZVC7qdQmIaqKBVDqytG/wPZkEYv/iPHiHE5abpWy6Vknsk9eUz48l+UpGO4tgfDT7gduMv5BgAA";
    private static final Log log = LogFactory.getLog(IdEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "value",  editorName = "editor")
    protected JTextField editor;
    protected IdEditorModel model;
    @Validator( validatorId = "validator")
    protected SwingValidator<IdEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JTextField wikittyId;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private IdEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setContext(model.getValidatorContext());
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
    
                log.debug("registration : " + validator.getContext());
            }
    
            public String getModifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                String modifiablePart = org.nuiton.util.StringUtil.substring(value, 0, -VradiConstants.UUID_LENGTH);
                return modifiablePart;
            }
    
            public String getUnmodifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                String unmodifiablePart = org.nuiton.util.StringUtil.substring(value, -VradiConstants.UUID_LENGTH);
                return unmodifiablePart;
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public IdEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public IdEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public IdEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IdEditor() {
        $initialize();
    }

    public IdEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValue(editor.getText() + getUnmodifiablePartOfValue(model.getValue()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getEditor() {
        return editor;
    }

    public IdEditorModel getModel() {
        return model;
    }

    public SwingValidator<IdEditorModel> getValidator() {
        return validator;
    }

    public JTextField getWikittyId() {
        return wikittyId;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.WEST);
        editorContent.add(wikittyId, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setColumns(8);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new IdEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(IdEditorModel.class, null));
    }

    protected void createWikittyId() {
        $objectMap.put("wikittyId", wikittyId = new JTextField());
        
        wikittyId.setName("wikittyId");
        wikittyId.setColumns(15);
        wikittyId.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        editorContent.setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setPreferredSize(new Dimension(0,28));
        wikittyId.setMinimumSize(new Dimension(0,28));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createValidator();
        createEditor();
        createWikittyId();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(editor, getModifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIKITTY_ID_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(wikittyId, getUnmodifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}