/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;

public class DateEditor extends VradiEditor<Date, DateEditorModel> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm9jGMeHDFlEQiZRAEAVoDbURBCVEEDkQYSmKcMPat7HXubtddvecCwXiJ/AToKdBoqNCFNQUNIi/gBAFLWL2zvE5cBAjXOxZO/PevHk78/IL5LSChR4NQ6IC33CPkbWbW1v3Wj3WNitMtxWXRiiIf5ksZJtQcob32sD5Zt3CqwN4dVl4UvjMH0HX6jCpzZ7LdJcxY2DuIKKtdbUxDNdCGah91qGoNNbn375mnzlPX2QBQonqbCvzh6GSTibqkOWOgTJW6tOqS/0OylDc76DeKXu37FKt71KPPYInUKhDXlKFZAbOjd9yxBHhQ2lganFTUYffcjjmXDFwWagOaXeFYh7p2wgJOBHb20wRFuVoskINi/OljIjyBnKecJhr4Oq/wNctJuEo9qnLHYoBA5cOuDYMEL2LbpCGPTf3LxOGqbjGsvBN5ErZehYOQGsb1B8tl4+TDcxbzT0coR0jZJwckrUtq3ODt3eYsoCyxLc8e0AVTglJpiR5xkwTcirAawMzzd8H6z6G4pGa+WWkLGEU/TFd+fjm8+vV0Tk6nZo6sgb4vlIJyZThtvSJeIgCw93qOpW1JhQ1c3GHoh2ZTRHWGIRRHNY7ZeHEwsltqrtIkSt8evtu+uGHI5BdhUlXUGeV2vw7UDRdhS4I1wnljaVI0bHdo3ietNrQapfuiQAf5Pg1fDE63+K+gy5fD9GE2RQThkpaxfffK41XS/tGZFDYmT+mJ2bkHkCe+y73WbRSg21JXaGS1CxwRLIVaXuSsd+KHAzPXHQupHVa8mjIvcBr8MdRgcUwsJ8LkXb77+LYVBNo1d84psfgKDCftlzm/CdNyeP+GF1Zqp+GpUwfwQUAAA==";
    private static final Log log = LogFactory.getLog(DateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "value",  editorName = "editor")
    protected JXDatePicker editor;
    protected DateEditorModel model;
    @Validator( validatorId = "validator")
    protected SwingValidator<DateEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateEditor() {
        $initialize();
    }

    public DateEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValue(editor.getDate());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getEditor() {
        return editor;
    }

    public DateEditorModel getModel() {
        return model;
    }

    public SwingValidator<DateEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JXDatePicker());
        
        editor.setName("editor");
        editor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(DateEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editorContent.setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setDate(model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
    }

}