/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.FieldTypeEnum;
import org.chorem.vradi.ui.helpers.UIHelper;

public class CurrencyEditor extends VradiEditor<String, CurrencyEditorModel> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CURRENCY_COMBO_BOX_ENABLED = "currencyComboBox.enabled";
    public static final String BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM = "currencyComboBox.selectedItem";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_MODEL = "editor.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz08TQRTHp5W2lB+CNBCMkBRFvW25cBECSLERUpBQY4i9ONsd2iG7O+P8gK0H45/gn6B3LybePBkPnj14Mf4Lxnjwanyz2x9Uq6BrD7vNzHuf931v3pt98RmlpEBzhzgILKF9RT1ibd3c379jH5Ka2iCyJihXTKDol0iiZBUNO511qdCVatm4F1ruhSLzOPOJf8J7qYyGpGq6RDYIUQrN9nrUpCxUOttLAdeiTe2I6kd99vVL8qnz5HkSoYCDOpNK/jSvbiYDZZSkjkITEOkIF1zs10GGoH4d9I6ataKLpdzBHnmIHqNMGaU5FgBT6PLZUw4ZoX/AFRqdvyewQ285FGwWFFpgom7VGkwQzzoyO5amFjs4IMIioY20ilpA0Foz8uE8hKUVSnnMIa5Ci3+L2DZ+Xc5oZFVkvgpzmzCZB5Y8hkJYW7vYP2mcjowVutZT58g42rN2tGcTEcUybmMd7/FaSwgUzGbrLFBosidae73lJtClnjDQKFa3UbonmaiilNCwrNB09dfe2oOtqKumf+oqAwx3v0/lPrz+9KrUbqUcxJ7sa3piEuCIuWCcCEVN6LGoj7SibmEb86UqykriwhiFYzLTR1iltQ3iIN4F424Zd+s2lg1ApDIf37ydevD+HEqW0JDLsFPCxn4TZVVDQBWY6wR8dS1UNHI8CM9xow3OycVNpuE0zy87WOG8TX0HKrwSQBFm+hSho8TOvvuWq7xcaxciAcIu/ta8W4zUfZSmvkt9Ek5Va2D6TtEwl0Q7rDsY/UYlYd7jvNV5s+Fzrl+mWawV22Vcc2MyH2jzuhoqN/+uh6DcGUADNsF+TEaG+Nh2iRMTM+zhgHraq9BHJDaK+v8JFV04MSHZEHK3yeOqGWyNXhNurOWo8/JYwfVta0VW/p07BlN1HPbTOswPi9sRWYPbI5KouPlqSUpwBcTlZIBTofV4eZnlxT8Qps5EuBGbsBqbsBGLAMcC3zOHCCJickaiTwVxNhXxTmH9ANOb8JC2CQAA";
    private static final Log log = LogFactory.getLog(CurrencyEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox currencyComboBox;
    protected NumberEditor editor;
    protected CurrencyEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CurrencyEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void init() {
        super.init();
        editor.init();
    }
    
    @Override
    void registerValidator() {
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CurrencyEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CurrencyEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CurrencyEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CurrencyEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CurrencyEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public CurrencyEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CurrencyEditor() {
        $initialize();
    }

    public CurrencyEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__currencyComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if(currencyComboBox.getSelectedItem() != null)                    {model.setCurrency(currencyComboBox.getSelectedItem().toString());}
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getCurrencyComboBox() {
        return currencyComboBox;
    }

    public NumberEditor getEditor() {
        return editor;
    }

    public CurrencyEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(CurrencyEditorModel model) {
        CurrencyEditorModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editor, BorderLayout.WEST);
        editorContent.add(currencyComboBox, BorderLayout.CENTER);
    }

    protected void createCurrencyComboBox() {
        $objectMap.put("currencyComboBox", currencyComboBox = new JComboBox());
        
        currencyComboBox.setName("currencyComboBox");
        currencyComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__currencyComboBox"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setProperty("amount");
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new CurrencyEditorModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorContent();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        editor.setAutoPopup(true);
        editor.setBean(model);
        editor.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setModelType(Float.class);
        editor.setShowPopupButton(true);
        editor.setShowReset(true);
        editor.setUseFloat(true);
        editor.setUseSign(false);
        currencyComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        currencyComboBox.setMinimumSize(new Dimension(0,28));
        currencyComboBox.setModel(new DefaultComboBoxModel(FieldTypeEnum.Currency.values()));
        currencyComboBox.setRenderer(UIHelper.getTranslationListCellRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createEditor();
        createCurrencyComboBox();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("amount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setModel(model.getAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("amount", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CURRENCY_COMBO_BOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                currencyComboBox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currency", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    currencyComboBox.setSelectedItem(FieldTypeEnum.getCurrency(model.getCurrency()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currency", this);
                }
            }
        });
    }

}