/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class RequestFormViewUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(RequestFormViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton close;
    protected RequestFormViewUI requestFormView = this;
    protected JXTable resultTable;
    protected JXTreeTable resultTreeTable;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JTabbedPane $JTabbedPane0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
                 
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected RequestFormViewHandler getHandler() {
        return getContextValue(RequestFormViewHandler.class);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestFormViewUI() {
        $initialize();
    }

    public RequestFormViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestFormViewUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public RequestFormViewUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestFormViewUI(String param0) {
        super(param0);
        $initialize();
    }

    public RequestFormViewUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestFormViewUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RequestFormViewUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__close(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getClose() {
        return close;
    }

    public JXTable getResultTable() {
        return resultTable;
    }

    public JXTreeTable getResultTreeTable() {
        return resultTreeTable;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestFormView() {
        if (!allComponentsCreated) {
            return;
        }
        add($JTabbedPane0, BorderLayout.CENTER);
        add(close, BorderLayout.SOUTH);
    }

    protected void createClose() {
        $objectMap.put("close", close = new JButton());
        
        close.setName("close");
        close.setText(_("vradi.action.close"));
        close.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__close"));
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new JXTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTreeTable() {
        $objectMap.put("resultTreeTable", resultTreeTable = new JXTreeTable());
        
        resultTreeTable.setName("resultTreeTable");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToRequestFormView();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("vradi.requestFormView.tab.table"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("vradi.requestFormView.tab.treetable"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(resultTreeTable);
        
        // apply 14 property setters
        resultTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        resultTable.setColumnControlVisible(true);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(getHandler().getResultTableModel(this));
        resultTable.setShowGrid(false);
        resultTreeTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        resultTreeTable.setColumnControlVisible(true);
        resultTreeTable.setGridColor(Color.GRAY);
        resultTreeTable.setHorizontalScrollEnabled(true);
        resultTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        resultTreeTable.setShowGrid(false);
        resultTreeTable.setTreeTableModel(getHandler().getResultTreeTableModel(this));
        // late initializer
        requestFormView.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("requestFormView", requestFormView);
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createResultTreeTable();
        createClose();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("vradi.requestFormView.tab.table"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("vradi.requestFormView.tab.treetable"));
        // inline creation of requestFormView
        setName("requestFormView");
        requestFormView.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.requestFormView.title"));
        
        $completeSetup();
    }

}