/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: OfferTable.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/offer/OfferTable.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import org.apache.commons.lang.StringUtils;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.jdesktop.swingx.JXTable;
import org.nuiton.widget.tooltip.FocusableTip;

import java.awt.event.MouseEvent;

/**
 * Offer table.
 * <p/>
 * Extends default JXTable with:
 * <ul>
 * <li>Persistent tooltip support
 * </ul>
 *
 * @author chatellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public class OfferTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4554858117023580350L;

    /** Single tooltip instance. */
    protected FocusableTip focusableTip;

    /*
     * @see javax.swing.JComponent#getToolTipText()
     */
    @Override
    public String getToolTipText(MouseEvent e) {

        // Get row concerned
        int row = rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }

        // get original text
        String text = ((OfferListTableModel) getModel()).getToolTip(convertRowIndexToModel(row));

        // Dont display toolTip if empty
        if (text == null || StringUtils.isEmpty(text.trim())) {
            return null;
        }

        // display it into persistant tooltip
        if (focusableTip == null) {
            focusableTip = new FocusableTip(this, true);
            focusableTip.setSize(600, 400);
        }

        focusableTip.toolTipRequested(e, text);

        return null;
    }
}
