/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.search.PaginationUI;
import org.chorem.vradi.ui.search.SearchHandler;
import org.chorem.vradi.ui.search.SearchUI;
import static org.nuiton.i18n.I18n._;

public class OfferListUI extends JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean advancedSearchCollapsed;
    protected JTabbedPane editTabs;
    protected JButton exportButton;
    protected OfferTable listTable;
    protected OfferListUI offerList = this;
    protected OfferListColumnFactory offerListColumnFactory;
    protected OfferListTableModel offerListTableModel;
    protected JPanel paginationPanel;
    protected PaginationUI paginationUI;
    protected JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected SearchUI searchUI;
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setSearchUI(SearchUI searchUI) {
        this.searchUI = searchUI;
        searchPanel.add(searchUI, BorderLayout.CENTER);
    }
    
    public SearchUI getSearchUI() {
        return searchUI;
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferListUI(int param0) {
        super(param0);
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferListUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferListUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public OfferListUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSearchHandler().exportToCSV(offerListTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public JTabbedPane getEditTabs() {
        return editTabs;
    }

    public JButton getExportButton() {
        return exportButton;
    }

    public OfferTable getListTable() {
        return listTable;
    }

    public OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public JPanel getSearchPanel() {
        return searchPanel;
    }

    public Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(Boolean advancedSearchCollapsed) {
        Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = advancedSearchCollapsed;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, advancedSearchCollapsed);
    }

    public void setOfferListColumnFactory(OfferListColumnFactory offerListColumnFactory) {
        OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = offerListColumnFactory;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, offerListColumnFactory);
    }

    public void setOfferListTableModel(OfferListTableModel offerListTableModel) {
        OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = offerListTableModel;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, offerListTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new JTabbedPane());
        
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new JPanel());
        
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("offerList", offerList);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}