/*
 * #%L
 * Vradi :: Swing
 * *
 * $Id: RequestFieldMenu.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/models/RequestFieldMenu.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.models;

import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Infogene;
import org.chorem.vradi.entities.ModificationTag;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.services.managers.SearchManager;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.search.SearchUI;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/** @author letellier */
public class RequestFieldMenu extends JMenu implements VradiExtensionsListener {

    /** Logger */
    private static final Log log = LogFactory.getLog(FormMenu.class);

    public static final String FIELD_NAME_SUFFIX = ":\"\"";

    protected SearchUI searchUI;

    protected Map<String, JMenu> formTypesMenu;

    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI) {
        super(_("vradi.request.keywords"));

        this.searchUI = searchUI;

        // Fill infogene fields
        fillInfogeneMenu();

        // Get all formsType
        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("cant get all forms type", eee);
            ErrorDialogUI.showError(eee);
        }

        // Sort
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);

        formTypesMenu = new HashMap<String, JMenu>();
        formTypesFieldMenu = new HashMap<String, JMenuItem>();

        // Fill for all formTypes
        if (formTypes != null) {
            for (WikittyExtension formType : formTypes) {
                fillFormTypeMenu(formType);
            }
        }
        // register each tree on wikitty service
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(_("vradi.request.infogene"));

        // Fill infogene menu
        for (String fieldName : getInfogeneFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }

        // Fill form menu
        for (String fieldName : getFormFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }

        // TODO sletellier 15/12/10 : [#323] Requête sur tout ce qui caractérise un formulaire
        // Fill status menu
        JMenu statusMenu = new JMenu(UIHelper.getInfogeneTraduction(Infogene.FIELD_INFOGENE_STATUS));
        infogeneMenu.add(statusMenu);

        // Get all status
        List<Status> statuses = VradiService.getVradiDataService().findAllStatus();
        for (Status status : statuses) {
            statusMenu.add(new FieldValueMenuItem(Infogene.FQ_FIELD_INFOGENE_STATUS, status.getName()));
        }

        // Fill xmlStream menu
        JMenu xmlStreamMenu = new JMenu(UIHelper.getFormTraduction(Form.FIELD_FORM_XMLSTREAM));
        infogeneMenu.add(xmlStreamMenu);

        // Get all status
        List<XmlStream> streams = VradiService.getVradiDataService().findAllXmlStreams();
        for (XmlStream stream : streams) {
            xmlStreamMenu.add(new FieldValueMenuItem(Form.FQ_FIELD_FORM_XMLSTREAM, stream.getName()));
        }

        add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);

        formTypeMenu.add(new FormTypeMenuItem(formTypeName));
        formTypeMenu.add(new JSeparator());

        for (String fieldName : formType.getFieldNames()) {

            FieldMenuItem fieldMenu = new FieldMenuItem(formType, formTypeName + WikittyUtil.FQ_FIELD_NAME_SEPARATOR + fieldName);
            formTypeMenu.add(fieldMenu);

            formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        formTypesMenu.put(formTypeName, formTypeMenu);
        add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_DEPARTMENT);

        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Form.FQ_FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FQ_FIELD_FORM_DATEPEREMPTION);
        fieldNames.add(ModificationTag.FQ_FIELD_MODIFICATIONTAG_LASTMODIFIER);

        return fieldNames;
    }

    protected class FormTypeMenuItem extends JMenuItem implements ActionListener {

        protected String formTypeName;

        public FormTypeMenuItem(String formTypeName) {
            this.formTypeName = formTypeName;

            addActionListener(this);
        }

        @Override
        public String getText() {
            return _("vradi.request.searchOnExt");
        }

        @Override
        public void actionPerformed(ActionEvent e) {

            JTextArea requestArea = searchUI.getRequestArea();

            int position = requestArea.getCaretPosition();
            String toDisplay = SearchManager.FORM_TYPE_SEARCH + ":\"" + formTypeName + "\"";
            requestArea.insert(toDisplay, position);

            // Put carret under cotes
            requestArea.setCaretPosition(position + toDisplay.length());

            searchUI.setRequest(requestArea.getText());
        }
    }

    protected class FieldValueMenuItem extends FieldMenuItem {

        protected String value;

        public FieldValueMenuItem(String fqFieldName, String value) {
            super(fqFieldName);
            this.value = value;
        }

        @Override
        public String getText() {
            return _(value);
        }

        @Override
        public String getDisplayedText() {
            return fqFieldName + ":\"" + value + "\"";
        }

        @Override
        public int getFinalCarret() {
            return 0;
        }
    }

    protected class FieldMenuItem extends JMenuItem implements ActionListener {

        protected String fieldName;
        protected String fqFieldName;

        protected FieldType fieldType;

        protected String description;

        protected String traduction;

        public FieldMenuItem(String fqFieldName) {
            this(null, fqFieldName);
        }

        public FieldMenuItem(WikittyExtension extension, String fqFieldName) {
            this.fqFieldName = fqFieldName;
            this.fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqFieldName);
            if (extension != null) {
                fieldType = extension.getFieldType(fqFieldName);
                description = VradiHelper.getFieldTypeDescription(fieldType);
            }
            traduction = VradiHelper.getTraduction(extension, fqFieldName);

            addActionListener(this);
        }

        @Override
        public String getText() {
            if (traduction != null && !traduction.equals(fieldName)) {
                return traduction + " (" + fieldName + ")";
            }
            return fieldName;
        }

        public String getDisplayedText() {
            return fqFieldName + FIELD_NAME_SUFFIX;
        }

        public int getFinalCarret() {
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {

            JTextArea requestArea = searchUI.getRequestArea();

            int position = requestArea.getCaretPosition();
            String displayedText = getDisplayedText();
            requestArea.insert(displayedText, position);

            // Put carret under cotes
            requestArea.setCaretPosition(position + displayedText.length() + getFinalCarret());

            searchUI.setRequest(requestArea.getText());
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return getToolTipText();
        }

        @Override
        public String getToolTipText() {
            if (description != null) {
                return description;
            } else {
                return super.getToolTipText();
            }
        }
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            fillFormTypeMenu(ext);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        for (String formTypeName : removedNames) {

            JMenu formTypeMenu = formTypesMenu.get(formTypeName);
            if (formTypeMenu != null) {
                formTypesMenu.remove(formTypeName);
                remove(formTypeMenu);
            }
        }
    }

}
