/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ToolTipHelper.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/helpers/ToolTipHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.helpers;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Infogene;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.WikittyExtension;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * ToolTipHelper.
 *
 * @author schorlet
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 20 avr. 2010 12:05:07
 */
public class ToolTipHelper {

    private static final Log log = LogFactory.getLog(ToolTipHelper.class);

    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;

    public static String getToolTip(List<Form> forms) {
        if (forms == null || forms.isEmpty()) {
            return null;
        }

        StringBuffer result = new StringBuffer();
        result.append("<html>");

        int size = forms.size();
        for (int i = 0; i < size && i < 15; i++) {
            Form form = forms.get(i);
            result.append("- ").append(form.getObjet()).append("<br/>");
        }

        result.append("</html>");
        return result.toString();
    }

    public static String getToolTip(Form form) {
        if (form == null) {
            return null;
        }

        Map<String, Object> fieldValues = new LinkedHashMap<String, Object>();

        // Form.EXT_FORM
        String formFields[] = new String[]{
                Form.FQ_FIELD_FORM_DATEPUB, Form.FQ_FIELD_FORM_DATEPEREMPTION};

        for (String fieldName : formFields) {
            fieldValues.put(fieldName, form.getField(Form.EXT_FORM,
                                                     WikittyUtil.getFieldNameFromFQFieldName(fieldName)));
        }

        // Infogene.EXT_INFOGENE
        String infogeneFields[] = new String[]{
                Infogene.FQ_FIELD_INFOGENE_ID, Infogene.FQ_FIELD_INFOGENE_OBJET,
                Infogene.FQ_FIELD_INFOGENE_ENTITY, Infogene.FQ_FIELD_INFOGENE_SOURCETEXT,
                Infogene.FQ_FIELD_INFOGENE_DESCRIPTION};

        for (String fieldName : infogeneFields) {
            fieldValues.put(fieldName, form.getField(Infogene.EXT_INFOGENE,
                                                     WikittyUtil.getFieldNameFromFQFieldName(fieldName)));
        }

        // others extensions
        Collection<String> extensionNames = form.getExtensionNames();
        String formTypeName = null;
        for (String extensionName : extensionNames) {

            if (!Form.EXT_FORM.equals(extensionName)
                && !Infogene.EXT_INFOGENE.equals(extensionName)) {

                formTypeName = extensionName;

                Collection<String> fieldNames = form
                        .getExtensionFields(extensionName);

                for (String fieldName : fieldNames) {
                    fieldValues.put(fieldName, form.getField(extensionName,
                                                             fieldName));
                }
            }
        }

        StringBuffer result = new StringBuffer();
        result.append("<html>");

        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();

            if (value == null) {
                continue;
            }

            String stringValue;
            if (value instanceof Date) {
                stringValue = DateFormat.getDateTimeInstance(DateFormat.SHORT,
                                                             DateFormat.MEDIUM, Locale.FRANCE).format((Date) value);
            } else {

                stringValue = String.valueOf(value);
                stringValue = StringUtils.replace(stringValue, "\r", "");
                stringValue = StringUtils.replace(stringValue, "\n\n", "\n");
                stringValue = StringUtils.abbreviate(stringValue, TOOLTIP_ELEMENT_MAX_CHAR_NB);
                stringValue = StringUtils.replace(stringValue, "\n", "<br/>");
            }
            WikittyExtension formType = null;
            try {
                formType = VradiService.getVradiDataService().getFormType(formTypeName);
            } catch (VradiException e) {
                log.error("Failed to load formType : " + formTypeName);
            }

            result.append("<strong>").append(VradiHelper.getTraduction(formType, key)).append("</strong>")
                    .append(" : ").append(stringValue).append("<br/>");
        }

        result.append("</html>");
        String resultToString = result.toString();
        return resultToString;
    }

    public static String getEmailThesaurusToolTip(Form form) {
        if (form == null) {
            return null;
        }

        StringBuffer result = new StringBuffer();

        result.append("<html><h3>");

        // Add title
        result.append(_("vradi.email.thesaurusToolTipTitle"));
        result.append("</h3><br/>");

        try {
            List<Thesaurus> thesauruses = VradiService.getVradiDataService().getThesaurusAttachedToForm(form);

            // Add thesaurus name path
            for (Thesaurus thesaurus : thesauruses) {
                String thesaurusPath = ThesaurusDataHelper.getNamePath(thesaurus, "/");
                result.append(thesaurusPath).append("<br/>");
            }
        } catch (VradiException ex) {
            throw new RuntimeException("Can't get form thesaurus", ex);
        }

        result.append("</html>");

        return result.toString();
    }

    public static String getThesaurusToolTip(Thesaurus thesaurus) {

        StringBuffer result = new StringBuffer();
        result.append("<html><h3>");

        // Add title
        String name = ThesaurusDataHelper.concateOrderName(thesaurus);

        result.append(_("vradi.thesaurus.toolTipTitle", name));
        result.append("</h3><br/>");

        String namePath = ThesaurusDataHelper.getNamePath(thesaurus, "/");
        namePath = namePath.replaceAll(name, "");
        String comment = thesaurus.getComment();

        // Render like
        // Path
        // Description : blablabla
        // Tags : titi, toto, tata
        result.append(_("vradi.thesaurus.nameToolTip")).append(namePath).append("<strong>").append(name).append("</strong>").append("<br/>");
        result.append(_("vradi.thesaurus.commentToolTip")).append(comment == null ? "" : comment).append("<br/>");
        result.append(_("vradi.thesaurus.tagsToolTip")).append(ThesaurusDataHelper.getTagsAsString(thesaurus)).append("<br/>");

        result.append("</html>");

        return result.toString();
    }

    public static String getThesaurusDescriptionToolTip(Thesaurus thesaurus) {
        if (thesaurus == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String comment = thesaurus.getComment();
        if (comment == null || comment.trim().isEmpty()) {
            return null;
        }
        result.append("<html>");
        result.append(comment).append("<br/>");
        result.append("</html>");

        return result.toString();
    }
}
