/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailFormsListCellRenderer.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/renderers/EmailFormsListCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.renderers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupForms;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmailFormsListCellRenderer extends DefaultListCellRenderer {

    private static final Log log = LogFactory.getLog(EmailFormsListCellRenderer.class);

    protected Session sessionConcerned;

    protected String formConcerned;

    protected List<Object> cachedDeletion;

    protected Map<String, String> cachedRendered;

    protected Map<String, Boolean> cachedAdded;

    public EmailFormsListCellRenderer() {
        cachedDeletion = new ArrayList<Object>();
        cachedRendered = new HashMap<String, String>();
        cachedAdded = new HashMap<String, Boolean>();
    }

    public void updateDatas(Session sessionConcerned, String formConcerned) {
        this.sessionConcerned = sessionConcerned;
        this.formConcerned = formConcerned;
        clearCaches();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

        if (value == null) {
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        String wikittyId = ((BusinessEntity) value).getWikittyId();
        String renderedText = cachedRendered.get(wikittyId);
        if (renderedText != null) {
            Component rendered = super.getListCellRendererComponent(list, renderedText, index, isSelected, cellHasFocus);
            Boolean added = cachedAdded.get(wikittyId);
            if (added != null && added) {
                rendered.setForeground(Color.BLUE);
            }
            return rendered;
        }

        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        boolean isAdded = false;

        if (value instanceof User) {
            User user = (User) value;

            // Get user text
            String clientId = user.getClient();
            Client client = VradiService.getWikittyProxy().restore(
                    Client.class, clientId);
            String clientString = "";
            if (client != null) {
                clientString = client.getName() + " - ";
            }
            renderedText = clientString + user.getName();

            Sending sending = EmailDataHelper.getUserSending(sessionConcerned, user);
            if (sending != null) {
                Set<String> deletedForms = SendingHelper.extractForms(wikittyProxy, sending.getDeletedGroupForms());
                if (deletedForms != null && deletedForms.contains(formConcerned)) {
                    cachedDeletion.add(value);
                    renderedText = UIHelper.crossOf(renderedText);
                }
                Set<String> addedForms = SendingHelper.extractForms(wikittyProxy, sending.getAddedGroupForms());
                if (addedForms != null && addedForms.contains(formConcerned)) {
                    isAdded = true;
                }
            }
        } else if (value instanceof Group) {
            Group group = (Group) value;

            renderedText = group.getName();

            Set<String> userIds = group.getUser();
            if (userIds != null) {
                int deletedCount = 0;
                List<Sending> sendings = EmailDataHelper.getUsersSendings(sessionConcerned, userIds);
                for (Sending sending : sendings) {
                    if (sending != null) {
                        Set<String> groupFormsDeletedIds = sending.getDeletedGroupForms();
                        if (groupFormsDeletedIds != null) {
                            List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsDeletedIds));
                            for (GroupForms groupForm : groupForms) {
                                if (groupForm.getForm() != null && groupForm.getForm().contains(formConcerned)) {

                                    deletedCount++;
                                    break;
                                }
                            }
                        }
                        Set<String> groupFormsAddedIds = sending.getAddedGroupForms();
                        if (groupFormsAddedIds != null) {
                            List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsAddedIds));
                            for (GroupForms groupForm : groupForms) {
                                String groupId = groupForm.getGroup();
                                if (groupId != null && groupId.equals(group.getWikittyId()) &&
                                    groupForm.getForm() != null && groupForm.getForm().contains(formConcerned)) {

                                    isAdded = true;
                                    break;
                                }
                            }
                        }
                    }
                }

                // If all are deleted
                if (deletedCount == sendings.size()) {
                    cachedDeletion.add(value);

                    renderedText = UIHelper.crossOf(renderedText);
                }
            }
        }

        cachedRendered.put(wikittyId, renderedText);
        cachedAdded.put(wikittyId, isAdded);
        Component rendered = super.getListCellRendererComponent(list, renderedText, index, isSelected, cellHasFocus);
        if (isAdded) {
            rendered.setForeground(Color.BLUE);
        }
        return rendered;
    }

    public boolean isDeleted(Object o) {
        return cachedDeletion.contains(o);
    }

    public boolean areDeleted(Object[] o) {
        return cachedDeletion.containsAll(Arrays.asList(o));
    }

    public void clearCaches() {
        cachedDeletion.clear();
        cachedRendered.clear();
        cachedAdded.clear();
    }
}
