/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailDataHelper.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/helpers/EmailDataHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.helpers;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupForms;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/** @author sletellier <letellier@codelutin.com> */
public class EmailDataHelper {


    private static final Log log = LogFactory.getLog(EmailDataHelper.class);

    protected static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Sending getUserSending(Session session, User user) {
        String id = user.getWikittyId();
        return getUserSending(session, id);
    }

    public static List<Sending> getUsersSendings(Session session, Collection<String> usersId) {
        if (session == null || usersId == null) {
            return null;
        }
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List<Sending> sendings = getProxy().restore(Sending.class, sendingIds);
        List<Sending> result = new ArrayList<Sending>();
        for (Sending sending : sendings) {
            if (sending != null && usersId.contains(sending.getUser())) {

                result.add(sending);
            }
        }
        return result;
    }

    public static Sending getUserSending(Session session, String userId) {
        if (session == null) {
            return null;
        }
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List<Sending> sendings = getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            if (sending != null && userId.equals(sending.getUser())) {

                return sending;
            }
        }
        return null;
    }

    public static int getNbFormToSend(Session session, User bean) {
        Sending sending = getUserSending(session, bean);
        Set<String> formIds = null;
        if (sending != null) {
            formIds = SendingHelper.extractForms(getProxy(), sending.getGroupForms());
        }
        return formIds == null ? 0 : formIds.size();
    }


    public static int getNbFormToSend(Session session, Group group) {
        Set<String> formIds = new HashSet<String>();
        Set<String> userIds = group.getUser();
        if (userIds != null) {
            for (String userId : userIds) {
                Sending sending = getUserSending(session, userId);
                if (sending != null) {
                    Set<String> formsIds = SendingHelper.extractForms(getProxy(), sending.getGroupForms());
                    if (formsIds != null) {
                        formIds.addAll(formsIds);
                    }
                }
            }
        }
        return formIds.size();
    }

    public static String convertFormsToString(List<Form> forms) {

        List<String> objects = extractObject(forms);

        return StringUtils.join(objects, ",\n");
    }

    public static String convertFormsIdsToString(List<String> formsId) {

        List<Form> forms = VradiService.getWikittyProxy().restore(Form.class, formsId);

        return convertFormsToString(forms);
    }

    public static <E extends BusinessEntity> String convertObjectBeanToString(List beans, Class<E> clazz) {

        List<E> casted = new ArrayList<E>();
        for (Object o : beans) {
            casted.add((E) o);
        }

        return convertBeanToString(casted);
    }

    public static String convertBeanToString(List<? extends BusinessEntity> beans) {

        List<String> names = extractNames(beans);

        return StringUtils.join(names, ",\n");
    }

    protected static List<String> extractObject(List<Form> forms) {
        List<String> objects = new ArrayList<String>();
        for (Form f : forms) {
            objects.add(f.getObjet());
        }
        return objects;
    }

    protected static List<String> extractNames(List<? extends BusinessEntity> beans) {
        List<String> beansAsNames = new ArrayList<String>();
        for (BusinessEntity b : beans) {
            beansAsNames.add(VradiHelper.getEntityName(b));
        }
        return beansAsNames;
    }

    public static String convertFormToString(String formId) {
        Form form = VradiService.getWikittyProxy().restore(Form.class, formId);
        if (form != null) {
            return form.getObjet();
        }
        return "";
    }

    public static List<Sending> getAllSending(Session session) {
        Set<String> sendingSetIds = session.getSending();
        if (sendingSetIds == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> sendingIds = new ArrayList<String>(sendingSetIds);
        WikittyProxy proxy = VradiService.getWikittyProxy();
        return proxy.restore(Sending.class, sendingIds);
    }

    public static List<User> getUsersSendingConcernedBy(Session session, String formId) {
        Set<String> userSet = new HashSet<String>();
        List<Sending> sendings = getAllSending(session);
        for (Sending sending : sendings) {
            if (sending != null) {
                List<String> allFormsIds = new ArrayList<String>();
                Set<String> formsIds = SendingHelper.extractForms(getProxy(), sending.getGroupForms());
                if (formsIds != null) {
                    allFormsIds.addAll(formsIds);
                }
                Set<String> deletedFormsIds = SendingHelper.extractForms(getProxy(), sending.getDeletedGroupForms());
                if (deletedFormsIds != null) {
                    allFormsIds.addAll(deletedFormsIds);
                }

                if (allFormsIds.contains(formId)) {
                    String userId = sending.getUser();
                    userSet.add(userId);
                }
            }
        }
        List<User> result = VradiService.getWikittyProxy().restore(User.class, new ArrayList<String>(userSet));
        Collections.sort(result, VradiComparators.USER_COMPARATOR);
        return result;
    }

    public static List<Group> getGroupsSendingConcernedBy(Session session, String formId) {
        Set<String> groupsSet = new HashSet<String>();
        Set<String> groupFormsIdsOfSession = new HashSet<String>();
        for (Sending sending : getAllSending(session)) {

            Set<String> groupFormsIds = sending.getGroupForms();
            if (groupFormsIds != null) {
                groupFormsIdsOfSession.addAll(groupFormsIds);
            }
            Set<String> deletedGroupFormsIds = sending.getDeletedGroupForms();
            if (deletedGroupFormsIds != null) {
                groupFormsIdsOfSession.addAll(deletedGroupFormsIds);
            }
        }
        List<GroupForms> groupFormsOfSession = getProxy().restore(GroupForms.class, new ArrayList<String>(groupFormsIdsOfSession));
        for (GroupForms gf : groupFormsOfSession) {
            if (gf != null) {
                Set<String> formsIds = gf.getForm();
                if (formsIds != null && formsIds.contains(formId)) {
                    String groupId = gf.getGroup();
                    if (groupId != null) {
                        groupsSet.add(groupId);
                    }
                }
            }
        }
        List<Group> result = VradiService.getWikittyProxy().restore(Group.class, new ArrayList<String>(groupsSet));
        Collections.sort(result, VradiComparators.GROUP_COMPARATOR);
        return result;
    }

    public static Set<String> findAllGroupsConcernedBySending(Sending sending) {
        Set<String> result = new HashSet<String>();
        if (sending != null) {
            Set<GroupForms> groupsForms = findAllGroupsFormsConcernedBySending(sending);
            for (GroupForms gf : groupsForms) {
                if (gf != null) {
                    result.add(gf.getGroup());
                }
            }
        }
        return result;
    }

    protected static Set<GroupForms> findAllGroupsFormsConcernedBySending(Sending sending) {

        Set<GroupForms> result = new HashSet<GroupForms>();

        if (sending != null) {

            Set<String> groupFormsConcerned = sending.getGroupForms();
            if (groupFormsConcerned != null) {

                WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
                List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsConcerned));
                result.addAll(groupForms);
            }
            Set<String> groupFormsConcernedDeleted = sending.getDeletedGroupForms();
            if (groupFormsConcernedDeleted != null) {

                WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
                List<GroupForms> groupFormsDeleted = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsConcernedDeleted));
                result.addAll(groupFormsDeleted);
            }

//            // Get forms concerned (active or deleted)
//            List<String> formsConcerned = new ArrayList<String>();
//            Set<String> formsIds = sending.getForm();
//            if (formsIds != null) {
//                formsConcerned.addAll(formsIds);
//            }
//            Set<String> deletedFormsIds = sending.getDeletedForms();
//            if (deletedFormsIds != null) {
//                formsConcerned.addAll(deletedFormsIds);
//            }
//            if (!formsConcerned.isEmpty()) {
//
//                // For all forms, find groups concerned
//                for (String formId : formsConcerned) {
//                    result.addAll(findAllGroupsConcernedBySending(sending, formId));
//                }
//            }
        }
        return result;
    }

//    public static List<String> findAllGroupsConcernedBySending(Sending sending, String formId) {
//
//        List<String> result = new ArrayList<String>();
//
//        List<Group> userGroups = VradiService.getVradiDataService().findUserGroups(sending.getUser());
//        List<String> userGroupsIds = extractIds(userGroups);
//        Map<Group,List<QueryBean>> groupRequestMap;
//        try {
//            // Get group concerned
//            groupRequestMap = VradiService.getVradiStorageService().findQueriesReturningForm(formId);
//        } catch (VradiException eee) {
//            log.error("Cant get all groups concenred by sending ", eee);
//            ErrorDialogUI.showError(eee);
//            return null;
//        }
//        Set<Group> groupRequestSet = groupRequestMap.keySet();
//        List<String> groupRequestIds = extractIds(groupRequestSet);
//
//        if (log.isDebugEnabled()) {
//            log.debug(groupRequestIds.size() + " groups found for forms : " + formId);
//        }
//
//        // Extract groups match
//        for (String groupId : userGroupsIds) {
//            if (groupRequestIds.contains(groupId)) {
//                if (log.isDebugEnabled()) {
//                    log.debug("Add group : " + groupId);
//                }
//                result.add(groupId);
//            }
//        }
//        return result;
//    }

    public static List<String> extractIds(Collection<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        if (entities == null) {
            return ids;
        }
        for (BusinessEntity e : entities) {
            if (e != null) {
                ids.add(e.getWikittyId());
            }
        }
        return ids;
    }
}
