/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailBeanConstant.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/helpers/EmailBeanConstant.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.helpers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.EmailContentUI;
import org.chorem.vradi.ui.email.FormViewUI;
import org.chorem.vradi.ui.email.SendingViewUI;
import org.chorem.vradi.ui.email.SessionViewUI;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.text.SimpleDateFormat;

import static org.chorem.vradi.VradiConstants.SendingStatus;
import static org.chorem.vradi.VradiConstants.SessionStatus;

/**
 * @author sletellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public enum EmailBeanConstant {

    // Group
    GROUP(Group.class, null),
    // User
    USER(User.class, SendingViewUI.class),
    // Form
    FORM(Form.class, FormViewUI.class),
    //Session$
    SESSION(Session.class, SessionViewUI.class);

    /** Logger */
    private static Log log = LogFactory.getLog(EmailBeanConstant.class);

    protected Class<? extends BusinessEntity> beanClass;

    protected Class<? extends EmailContentUI> uiClass;

    private EmailBeanConstant(Class<? extends BusinessEntity> beanClass, Class<? extends EmailContentUI> uiClass) {
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public Class<? extends BusinessEntity> getBeanClass() {
        return beanClass;
    }

    public Class<? extends EmailContentUI> getUIClass() {
        return uiClass;
    }

    public static EmailBeanConstant getConstantByBeanClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())) {
                return constant;
            }
        }
        return null;
    }

    public BusinessEntity getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        return proxy.restore(beanClass, id);
    }

    public static Class<? extends EmailContentUI> getUIClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())) {
                return constant.getUIClass();
            }
        }
        return null;
    }

    public String decorate(Session currentSession, BusinessEntity bean) {
        String result = "";
        switch (this) {
            case GROUP:
                Group group = cast(Group.class, bean);
                result = group.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, group) + ")";
                break;
            case USER:
                StringBuffer sendingBuffer = new StringBuffer();
                User user = cast(User.class, bean);
                Client client = VradiService.getWikittyProxy().restore(Client.class, user.getClient());

                sendingBuffer.append(client.getName());
                sendingBuffer.append(" - ");
                sendingBuffer.append(user.getName());

                // Get sending concerned by user
                Sending sending = EmailDataHelper.getUserSending(currentSession, user.getWikittyId());

                if (sending != null) {
                    sendingBuffer.append(" [");
                    SendingStatus status = SendingStatus.getStatus(sending.getStatus());
                    sendingBuffer.append(status.getDescription());
                    sendingBuffer.append("] ");
                }
                sendingBuffer.append(" (");
                sendingBuffer.append(EmailDataHelper.getNbFormToSend(currentSession, user));
                sendingBuffer.append(")");

                result = sendingBuffer.toString();
                break;
            case FORM:
                Form form = cast(Form.class, bean);
                result = form.getObjet();
                break;
            case SESSION:
                // 1 - dd/MM/yyyy - status
                Session session = cast(Session.class, bean);
                StringBuffer sessionBuffer = new StringBuffer();
                sessionBuffer.append(session.getNum());
                sessionBuffer.append(" - ");
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                sessionBuffer.append(format.format(session.getSessionDate()));

                SessionStatus sessionStatus = SessionStatus.getStatus(session.getStatus());

                if (sessionStatus != null) {
                    sessionBuffer.append(" [");
                    sessionBuffer.append(sessionStatus.getDescription());
                    sessionBuffer.append("]");
                } else {
                    log.warn("Cant find status for num : " + session.getStatus());
                }
                result = sessionBuffer.toString();

                break;
        }
        return result;
    }

    public String getToolTipText(BusinessEntity bean) {
        String result = null;
        switch (this) {
            case SESSION:
                Session session = cast(Session.class, bean);
                String sessionLogs = session.getSessionLogs();
                if (sessionLogs != null && !sessionLogs.isEmpty()) {
                    result = sessionLogs;
                }

                break;
        }
        return result;
    }

    protected <B extends BusinessEntity> B cast(Class<B> toCast, BusinessEntity bean) {
        return (B) bean;
    }
}
