/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import org.chorem.vradi.ui.email.widgets.AttachmentSessionFileHandler;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;
import static org.nuiton.i18n.I18n._;

public class SessionViewUI extends EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_SESSION = "selectedSession";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_SESSION_PANE_BEAN = "attachmentSessionPane.bean";
    public static final String BINDING_SESSION_PARAGRAPH_TEXT = "sessionParagraph.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TURCeVlooiFYICBGToo0aD1s9QxSCEiFFiYuG2Iuv3Zf2kdfd53uzdLkY/wT/BL17MfHmyXjw7MGL8V8wxoNX47ztj6WyBhJ7aJuZ+b73zcw3b75DzmhY3GNR5OjQR9Hmzubq7u6D+h5v4B1uGlooDDR0P5ksZGsw4Q3iBuFyrWrhlR68sha0VeBz/xB6qQrjBg8kNy3OEeHiMKJhTMUdpJciFeo+60BUGuurnz+yL70Xr7MAkSJ1eWqldBwq6WSkClnhIUzRS/usIpnfJBla+E3SO2lja5IZc5+1+TN4DqNVyCumiQzh0slbjjlifKQQiuW7bSbkWuAjlT/auIFwNdBNp9EKNG87+5p5wgmFw22V43JjROA/FrzzaEOpmCaPcNZwSdvhXi+PsHiEg9gFCm76HAl6rLxZZXUu6ekp22TkmA717HSjtqgwqJ0sb7oNHUi5zXxOgPNDgCQ1jCqa7pvbTLOmZqqFMDME3OERrmrObP3UADbDEFmj1Sbpbp/A5wg30wbUEV6To3G2QolCSe7GI+lhenI0XBhyA/nMSXyWGCFTg5wOKYwwVztqzYeU6ppy7i9TWsI4+3t2+sv7b+/W+060RzWTWnrokMghSgeKa7sn2mrXhiEKWdliaqkGhe6e4ytbSBHm9tIkjt47Z+GOhTv3mGkRRW7064ePs08/n4LsOozLgHnrzNZvQAFbmqYQSC9St1diRac7Y/RdtNoQRpA2RP5YFr4UPi/RZrSoh8hvRTSGhZQxDLTUC59+TbtvV/qjyJC0+X+WJ+PIPYF897X4LHsXl3qGE8rw0AuSy0q7tYz9Laqe70vxd/lorzZ8BeHMsseQlerC98ih1KWNX4vl23/X47rZY9locnXOfJt10jnmT8AxZjl2DhT/T57RFvM9yfUxNH8Abzf3fgUGAAA=";
    private static final Log log = LogFactory.getLog(SessionViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected MultipleSelectionPane<File, Session> attachmentSessionPane;
    protected Session selectedSession;
    protected JTextArea sessionParagraph;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SessionViewUI $EmailContentUI0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
    
        String id = node.getId();
        Session session = VradiService.getWikittyProxy().restore(Session.class, id);
        setSelectedSession(session);
        attachmentSessionPane.setBean(session);
        attachmentSessionPane.init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionViewUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SessionViewUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SessionViewUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SessionViewUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SessionViewUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SessionViewUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SessionViewUI() {
        $initialize();
    }

    public SessionViewUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__sessionParagraph(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        VradiService.getWikittyProxy().store(getSelectedSession());
    }

    public void doKeyReleased__on__sessionParagraph(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelectedSession().setParagraph(sessionParagraph.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public MultipleSelectionPane<File, Session> getAttachmentSessionPane() {
        return attachmentSessionPane;
    }

    public Session getSelectedSession() {
        return selectedSession;
    }

    public JTextArea getSessionParagraph() {
        return sessionParagraph;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedSession(Session selectedSession) {
        Session oldValue = this.selectedSession;
        this.selectedSession = selectedSession;
        firePropertyChange(PROPERTY_SELECTED_SESSION, oldValue, selectedSession);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAttachmentSessionPane() {
        $objectMap.put("attachmentSessionPane", attachmentSessionPane = new MultipleSelectionPane<File, Session>());
        
        attachmentSessionPane.setName("attachmentSessionPane");
    }

    protected void createSelectedSession() {
        $objectMap.put("selectedSession", selectedSession = null);
    }

    protected void createSessionParagraph() {
        $objectMap.put("sessionParagraph", sessionParagraph = new JTextArea());
        
        sessionParagraph.setName("sessionParagraph");
        sessionParagraph.setColumns(15);
        sessionParagraph.setLineWrap(true);
        sessionParagraph.setWrapStyleWord(true);
        sessionParagraph.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__sessionParagraph"));
        sessionParagraph.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sessionParagraph"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $EmailContentUI0
        add($JLabel0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add(attachmentSessionPane, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(sessionParagraph);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        attachmentSessionPane.setBeanType(Session.class);
        attachmentSessionPane.setHandler(new AttachmentSessionFileHandler(attachmentSessionPane));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$EmailContentUI0", $EmailContentUI0);
        createSelectedSession();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.sessionParagraph"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSessionParagraph();
        createAttachmentSessionPane();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SESSION_PARAGRAPH_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSession() != null) {
                    SwingUtil.setText(sessionParagraph, getSelectedSession().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().removePropertyChangeListener("paragraph", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_SESSION_PANE_BEAN, true ,"selectedSession") {
        
            @Override
            public void processDataBinding() {
                attachmentSessionPane.setBean(getSelectedSession());
            }
        });
    }

}