/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.models.EmailEntityModel;
import org.chorem.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.EntityRenderer;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.nuiton.wikitty.entities.BusinessEntity;
import static org.nuiton.i18n.I18n._;

public class QueryMakerViewUI<E extends BusinessEntity> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORM = "form";
    public static final String PROPERTY_FORMS_IDS = "formsIds";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_MAKER_FORM_ENABLED = "queryMakerForm.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUy24TMRS9CXkXSqGiakVBKSCBuph8QKpSVBQ1KAVBVFSRDU7GJC6TsWt7mkkXiE/gE2DPBokdK8SCNQs2iF9AiAVbxLXzmKadiEpkMRPZ5x6fe3zuvP0BaSVhZY+EoSMDX7Mude7d2d190NyjLX2XqpZkQnMJg18iCckGzLjjdaXheqNmykvD8tIm7wruU/9IdbkGBaX7HlUdSrWGK5MVLaVK9fF2ORSBHLGORcWxvv71M/nKffkmCRAKVJfBVor/qoo6SdUgyVwNF/GkA1LyiN9GGZL5bdR7zqxtekSp+6RL9+EFZGuQEUQimYZrp2/Zctj6UGiY2w+o7G+T51Q+ZrS3U9WwymXbaXW4pF3nQBKXOQFzaJcwz3l4DCyEZcpoyCqqFOO+hpUT5aiDaUaVUx9goqp0yyOHhxrOm+Yc07Bj5UWI1DMuuxquTietICDC5wxeVV3MwawlDTTqrjGlI8xs1HPFsk/GTfXQcVtSpx6GjsudqqnMC7zOyxNQDIoTBSW6yUQD0jLAZQ2LjZPZeoRbg1QtHkuVIbS7fxbmv374/r4yilIKz74UCz0yCXjFQnJBpTEGXR3kyDhQ2iai3IC8GnaEu8sxwkYNozg870Jk4BZRHaRIZ799/LTw9MsZSFag4HHiVojBVyGvOxJd4J4bitsbVtHZXg6fc0abhoxH+jzApM6uuUSTYpP5Ltq8HqIJyzEmjJU0859/z9ffbYyMSKCwpanwyIz0E8gw32M+tVM1HJjYKZoRigYujwYjblQS5l0QwxQV7fNGXKdZ6pOmR+2JN8PAvG5Z3ebfqqVZOgVNDgfbpZLK/+TJ46X0tpjLJX5Y1gaOFInGz0oz0HR9OvFfCe5bsosFAAA=";
    private static final Log log = LogFactory.getLog(QueryMakerViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Class<E> clazz;
    protected Form form;
    protected List<String> formsIds;
    protected ListSelectorUI<E> queryMakerForm;
    protected QueryMakerViewUI<E> queryMakerViewUI = this;
    protected Session session;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailFormsListCellRenderer emailFormsCellRenderer;
    
    
    public void init(java.util.List<E> toCombo, java.util.List<E> toList) {
        init(false, null, null, toCombo, toList);
    }
    
    public void init(boolean isEmailUI, Form form, EmailFormsListCellRenderer emailFormsCellRenderer, java.util.List<E> toCombo, java.util.List<E> toList) {
    
        this.form = form;
        this.emailFormsCellRenderer = emailFormsCellRenderer;
    
        // Add completion
        AutoCompleteDecorator.decorate(queryMakerForm.getCombo(), EntityRenderer.getInstance());
    
        JButton addButton = queryMakerForm.getAdd();
    
        JButton removeButton = queryMakerForm.getRemove();
    
        if (!isEmailUI) {
    
            queryMakerForm.init(toCombo, toList);
    
            log.info("is not email ui");
            return;
        }
    
        // Add own
        addButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
                addSending();
            }
        });
    
        // Add own
        removeButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
                removeSending();
            }
        });
    
        // Remove default listener
        addButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__add"));
    
        // Remove default listener
        removeButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__remove"));
    
        queryMakerForm.init(toCombo, toList);
    
        queryMakerForm.getList().setCellRenderer(emailFormsCellRenderer);
    
        queryMakerForm.getList().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
    
                JList list = (JList)e.getSource();
    
                if (e.getButton() == MouseEvent.BUTTON3) {
                    Object[] objects = list.getSelectedValues();
                    showPopupMenu(e, objects);
                }
            }
        });
    }
    
    protected void showPopupMenu(MouseEvent e, Object[] objects) {
        if (emailFormsCellRenderer.areDeleted(objects) && VradiConstants.SessionStatus.isToSend(session)) {
    
            // Display popup menu
            final JPopupMenu menu = new JPopupMenu();
            final JMenuItem revertDeletion = new JMenuItem(_("vradi.email.forms.revertDeletion"));
            revertDeletion.addActionListener(new ActionListener() {
    
                @Override
                public void actionPerformed(ActionEvent e) {
                    revertDeletion();
                }
            });
    
            menu.add(revertDeletion);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    
    }
    
    protected void revertDeletion() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().revertUserDeletion(this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().revertGroupDeletion(this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            }
        }
    }
    
    protected void addSending() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().addUserSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getCombo().getSelectedItem());
            } else {
                getHandler().addGroupSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getCombo().getSelectedItem());
            }
        } else {
            if (clazz == User.class) {
                getHandler().addUserSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getCombo().getSelectedItem());
            } else {
                getHandler().addGroupSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getCombo().getSelectedItem());
            }
        }
    }
    
    protected void removeSending() {
        Form form = getForm();
        if (form != null) {
            if (clazz == User.class) {
                getHandler().removeUserSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().removeGroupSending(QueryMakerViewUI.this, session, form.getWikittyId(), queryMakerForm.getList().getSelectedValues());
            }
        } else {
            if (clazz == User.class) {
                getHandler().removeUserSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getList().getSelectedValues());
            } else {
                getHandler().removeGroupSending(QueryMakerViewUI.this, session, getFormsIds(), queryMakerForm.getList().getSelectedValues());
            }
        }
    }
    
    protected void updateSession(Session sessionRestored) {
        getParentContainer(FormViewUI.class).updateSession(sessionRestored);
    }
    
    public EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QueryMakerViewUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QueryMakerViewUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QueryMakerViewUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QueryMakerViewUI() {
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Class<E> getClazz() {
        return clazz;
    }

    public Form getForm() {
        return form;
    }

    public List<String> getFormsIds() {
        return formsIds;
    }

    public ListSelectorUI<E> getQueryMakerForm() {
        return queryMakerForm;
    }

    public Session getSession() {
        return session;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setClazz(Class<E> clazz) {
        Class<E> oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setForm(Form form) {
        Form oldValue = this.form;
        this.form = form;
        firePropertyChange(PROPERTY_FORM, oldValue, form);
    }

    public void setFormsIds(List<String> formsIds) {
        List<String> oldValue = this.formsIds;
        this.formsIds = formsIds;
        firePropertyChange(PROPERTY_FORMS_IDS, oldValue, formsIds);
    }

    public void setSession(Session session) {
        Session oldValue = this.session;
        this.session = session;
        firePropertyChange(PROPERTY_SESSION, oldValue, session);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToQueryMakerViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(queryMakerForm, BorderLayout.CENTER);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createForm() {
        $objectMap.put("form", form = null);
    }

    protected void createFormsIds() {
        $objectMap.put("formsIds", formsIds = null);
    }

    protected void createQueryMakerForm() {
        $objectMap.put("queryMakerForm", queryMakerForm = new ListSelectorUI<E>());
        
        queryMakerForm.setName("queryMakerForm");
        queryMakerForm.setShowHidor(false);
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToQueryMakerViewUI();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        queryMakerForm.setRenderer(new EntityRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("queryMakerViewUI", queryMakerViewUI);
        createSession();
        createClazz();
        createForm();
        createFormsIds();
        createQueryMakerForm();
        // inline creation of queryMakerViewUI
        setName("queryMakerViewUI");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_MAKER_FORM_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                queryMakerForm.setEnabled(isEnabled());
            }
        });
    }

}