/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.email.models.GroupEmailEntityModel;
import org.chorem.vradi.ui.email.models.UserEmailEntityModel;
import org.chorem.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import org.chorem.vradi.ui.offer.OfferListColumnFactory;
import org.chorem.vradi.ui.offer.OfferTable;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.jdesktop.swingx.JXDatePicker;
import static org.chorem.vradi.VradiConstants.SessionStatus;
import static org.nuiton.i18n.I18n._;

public class FormViewUI extends EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUPS_FORM_FORM = "groupsForm.form";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_FORM = "usersForm.form";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdmziOHT6CI0ICIUrABQrozEeDlACBgEUiJwhMUIQb9nyLveF8t+zuJZcUiJ/AT4CeBomOClFQU9Ag/gJCFLSI2buzHZMzsbCLsz0z782b8Ru/+Q4pKWBmg/i+ITxHsQY1lm+sr981N2hV3aKyKhhXroDwlUhCsgLDVisuFZyplDS8EMELi26Duw51dqHnSpCVatumsk6pUnCqE1GVslBuped87okma0tUHOurnz+SL60Xr5MAPkd1QzjK9H6o9iQDJUgyS0EOO22Sgk2cGsoQzKmh3kM6tmgTKVdJgz6D55AuwSAnAskUnO595IAjwPtcwUj+doMwe9F1FJavLV1QkHdFzajWXUEbxqYgFjM8ZlBdZRRd0XjI6NbaEucBx6CCtKRSMsTDzB4gUjLFqDTKYU0bNWBSgpCp7hDda1eX/ANi2hTljXcsVG7heowgpyszLcBQfrlETGojIqdX50elYVQX5Vq12ZpwPS51RwWz3ce/51GxvUKeUhEuoZOl2fGi/n68M5fxJBVBAx04ESUFnOwYBn1ntH3XNkaiAinhYRinr+y16n1MhSYd/8ukmjDI/h4b/fL+27ti05lZ7H0stnTXYaFjuHA5Ffr3UHAktKWnmF1YIXyuAhlJbbzK4OomY4SVozSKw35HNdzQcOMOkXWkSKW/fvg49vjzAUgWIWu7xCoSXb8EGVUXuAXXtnx+fSFQdHBrCJ8jWhvaR1EfbZ+bZ47NHDpNFN6J6Sl6zcc1TMasoaXFzHz6NVp+u9BcRQKlTXQtb68j9QgGw27BmUYXGHuWw1xSz3LblxZ3ewn9PsYji+eD59m4WVNVm+zsKDg8bxFFpk3mWGhkHFQjzgcT6E9GQDjRA2GaOvpeghEu/z/NwJPIzn1wNP88+qLR4Vn9OBfPMNkTw6V/aJjqieFK3wxX+2a4uQ/DH6tT2BphBwAA";
    private static final Log log = LogFactory.getLog(FormViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Form bean;
    protected QueryMakerViewUI<Group> groupsForm;
    protected Session session;
    protected QueryMakerViewUI<User> usersForm;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FormViewUI $EmailContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
        // Get datas
        getHandler().displayForm(this, node);
        Form formSelected = getContextValue(Form.class);
        setBean(formSelected);
    
        session = getHelper().getSessionToDisplay(node);
        updateSession(session);
    }
    
    public void updateSession(Session currentSession){
        setSession(currentSession);
    
        groupsForm.setSession(currentSession);
        usersForm.setSession(currentSession);
    
        java.util.List<User> userSending = EmailDataHelper.getUsersSendingConcernedBy(session, bean.getWikittyId());
        java.util.List<User> allUsers = getAdminHandler().getAllUsers();
        allUsers.removeAll(userSending);
        EmailFormsListCellRenderer emailFormsCellRenderer = new EmailFormsListCellRenderer();
        emailFormsCellRenderer.updateDatas(getSession(), getBean().getWikittyId());
        usersForm.init(true, getBean(), emailFormsCellRenderer, allUsers, userSending);
        usersForm.getQueryMakerForm().getList().setModel(new UserEmailEntityModel(emailFormsCellRenderer, session, getBean()));
    
        java.util.List<Group> groupSending = EmailDataHelper.getGroupsSendingConcernedBy(session, bean.getWikittyId());
        java.util.List<Group> allGroups = getAdminHandler().getAllGroups();
        allGroups.removeAll(groupSending);
        groupsForm.init(true, getBean(), emailFormsCellRenderer, allGroups, groupSending);
        groupsForm.getQueryMakerForm().getList().setModel(new GroupEmailEntityModel(emailFormsCellRenderer, session, getBean()));
    
        usersForm.setEnabled(sessionCanBeSent());
        groupsForm.setEnabled(sessionCanBeSent());
    }
    
    protected boolean sessionCanBeSent() {
        if (session == null) {
            return false;
        }
        return SessionStatus.isActive(session);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FormViewUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FormViewUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FormViewUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FormViewUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FormViewUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FormViewUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FormViewUI() {
        $initialize();
    }

    public FormViewUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Form getBean() {
        return bean;
    }

    public QueryMakerViewUI<Group> getGroupsForm() {
        return groupsForm;
    }

    public Session getSession() {
        return session;
    }

    public QueryMakerViewUI<User> getUsersForm() {
        return usersForm;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Form bean) {
        Form oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setSession(Session session) {
        Session oldValue = this.session;
        this.session = session;
        firePropertyChange(PROPERTY_SESSION, oldValue, session);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createGroupsForm() {
        $objectMap.put("groupsForm", groupsForm = new QueryMakerViewUI<Group>(this));
        
        groupsForm.setName("groupsForm");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createUsersForm() {
        $objectMap.put("usersForm", usersForm = new QueryMakerViewUI<User>(this));
        
        usersForm.setName("usersForm");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $EmailContentUI0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(groupsForm, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usersForm, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        groupsForm.setClazz(Group.class);
        groupsForm.setEnabled(sessionCanBeSent());
        usersForm.setClazz(User.class);
        usersForm.setEnabled(sessionCanBeSent());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$EmailContentUI0", $EmailContentUI0);
        createSession();
        createBean();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.formGroupTitle"));
        createGroupsForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.formUserTitle"));
        createUsersForm();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setSession(getSession());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                usersForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                usersForm.setSession(getSession());
            }
        });
    }

}