/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: GroupListSelectorHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/widget/GroupListSelectorHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.widget;

import jaxx.runtime.swing.ListSelectorUI;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;

import java.util.List;
import java.util.Set;

public class GroupListSelectorHandler extends AdminListSelectorHandler<Group> {

    protected User bean;

    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public GroupListSelectorHandler(ListSelectorUI<Group> listSelector) {
        super(listSelector);

        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, this);
        userVradiEntitiesListener = new VradiEntitiesListener<User>() {

            @Override
            public void entitiesAdded(Set<User> added) {
                if (added.contains(bean)) {
                    updateAll();
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {

            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, userVradiEntitiesListener);
    }

    public User getBean() {
        return bean;
    }

    public void setBean(User bean) {
        this.bean = bean;
    }

    protected void updateAll() {
        String wikittyId = bean.getWikittyId();
        bean = VradiService.getWikittyProxy().restore(User.class, bean.getWikittyId());
        updateCombo(wikittyId);
        updateList(wikittyId);
    }

    protected void updateList(String wikittyId) {

        // Fill list with groups
        List<Group> groups = VradiService.getVradiDataService().findUserGroups(wikittyId);
        setListDatas(groups);

        idsInList.clear();
        idsInList.addAll(VradiHelper.extractIds(groups));
    }

    protected void updateCombo(String wikittyId) {

        // Fill list with groups
        VradiDataService vradiDataService = VradiService.getVradiDataService();
        List<Group> allGroups = vradiDataService.findAllGroups();
        List<Group> groups = vradiDataService.findUserGroups(wikittyId);
        allGroups.removeAll(groups);
        setComboDatas(allGroups);

        idsInCombo.clear();
        idsInCombo.addAll(VradiHelper.extractIds(allGroups));
    }

    @Override
    public void entitiesAdded(Set<Group> groupAdded) {

        if (bean == null) {
            return;
        }

        for (Group added : groupAdded) {
            String wikittyId = added.getWikittyId();
            if (added.getUser() != null && added.getUser().contains(bean.getWikittyId())) {
                if (!idsInList.contains(wikittyId)) {
                    updateAll();
                }
            } else {
                // Remove if is in list
                if (idsInList.contains(wikittyId)) {
                    updateAll();
                } else if (!idsInCombo.contains(wikittyId)) {
                    idsInCombo.add(wikittyId);
                    WikittyProxy proxy = VradiService.getWikittyProxy();
                    setComboDatas(proxy.restore(Group.class, idsInCombo));
                }
            }
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {

        for (String wikittyId : removed) {
            WikittyProxy proxy = VradiService.getWikittyProxy();
            if (idsInCombo.contains(wikittyId)) {
                idsInCombo.remove(wikittyId);
                List<Group> groups = proxy.restore(Group.class, idsInCombo);
                setComboDatas(groups);
            }
            if (idsInList.contains(wikittyId)) {
                idsInList.remove(wikittyId);
                List<Group> groups = proxy.restore(Group.class, idsInList);
                setListDatas(groups);
            }
        }
    }
}
