/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.widget;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.FieldTypeEnum;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.admin.models.FieldSelectModel;
import org.chorem.vradi.ui.helpers.UIHelper;
import static org.nuiton.i18n.I18n._;

public class FieldSelectUI extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_INFOGENE = "infogene";
    public static final String PROPERTY_MODIFIED = "modified";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLAZZ_COMBO_ENABLED = "clazzCombo.enabled";
    public static final String BINDING_CLAZZ_COMBO_SELECTED_ITEM = "clazzCombo.selectedItem";
    public static final String BINDING_DESC_FIELD_ENABLED = "descField.enabled";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_DOWN_VISIBLE = "down.visible";
    public static final String BINDING_NAME_FIELD_ENABLED = "nameField.enabled";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_TRADUCTION_FIELD_ENABLED = "traductionField.enabled";
    public static final String BINDING_TRADUCTION_FIELD_TEXT = "traductionField.text";
    public static final String BINDING_UP_VISIBLE = "up.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(FieldSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FieldSelectModel bean;
    @ValidatorField( validatorId = "validator",  propertyName = "type",  editorName = "clazzCombo")
    protected JComboBox clazzCombo;
    @ValidatorField( validatorId = "validator",  propertyName = "descValue",  editorName = "descField")
    protected JTextField descField;
    protected JButton down;
    protected Boolean infogene;
    protected Boolean modified;
    @ValidatorField( validatorId = "validator",  propertyName = "nameValue",  editorName = "nameField")
    protected JTextField nameField;
    protected JButton remove;
    protected FieldSelectUI requestSelectUI = this;
    protected JTextField traductionField;
    protected JButton up;
    @Validator( validatorId = "validator")
    protected SwingValidator<FieldSelectModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
        getContextValue(SwingValidatorMessageTableModel.class,"errorTable").registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectUI() {
        $initialize();
    }

    public FieldSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clazzCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setType((FieldTypeEnum) clazzCombo.getSelectedItem());                                           setModified(true);
    }

    public void doActionPerformed__on__down(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setUpOrDown(false);                                         log.debug(bean.getNameValue() + " : " + bean.isUpOrDown());                                         setModified(null);
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setUpOrDown(null);                                         setModified(null);
    }

    public void doActionPerformed__on__up(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setUpOrDown(true);                                         log.debug(bean.getNameValue() + " : " + bean.isUpOrDown());                                         setModified(null);
    }

    public void doKeyReleased__on__descField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setDescValue(descField.getText());                                        setModified(true);
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setNameValue(nameField.getText().trim());                                        setModified(true);
    }

    public void doKeyReleased__on__traductionField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setTraduction(traductionField.getText().trim());                                        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectModel getBean() {
        return bean;
    }

    public JComboBox getClazzCombo() {
        return clazzCombo;
    }

    public JTextField getDescField() {
        return descField;
    }

    public JButton getDown() {
        return down;
    }

    public Boolean getInfogene() {
        return infogene;
    }

    public Boolean getModified() {
        return modified;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JButton getRemove() {
        return remove;
    }

    public JTextField getTraductionField() {
        return traductionField;
    }

    public JButton getUp() {
        return up;
    }

    public SwingValidator<FieldSelectModel> getValidator() {
        return validator;
    }

    public Boolean isInfogene() {
        return infogene !=null && infogene;
    }

    public Boolean isModified() {
        return modified !=null && modified;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setInfogene(Boolean infogene) {
        Boolean oldValue = this.infogene;
        this.infogene = infogene;
        firePropertyChange(PROPERTY_INFOGENE, oldValue, infogene);
    }

    public void setModified(Boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(traductionField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel3, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(clazzCombo), new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(bean);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new FieldSelectModel());
    }

    protected void createClazzCombo() {
        $objectMap.put("clazzCombo", clazzCombo = new JComboBox());
        
        clazzCombo.setName("clazzCombo");
        clazzCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clazzCombo"));
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new JTextField());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = false);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTraductionField() {
        $objectMap.put("traductionField", traductionField = new JTextField());
        
        traductionField.setName("traductionField");
        traductionField.setColumns(15);
        traductionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__traductionField"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToRequestSelectUI();
        addChildrenToValidator();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        clazzCombo.setModel(getHandler().getTypesModel());
        clazzCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        up.setIcon(SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("requestSelectUI", requestSelectUI);
        createBean();
        createModified();
        createInfogene();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.lbl"));
        createTraductionField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.desc"));
        createDescField();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminField.type"));
        createClazzCombo();
        createUp();
        createDown();
        createRemove();
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NAME_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                nameField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    SwingUtil.setText(nameField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRADUCTION_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                traductionField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRADUCTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("traduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    SwingUtil.setText(traductionField, bean.getTraduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("traduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESC_FIELD_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                descField.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    SwingUtil.setText(descField, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLAZZ_COMBO_ENABLED, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                clazzCombo.setEnabled(!isInfogene());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLAZZ_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    clazzCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UP_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                up.setVisible(!isInfogene());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DOWN_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                down.setVisible(!isInfogene());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_VISIBLE, true ,"infogene") {
        
            @Override
            public void processDataBinding() {
                remove.setVisible(!isInfogene());
            }
        });
    }

}