/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminListSelectorHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/widget/AdminListSelectorHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.widget;

import jaxx.runtime.swing.ListSelectorHandler;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiEntitiesListener;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.ArrayList;
import java.util.List;

public abstract class AdminListSelectorHandler<B extends BusinessEntity> extends ListSelectorHandler<B> implements VradiEntitiesListener<B> {

    /** Logger. */
    static private final Log log = LogFactory.getLog(AdminListSelectorHandler.class);

    protected List<String> idsInCombo = new ArrayList<String>();

    protected List<String> idsInList = new ArrayList<String>();

    protected AdminListSelectorHandler(ListSelectorUI<B> listSelector) {
        super(listSelector);
    }

    /**
     * Initialize the component.
     *
     * @param toCombo datas to set in combo
     * @param toList  datas to set in list
     */
    @Override
    public void init(List<B> toCombo, List<B> toList) {

        idsInCombo = extractId(toCombo);
        idsInList = extractId(toList);

        super.init(toCombo, toList);
    }

    protected List<String> extractId(List<B> beans) {

        List<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (BusinessEntity bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    protected boolean isLoadedId(String wikittyId) {
        return idsInCombo.contains(wikittyId) || idsInList.contains(wikittyId);
    }
}
