/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.admin.content.AdminThesaurusHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class ThesaurusQueryChangesUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED_QUERIES = "modifiedQueries";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UTU8UQRBtVhdYEFARAcWISkw0ZlYvxgSDyCoqQVFBQ9yLvdsl09g73fYHDByMP8GfoHcvJt48GQ+ePXgx/gVjPHg1Vs8su6ArbljnMDPpqnr1qqtevfpKskaTY8s0jgPtIssrEMxcXlycKy1D2V4BU9ZcWalJ+rRlSKZIulnt3Fhyojjrw/PV8HxBVpSMINoUPT5LuoxdE2BCAGvJka0RZWPy8zXzeKyc3kCtkWqE+uL7t8xz9uxlhpBYIbsOLGX0X1H1SnbPkgxnluzHTCs0L2i0hDQ0j5aQb48/KwhqzC1agSfkKemYJe2KagSz5HjzJScYSXysLBm0IRjqtDN3HOi1QohJwdy7YckFqZeCcig1VIIVTRkPHA8oq/AoUFI5ZYKFxqFKJfDtlvRVJOOPODDvwAF7s89XEfjKgikpBdCo7t0zNjNf1lKI2zSCs0jN+8aBWcULCDaZvHuunkODccIuaIAFWhJgyVFPfBlH4rGVKg2Pg5nFmocP7KvFd4wlh5hvaEun0rS1gHrC3NjMlLNWRhjSv4VieuzdBv70PucPDlWNmhzekgwHLqgPXH0i2ookq53wNzdU/HNG76Ipnc6h36bTAybWnwf7P7398mZ6YyT7MPdAQ9dNisJRUVoq0DZpWl86j85ykb9J1XiR5AwIlGMit5EGxOarZiSH+dKm+/DgOjUhQmQ7Pr97f/Dhx10kM026hKRsmnr/GyRnQ2xoKAWL1aXJhNGe1U587/XcLBlg8IhivwtCGphDitRyGVnSe5FRS0dLPGLYi4kY72SkwZ3UiJVyH370z7+e3LiXNuQ5/Ff3+t1kH5B2HgkeQSLWqg4birNbGXBM1vXWSIFt/tulqio4nrxPNiq8XdA16ay3n4qd/5xOaPu/M02jZFGRVOCKuZgWMUotLpiSszCxc9Be6qy8C4avw03JYBuK/U2gHShL4SpRAbuKir/PDa9KsBVMiBWNmEn7Cew2taFpETO3pDkrSCF1i0CDuGP5OpZLRbrkrkZ+67AWYXtSjaI6/kNTOlGSq9c0b5VUr93Ywp6UaBFtNy+n+/YvGMPNYFiIE1Wd3ymGPy5vw2KkKYRwGw4e4RfG6u3ZGgkAAA==";
    private static final Log log = LogFactory.getLog(ThesaurusQueryChangesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean modifiedQueries;
    protected JXTreeTable resultTreeTable;
    protected ThesaurusQueryChangesUI thesaurusQueryChangesUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected ThesaurusQueryChangesHandler getHandler() {
        return UIHelper.getHandler(this, ThesaurusQueryChangesHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void onCancel() {
        int confirm = JOptionPane.showConfirmDialog(this,
            _("vradi.thesaurusQueryChangesUI.confirm.cancel"), _("vradi.common.cancel"), 
            JOptionPane.YES_NO_OPTION);
    
        if (confirm == JOptionPane.YES_OPTION) {
            dispose();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusQueryChangesUI() {
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ThesaurusQueryChangesUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ThesaurusQueryChangesUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        onCancel();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setModifiedQueries(Boolean.TRUE); this.dispose();
    }

    public void doWindowClosing__on__thesaurusQueryChangesUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getModifiedQueries() {
        return modifiedQueries;
    }

    public JXTreeTable getResultTreeTable() {
        return resultTreeTable;
    }

    public Boolean isModifiedQueries() {
        return modifiedQueries !=null && modifiedQueries;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModifiedQueries(Boolean modifiedQueries) {
        Boolean oldValue = this.modifiedQueries;
        this.modifiedQueries = modifiedQueries;
        firePropertyChange(PROPERTY_MODIFIED_QUERIES, oldValue, modifiedQueries);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusQueryChangesUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createModifiedQueries() {
        $objectMap.put("modifiedQueries", modifiedQueries = Boolean.FALSE);
    }

    protected void createResultTreeTable() {
        $objectMap.put("resultTreeTable", resultTreeTable = new JXTreeTable());
        
        resultTreeTable.setName("resultTreeTable");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusQueryChangesUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTreeTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 12 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        resultTreeTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        resultTreeTable.setColumnControlVisible(true);
        resultTreeTable.setExpandsSelectedPaths(true);
        resultTreeTable.setGridColor(Color.GRAY);
        resultTreeTable.setHorizontalScrollEnabled(true);
        resultTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        resultTreeTable.setShowGrid(false);
        resultTreeTable.setTreeTableModel(getHandler().getResultTreeTableModel(this));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        thesaurusQueryChangesUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusQueryChangesUI", thesaurusQueryChangesUI);
        createModifiedQueries();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTreeTable();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of thesaurusQueryChangesUI
        setName("thesaurusQueryChangesUI");
        thesaurusQueryChangesUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        thesaurusQueryChangesUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__thesaurusQueryChangesUI"));
        
        $completeSetup();
    }

}