/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.admin.models.TemplateFieldTableModel;
import org.chorem.vradi.ui.admin.renderers.JListCellRenderer;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.editors.JListCellEditor;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected WikittyExtension extension;
    protected TemplateFieldTableModel fieldsModel;
    protected JXTable fieldsTable;
    protected String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        ListCellRenderer listRenderer = new DefaultListCellRenderer() {
    
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
    
                if (value != null) {
                    value = VradiHelper.getTraduction(extension, (String) value);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    
        JListCellRenderer renderer = new JListCellRenderer(listRenderer);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(listRenderer, true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public void cancel() {
        setFieldsModel(null);
        close();
    }
    
    public void valid() {
        if (getHandler().checkAssociation(this, getExtension(), fieldsModel)) {
            close();
        } else {
            cancel();
        }
    }
    
    public void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Window param0) {
        super(param0);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TemplateFieldBindingUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        valid();
    }

    public void doWindowClosing__on__templateFieldBindingUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public WikittyExtension getExtension() {
        return extension;
    }

    public TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public JXTable getFieldsTable() {
        return fieldsTable;
    }

    public String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(WikittyExtension extension) {
        WikittyExtension oldValue = this.extension;
        this.extension = extension;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, extension);
    }

    public void setFieldsModel(TemplateFieldTableModel fieldsModel) {
        TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = fieldsModel;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, fieldsModel);
    }

    public void setTemplate(String template) {
        String oldValue = this.template;
        this.template = template;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, template);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        // late initializer
        templateFieldBindingUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("templateFieldBindingUI", templateFieldBindingUI);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}