/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ClientNavigationTreeHelper.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/helpers/ClientNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.helpers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;

import java.util.Set;

/** @author letellier */
public class ClientNavigationTreeHelper extends AdminNavigationTreeHelper<Client> {

    /** Logger. */
    static private final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);

    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);

        VradiContext.get().getVradiNotifier().addVradiListener(Client.class, this);
        userVradiEntitiesListener = new VradiEntitiesListener<User>() {

            @Override
            public void entitiesAdded(Set<User> added) {

                for (User user : added) {

                    String wikittyId = user.getWikittyId();

                    // cas creation
                    VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);

                    // cas modification
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("User modification occured");
                        }
                        // Reconstruction des fils
                        refresh(existingNode);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("User creation occured");
                        }
                        createUserNode(wikittyId, false);
                    }
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                removeEntities(removed);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, userVradiEntitiesListener);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.CLIENT.getCategoryName(),
                null,
                new ClientsAndUsersNodeLoadors()
        );
    }

    @Override
    public void createEntityNode(String wikittyId) {
        createClientNode(wikittyId, false);
    }
}
