/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminNavigationTreeHelper.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/helpers/AdminNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.helpers;

import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.loadors.ClientUsersNodeLoadors;
import org.chorem.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import org.chorem.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import org.chorem.vradi.ui.admin.loadors.GroupsNodeLoadors;
import org.chorem.vradi.ui.admin.loadors.StreamNodeLoadors;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.chorem.vradi.ui.tree.helpers.VradiTreeHelper;
import org.nuiton.wikitty.entities.BusinessEntity;

import javax.swing.tree.TreeModel;

/**
 * Navigation tree helpers.
 *
 * @author sletellier
 * @see NavTreeHelper
 */
public abstract class AdminNavigationTreeHelper<C extends BusinessEntity> extends VradiTreeHelper<C> {

    /** Logger */
    static private final Log log = LogFactory.getLog(AdminNavigationTreeHelper.class);

    public AdminNavigationTreeHelper(VradiDataProvider dataProvider) {
        super();
        setDataProvider(dataProvider);
    }

    public TreeModel createTreeModel() {

        // Create root static node
        VradiTreeNode root = new VradiTreeNode(
                String.class,
                "Root node",
                null,
                null
        );

        VradiTreeNode child = createNode();

        // Add to root
        root.add(child);

        // Create model
        TreeModel model = createModel(root);

        // Populate childs nodes
        root.populateChilds(getBridge(), getDataProvider());

        registerLoadedIds(child);

        return model;
    }

    public abstract VradiTreeNode createNode();

    public VradiTreeNode getParentSelectedCategoryNode(String categoryName) {
        return getParentCategoryNode(getSelectedNode(), categoryName);
    }

    public static VradiTreeNode getParentCategoryNode(VradiTreeNode node, String categoryName) {
        if (node == null) {
            return null;
        }

        if (node.getId().contains(categoryName)) {
            return node;
        }
        return getParentCategoryNode(node.getParent(), categoryName);
    }

    public VradiTreeNode getParentSelectedNode(Class type) {
        return getParentNode(getSelectedNode(), type);
    }

    public static VradiTreeNode getParentNode(VradiTreeNode node, Class type) {
        if (node == null) {
            return null;
        }

        if (type.equals(node.getInternalClass())) {
            return node;
        }
        return getParentNode(node.getParent(), type);
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass, String categoryName) {
        createNode(nodeLoadorsClass, categoryName, null, false);
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass,
                           String categoryName, String id, boolean select) {

        VradiTreeNode node = findNode(getRootNode(), id);

        // If not found create it
        if (node == null) {
            VradiTreeNode parentNode = findNode(getRootNode(), categoryName);
            if (parentNode == null) {
                return;
            }
            node = getChildLoador(nodeLoadorsClass).createNode(id, getDataProvider());

            insertNode(parentNode, node);
        }

        // Select
        if (select && (getSelectedNode() == null || !getSelectedNode().getId().equals(node.getId()))) {
            selectNode(node);
        }
    }

    public void createAndSelectClientNode(String clientId) {
        createClientNode(clientId, true);
    }

    public void createClientNode(String clientId, boolean select) {
        createNode(ClientsAndUsersNodeLoadors.class, AdminBeanConstant.CLIENT.getCategoryName(), clientId, select);
    }

    public void createAndSelectGroupNode(String groupId) {
        createGroupNode(groupId, true);
    }

    public void createGroupNode(String groupId, boolean select) {
        createNode(GroupsNodeLoadors.class, AdminBeanConstant.GROUP.getCategoryName(), groupId, select);
    }

    public void createAndSelectUserNode(String userId, String clientId) {
        createUserNode(userId, clientId, true);
    }

    public void createUserNode(String userId, boolean select) {
        createUserNode(userId, null, select);
    }

    public void createUserNode(String userId, String clientId, boolean select) {
        if (clientId == null) {
            User user = VradiService.getWikittyProxy().restore(User.class, userId);
            if (user == null) {
                return;
            }
            clientId = user.getClient();
        }
        createNode(ClientUsersNodeLoadors.class, clientId + AdminBeanConstant.USER.getCategoryName(), userId, select);
    }

    public void createAndSelectFormTypeNode(String extensionId) {
        createFormTypeNode(extensionId, true);
    }

    public void createFormTypeNode(String extensionId, boolean select) {
        createNode(FormTypeNodeLoadors.class, AdminBeanConstant.FORM_TYPE.getCategoryName(), extensionId, select);
    }

    public void createAndSelectStreamNode(String streamId) {
        createStreamNode(streamId, true);
    }

    public void createStreamNode(String streamId, boolean select) {
        createNode(StreamNodeLoadors.class, AdminBeanConstant.XML_STREAM.getCategoryName(), streamId, select);
    }

    /**
     * Method to reselect a category node (during some tree updates, while
     * saving, node id change so, it not possible to reselect using oldPath.
     *
     * @param node The node to reselect
     */
    public void reSelectCategory(VradiTreeNode node) {
        String id = node.getParent().getId();
        log.debug("Try to load subcategory for node : " + id);
        selectNode(id, node.getId());
    }

    public Client getClientSelected() {
        VradiTreeNode clientNode = getParentSelectedNode(Client.class);
        if (clientNode == null) {
            return null;
        }
        return VradiService.getWikittyProxy().restore(Client.class, clientNode.getId());
    }


}
