/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminBeanConstant.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/helpers/AdminBeanConstant.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
/* *##%
 * Copyright (C) 2010 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.vradi.ui.admin.helpers;

import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.ClientImpl;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupImpl;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.UserImpl;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.WebHarvestStreamImpl;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.ui.admin.content.AdminClientUI;
import org.chorem.vradi.ui.admin.content.AdminFormTypeUI;
import org.chorem.vradi.ui.admin.content.AdminGroupUI;
import org.chorem.vradi.ui.admin.content.AdminStatusUI;
import org.chorem.vradi.ui.admin.content.AdminUserUI;
import org.chorem.vradi.ui.admin.content.AdminXmlStreamUI;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyExtension;

import java.util.Date;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author sletellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public enum AdminBeanConstant {
    // Client category
    CLIENT(n_("vradi.client.category"), n_("vradi.adminClient.newClientName"), Client.class, AdminClientUI.class),
    // Group category
    GROUP(n_("vradi.group.category"), n_("vradi.adminGroup.newGroupName"), Group.class, AdminGroupUI.class),
    // User category
    USER(n_("vradi.user.category"), n_("vradi.adminUser.newUserName"), User.class, AdminUserUI.class),
    // Status category
    STATUS(n_("vradi.status.category"), n_("vradi.adminStatus.newStatusName"), Status.class, AdminStatusUI.class),
    // Stream category
    XML_STREAM(n_("vradi.stream.category"), n_("vradi.adminXmlStream.newStreamName"), XmlStream.class, AdminXmlStreamUI.class),
    // Stream category
    WEB_HARVEST_STREAM(n_("vradi.stream.category"), n_("vradi.adminXmlStream.newWebHarvestStreamName"), WebHarvestStream.class, AdminXmlStreamUI.class),
    // Form type category
    FORM_TYPE(n_("vradi.formType.category"), n_("vradi.adminXmlStream.newFormTypeName"), WikittyExtension.class, AdminFormTypeUI.class);

    private String categoryName;

    private String newEntityName;

    private Class<?> beanClass;

    private Class<?> uiClass;

    private AdminBeanConstant(String categoryName, String newEntityName, Class<?> beanClass, Class<?> uiClass) {
        this.categoryName = categoryName;
        this.newEntityName = newEntityName;
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public String getNewEntityName() {
        return _(newEntityName);
    }

    public Class<?> getBeanClass() {
        return beanClass;
    }

    public Class<?> getUIClass() {
        return uiClass;
    }

    public static AdminBeanConstant getConstantByUIClass(Class uiClass) {
        for (AdminBeanConstant constant : values()) {
            if (uiClass.equals(constant.getUIClass())) {
                return constant;
            }
        }
        return null;
    }

    public static AdminBeanConstant getConstantByBeanClass(Class beanClass) {
        for (AdminBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())) {
                return constant;
            }
        }
        return null;
    }

    public Object getBean(WikittyProxy proxy, String id) {
        Object result = null;
        switch (this) {
            case CLIENT:
                if (id == null) {
                    Client newClient = new ClientImpl();
                    newClient.setName(getNewEntityName());
                    result = newClient;
                } else {
                    result = proxy.restore(Client.class, id);
                }
                break;
            case GROUP:
                if (id == null) {
                    Group newGroup = new GroupImpl();
                    newGroup.setName(getNewEntityName());
                    result = newGroup;
                } else {
                    result = proxy.restore(Group.class, id);
                }
                break;
            case USER:
                if (id == null) {
                    User newUser = new UserImpl();
                    newUser.setCreationDate(new Date());
                    newUser.setBeginSearchDate(new Date());
                    newUser.setName(getNewEntityName());
                    newUser.setEnable(true);
                    newUser.setValidEmail(false);
                    result = newUser;
                } else {
                    result = proxy.restore(User.class, id);
                }
                break;
            case FORM_TYPE:
                result = proxy.restoreExtensionLastVersion(id);
                break;
            case XML_STREAM:
                if (id == null) {
                    XmlStream newXmlStream = new XmlStreamImpl();
                    newXmlStream.setName(getNewEntityName());
                    result = newXmlStream;
                } else {
                    result = proxy.restore(XmlStream.class, id);
                }
                break;
            case WEB_HARVEST_STREAM:
                if (id == null) {
                    WebHarvestStream newWebHarvest = new WebHarvestStreamImpl();
                    newWebHarvest.setName(_(getNewEntityName()));
                    result = newWebHarvest;
                } else {
                    result = proxy.restore(WebHarvestStream.class, id);
                }
                break;
        }
        return result;
    }

    public static Class<?> getUIClass(String categoryName) {
        for (AdminBeanConstant constant : values()) {

            // For user category : clientId + CategoryUserName
            if (categoryName.matches(".*" + constant.getCategoryName())) {
                return constant.getUIClass();
            }
        }
        return null;
    }

    public static Class<?> getUIClass(Class<?> beanClass) {
        for (AdminBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())) {
                return constant.getUIClass();
            }
        }
        return null;
    }

    public static boolean isCategoryNode(VradiTreeNode node) {
        return isCategoryId(node.getId());
    }

    public static boolean isCategoryId(String id) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (id.contains(constant.categoryName)) {
                return true;
            }
        }
        return false;
    }
}
