/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.ui.admin.AdminHandler;
import static org.nuiton.i18n.I18n._;

public class RequestListUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(RequestListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Group bean;
    protected JPanel content;
    protected JScrollPane contentScroll;
    protected Table header;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RequestListUI $JPanel0 = this;
    private JLabel $JLabel0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        content.setVisible(false);
        content.removeAll();
        content.setAlignmentY(TOP_ALIGNMENT);
        
        if (bean != null && bean.getQueries() != null) {
            for (String query : bean.getQueries()) {
                createRequest(query);
            }
        }
        content.setVisible(true);    
    }
    
    protected void createRequest(final String query) {
        RequestSelectUI requestUI = new RequestSelectUI(RequestListUI.this);
        requestUI.setAlignmentY(TOP_ALIGNMENT);
    
        if (log.isDebugEnabled()){
            log.debug("Open query " + query);
        }
        
        try {
            requestUI.setBean(new QueryBean(query));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return;
        }
        
        requestUI.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RequestSelectUI query = (RequestSelectUI) evt.getSource();
    
                QueryBean oldValue = (QueryBean) evt.getOldValue();
                QueryBean newValue = (QueryBean) evt.getNewValue();
    
                if (log.isDebugEnabled()
                    && oldValue != null
                    && newValue != null) {
                    log.debug("Update query from '" + oldValue.getQueryLine() + "' to '" + newValue.getQueryLine() + "'");
                }
    
                bean.removeQueries(oldValue.getQueryLine());
    
                if (newValue == null) {
                    // this means remove
                    content.setVisible(false);
                    content.remove(query);
                    content.setVisible(true);
                } else {
                    // this means update
                    bean.addQueries(newValue.getQueryLine());
                }
            }
        });
        requestUI.setAlignmentY(Component.TOP_ALIGNMENT);
        content.add(requestUI);
        validate();
    }
    
    protected void showHistory() {
        AdminHandler handler = getContextValue(AdminHandler.class);
        handler.showHistory(bean.getWikittyId());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestListUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestListUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestListUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RequestListUI() {
        $initialize();
    }

    public RequestListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showHistory();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createRequest("");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Group getBean() {
        return bean;
    }

    public JPanel getContent() {
        return content;
    }

    public JScrollPane getContentScroll() {
        return contentScroll;
    }

    public Table getHeader() {
        return header;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Group bean) {
        Group oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContentScroll() {
        if (!allComponentsCreated) {
            return;
        }
        contentScroll.getViewport().add(content);
    }

    protected void addChildrenToHeader() {
        if (!allComponentsCreated) {
            return;
        }
        header.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        header.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createContentScroll() {
        $objectMap.put("contentScroll", contentScroll = new JScrollPane());
        
        contentScroll.setName("contentScroll");
    }

    protected void createHeader() {
        $objectMap.put("header", header = new Table());
        
        header.setName("header");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(header);
        add(contentScroll, BorderLayout.CENTER);
        addChildrenToHeader();
        addChildrenToContentScroll();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("history"));
        contentScroll.setColumnHeaderView(header);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createBean();
        createHeader();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminRequest.title"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.history.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminRequest.new"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContentScroll();
        createContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0,1));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled());
            }
        });
    }

}