/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Infogene;
import org.chorem.vradi.entities.ModificationTag;
import org.chorem.vradi.entities.VradiUser;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.AdminPopupUI;
import org.chorem.vradi.ui.admin.models.XmlStreamFieldTableModel;
import org.chorem.vradi.ui.admin.renderers.JListCellRenderer;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.offer.editors.JListCellEditor;
import org.chorem.vradi.ui.task.ProgressBarUI;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends AdminContentUI<XmlStream> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_UI_ENABLED = "adminXmlStreamUI.enabled";
    public static final String BINDING_CREATE_FORMS_ENABLED = "createForms.enabled";
    public static final String BINDING_CREATE_XML_STREAM_ENABLED = "createXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_WEB_HARVEST_STREAM_URL_TEXT = "webHarvestStreamUrl.text";
    public static final String BINDING_XML_STREAM_CONFIG_BEAN = "xmlStreamConfig.bean";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_SIZE = "$JLabel0.size";
    private static final String BINDING_$JLABEL1_SIZE = "$JLabel1.size";
    private static final String BINDING_$JLABEL2_SIZE = "$JLabel2.size";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminXmlStreamUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table adminXmlStreamForm;
    protected AdminXmlStreamUI adminXmlStreamUI = this;
    protected XmlStream bean;
    protected JPanel cards;
    protected JButton createForms;
    protected JButton createWebHarvestStream;
    protected JButton createXmlStream;
    protected XmlStreamFieldTableModel fieldsModel;
    protected JXTable fieldsTable;
    @ValidatorField( validatorId = "validator",  propertyName = "formTypeName",  editorName = "formTypeCombo")
    protected JComboBox formTypeCombo;
    protected ComboBoxModel formTypeSelectionModel;
    protected JLabel lblName;
    protected JButton openWebHarvestEditor;
    protected JButton openWebHarvestScript;
    protected JLabel title;
    protected JButton validateUrl;
    @Validator( validatorId = "validator")
    protected SwingValidator<XmlStream> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JComboBox webHarvestScript;
    protected JTextField webHarvestStreamUrl;
    protected XmlStreamConfigUI xmlStreamConfig;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "xmlStreamName")
    protected JTextField xmlStreamName;
    protected JLabel xmlStreamPreview;
    protected JButton xmlStreamSite;
    @ValidatorField( validatorId = "validator",  propertyName = "url",  editorName = "xmlStreamUrl")
    protected JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JButton $JButton0;
    private HidorButton $HidorButton0;
    private Table $Table0;
    private JLabel $JLabel0;
    private Table $Table1;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    final static String XML_STREAM_PANEL = "vradi.adminXmlStream.xmlPanel";
    final static String WEB_HARVEST_PANEL = "vradi.adminXmlStream.webHarvestPanel";
    protected TableModelListener tableListener;
    
    
    void $afterCompleteSetup() {
    
        tableListener = new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                setModified(true);
            }
        };
    
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
            n_("vradi.adminXmlStream.table.field.name"),
            n_("vradi.adminXmlStream.table.field.name.tip"),
            n_("vradi.adminXmlStream.table.field.values"),
            n_("vradi.adminXmlStream.table.field.values.tip"),
            n_("vradi.adminXmlStream.table.field.defaultValue"),
            n_("vradi.adminXmlStream.table.field.defaultValue.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value,
                      boolean isSelected, boolean hasFocus, int row, int column) {
    
                String sTranslatedValue = null;
                if (column == 0 && value != null) {
                    String sValue = (String) value;
                    int dot = sValue.lastIndexOf(".");
                    String extName = sValue.substring(0, dot);
                    if (Infogene.EXT_INFOGENE.equals(extName) || Form.EXT_FORM.equals(extName)) {
                        sTranslatedValue = _(sValue);
                    } else {
                        sTranslatedValue = sValue.substring(dot + 1);
                    }
                }
                return super.getTableCellRendererComponent(table, sTranslatedValue, isSelected, hasFocus, row, column);
            }
        };
    
        JListCellRenderer render = new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
        setContextValue(render);
    
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, tbc);
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
    
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
            HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
        
        getHandler().openAdminXmlStreamUI(this);
        xmlStreamPreview.setToolTipText(getFirstElementPreview());
        formTypeCombo.setModel(formTypeSelectionModel);
    
        fieldsModel.addTableModelListener(tableListener);
    }
    
    protected void updateFormType() {
        WikittyExtension extension = (WikittyExtension) formTypeCombo.getSelectedItem();
        if (extension != null && bean != null && !extension.getName().equals(bean.getFormTypeName())) {
            bean.setFormTypeName(extension.getName());
            validateFormTypeChoice();
        }
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        getHandler().updateXmlStreamFieldModel(this);
        validate();
    }
    
    @Override
    public void save() {
        stopEditing();
    
        fieldsModel.removeTableModelListener(tableListener);
        
        // add modification info
        String login = getContextValue(VradiUser.class).getLogin();
        ModificationTag xmlStreamTag = VradiService.getWikittyProxy().cast(bean, ModificationTag.class);
        xmlStreamTag.setLastModified(new Date());
        xmlStreamTag.setLastModifier(login);
        
        XmlStream stream = getHandler().saveStream(this, getHelper(), getBean(), fieldsModel.getBindings());
        // echatellier juste pour que la date de mise à jour se rafraichisse
        setBean(null);
        setBean(stream);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        xmlStreamName.setText("");
        xmlStreamUrl.setText("");
        webHarvestStreamUrl.setText("");
        webHarvestScript.setModel(new DefaultComboBoxModel());
        formTypeCombo.setSelectedItem(null);
        fieldsModel.clear();
    }
    
    protected void initScriptComboBox() {
        getHandler().initScriptComboBox(webHarvestScript, (WebHarvestStream)getBean());
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor() != null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
    }
    
    protected void createForms() {
        getHandler().createForms(this);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminXmlStream.title", SwingUtil.getStringValue(name));
    }
    
    protected void browseURI(String url) {
        try {
            UIHelper.browseURI(url);
        } catch (IOException eee){
            log.error("Cannot display XMLStream : " + url);
            JOptionPane.showMessageDialog(null,
                    _("vradi.message.cannot.display.stream"));
    
        }
    }
    
    protected String getCardToDisplay() {
        if (getBean() instanceof WebHarvestStream) {
            return WEB_HARVEST_PANEL;
        }
        return XML_STREAM_PANEL;
    }
    
    protected String getFirstElementPreview() {
        return getHandler().getFirstElementPreview(this, getBean());
    }
    
    protected void updateUrl() {
        getBean().setUrl(xmlStreamUrl.getText().matches("\\w+://.*") ? xmlStreamUrl.getText() : "http://" + xmlStreamUrl.getText());
        xmlStreamPreview.setToolTipText(getFirstElementPreview());
    }
    
    protected void updateWebHarvestUrl() {
        getBean().setUrl(webHarvestStreamUrl.getText().matches("\\w+://.*") ? webHarvestStreamUrl.getText() : "http://" + webHarvestStreamUrl.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminXmlStreamUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminXmlStreamUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminXmlStreamUI() {
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createForms(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createForms();
    }

    public void doActionPerformed__on__createWebHarvestStream(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createWebHarvestStream(this);
    }

    public void doActionPerformed__on__createXmlStream(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createXmlStream(this);
    }

    public void doActionPerformed__on__formTypeCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateFormType();
    }

    public void doActionPerformed__on__openWebHarvestEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().openWebHarvestEditor(this);
    }

    public void doActionPerformed__on__openWebHarvestScript(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addWebHarvestScript(this, (WebHarvestStream)getBean());initScriptComboBox();
    }

    public void doActionPerformed__on__validateUrl(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validateFormTypeChoice();
    }

    public void doActionPerformed__on__xmlStreamSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        browseURI(getBean().getUrl());
    }

    public void doKeyReleased__on__webHarvestStreamUrl(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateWebHarvestUrl();
    }

    public void doKeyReleased__on__xmlStreamName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(xmlStreamName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__xmlStreamUrl(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateUrl();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public XmlStream getBean() {
        return bean;
    }

    public JPanel getCards() {
        return cards;
    }

    public JButton getCreateForms() {
        return createForms;
    }

    public JButton getCreateWebHarvestStream() {
        return createWebHarvestStream;
    }

    public JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public JXTable getFieldsTable() {
        return fieldsTable;
    }

    public JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public JLabel getLblName() {
        return lblName;
    }

    public JButton getOpenWebHarvestEditor() {
        return openWebHarvestEditor;
    }

    public JButton getOpenWebHarvestScript() {
        return openWebHarvestScript;
    }

    public JLabel getTitle() {
        return title;
    }

    public JButton getValidateUrl() {
        return validateUrl;
    }

    public SwingValidator<XmlStream> getValidator() {
        return validator;
    }

    public JComboBox getWebHarvestScript() {
        return webHarvestScript;
    }

    public JTextField getWebHarvestStreamUrl() {
        return webHarvestStreamUrl;
    }

    public XmlStreamConfigUI getXmlStreamConfig() {
        return xmlStreamConfig;
    }

    public JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public JButton getXmlStreamSite() {
        return xmlStreamSite;
    }

    public JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(XmlStream bean) {
        XmlStream oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setFormTypeSelectionModel(ComboBoxModel formTypeSelectionModel) {
        ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = formTypeSelectionModel;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, formTypeSelectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(cards, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamConfig, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToCards() {
        if (!allComponentsCreated) {
            return;
        }
        cards.add($Table0, XML_STREAM_PANEL);
        cards.add($Table1, WEB_HARVEST_PANEL);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new Table());
        
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCards() {
        $objectMap.put("cards", cards = new JPanel());
        
        cards.setName("cards");
        cards.setLayout(new CardLayout());
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new JButton());
        
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateWebHarvestStream() {
        $objectMap.put("createWebHarvestStream", createWebHarvestStream = new JButton());
        
        createWebHarvestStream.setName("createWebHarvestStream");
        createWebHarvestStream.setText(_("vradi.adminXmlStream.createWebHarvestStream"));
        createWebHarvestStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createWebHarvestStream"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new JButton());
        
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new XmlStreamFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new JComboBox());
        
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel());
    }

    protected void createLblName() {
        $objectMap.put("lblName", lblName = new JLabel());
        
        lblName.setName("lblName");
        lblName.setText(_("vradi.adminXmlStream.name"));
    }

    protected void createOpenWebHarvestEditor() {
        $objectMap.put("openWebHarvestEditor", openWebHarvestEditor = new JButton());
        
        openWebHarvestEditor.setName("openWebHarvestEditor");
        openWebHarvestEditor.setToolTipText(_("vradi.adminXmlStream.createNewWebHarvest.toolTip"));
        openWebHarvestEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestEditor"));
    }

    protected void createOpenWebHarvestScript() {
        $objectMap.put("openWebHarvestScript", openWebHarvestScript = new JButton());
        
        openWebHarvestScript.setName("openWebHarvestScript");
        openWebHarvestScript.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestScript"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        toolbar.setLayout(
          new BoxLayout(toolbar, 0)
        );
        toolbar.putClientProperty("help", 
        "ui.main.toolbar"
        );
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new JButton());
        
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(XmlStream.class, null));
    }

    protected void createWebHarvestScript() {
        $objectMap.put("webHarvestScript", webHarvestScript = new JComboBox());
        
        webHarvestScript.setName("webHarvestScript");
    }

    protected void createWebHarvestStreamUrl() {
        $objectMap.put("webHarvestStreamUrl", webHarvestStreamUrl = new JTextField());
        
        webHarvestStreamUrl.setName("webHarvestStreamUrl");
        webHarvestStreamUrl.setColumns(15);
        webHarvestStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__webHarvestStreamUrl"));
    }

    protected void createXmlStreamConfig() {
        $objectMap.put("xmlStreamConfig", xmlStreamConfig = new XmlStreamConfigUI());
        
        xmlStreamConfig.setName("xmlStreamConfig");
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new JTextField());
        
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new JLabel());
        
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamSite() {
        $objectMap.put("xmlStreamSite", xmlStreamSite = new JButton());
        
        xmlStreamSite.setName("xmlStreamSite");
        xmlStreamSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__xmlStreamSite"));
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new JTextField());
        
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(createWebHarvestStream);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        addChildrenToCards();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamPreview, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamSite, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestStreamUrl, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestScript, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestScript, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestEditor, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 22 property setters
        createXmlStream.setIcon(SwingUtil.getUIManagerActionIcon("feed.add"));
        createWebHarvestStream.setIcon(SwingUtil.getUIManagerActionIcon("feed.add"));
        createWebHarvestStream.setVisible(false);
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(SwingUtil.getUIManagerActionIcon("feed.magnify"));
        xmlStreamPreview.setToolTipText(_(getFirstElementPreview()));
        xmlStreamSite.setIcon(SwingUtil.getUIManagerActionIcon("site"));
        openWebHarvestScript.setIcon(SwingUtil.getUIManagerActionIcon("open"));
        openWebHarvestEditor.setIcon(SwingUtil.getUIManagerActionIcon("edit"));
        formTypeCombo.setModel(formTypeSelectionModel);
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        title.setHorizontalTextPosition(
          JLabel . LEFT
        );
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminXmlStreamUI", adminXmlStreamUI);
        createBean();
        createFieldsModel();
        createFormTypeSelectionModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createCreateWebHarvestStream();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        createLblName();
        createXmlStreamName();
        createCards();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        createXmlStreamSite();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.startUrl"));
        createWebHarvestStreamUrl();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.webHarvestScript"));
        createWebHarvestScript();
        createOpenWebHarvestScript();
        createOpenWebHarvestEditor();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        createXmlStreamConfig();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of adminXmlStreamUI
        setName("adminXmlStreamUI");
        ((jaxx.runtime.swing.Table) adminXmlStreamUI.getObjectById("toolbar")).setLayout(
          new BoxLayout(toolbar, 0)
        );
        
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_XML_STREAM_UI_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_XML_STREAM_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createXmlStream.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_FORMS_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                createForms.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(xmlStreamName, getBean().getName());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel0.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    JLabel $target = (JLabel) $bindingSources.remove("lblName");
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ComponentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(xmlStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel1.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    JLabel $target = (JLabel) $bindingSources.remove("lblName");
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(ComponentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WEB_HARVEST_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(webHarvestStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel2.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    JLabel $target = (JLabel) $bindingSources.remove("lblName");
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                    }
                }
            }
        
            public void $pr$u2(ComponentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    formTypeCombo.setSelectedItem(getHandler().getExtension(getBean().getFormTypeName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_CONFIG_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                xmlStreamConfig.setBean(getBean());
            }
        });
    }

}