/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.ThesaurusHighlighter;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class AdminThesaurusUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_THESAURUS_SELECTED = "thesaurusSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_THESAURUS_HIGHLIGHTERS = "thesaurus.highlighters";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected JButton create;
    protected JButton createNewRoot;
    protected JButton delete;
    protected JButton edit;
    protected JCheckBox expandByDefault;
    protected JToolBar headerPanel;
    protected Boolean modified;
    protected Boolean selected;
    protected JButton sortButton;
    protected JXTreeTable thesaurus;
    protected Boolean thesaurusSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    protected ThesaurusHighlighter highlighter;
    
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    public ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                    // Add mouse listener to enable menus
                    JMenuItem menuAddRootChild = new JMenuItem();
                    menuAddRootChild.setText(_("vradi.menu.addRootChildThesaurus"));
                    menuAddRootChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                             createNewRoot();
                        }
                    });
                    popup.add(menuAddRootChild);
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    if (isThesaurusSelected()) {
                        JMenuItem menuMoveSeleted = new JMenuItem();
                        menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                        menuMoveSeleted.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                moveSelected();
                            }
                        });
                        popup.add(menuMoveSeleted);
                    }
    
                    JMenuItem menuChangeColorSeleted = new JMenuItem();
                    menuChangeColorSeleted.setText(_("vradi.menu.menuChangeColorSeleted"));
                    menuChangeColorSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            changeColorSelected();
                        }
                    });
                    popup.add(menuChangeColorSeleted);
    
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)e.getPath().getLastPathComponent();
    
                boolean selectionEmpty = thesaurus.getTreeSelectionModel().isSelectionEmpty();
    
                // Set as selected
                setSelected(!selectionEmpty);
    
                // Is thesaurus
                if (selectedNode != null) {
                    setThesaurusSelected(isSelected() &&
                            Thesaurus.class.equals(selectedNode.getInternalClass()));
                }
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(highlighter);
    }
    
    protected void createNewRoot(){
        // Ajout dun nouveau root thesaurus
        getThesaurusHandler().createRootThesaurus(this);
    }
    
    protected void addChildToSelected(){
        // Ajout dun nouveau thesaurus
        getThesaurusHandler().addChildThesaurusToSelected(this, helper);
    }
    
    protected void editSelected(){
        // Edition dun thesaurus
        getThesaurusHandler().editThesaurusSelected(this, helper);
    }
    
    protected void deleteSelected(){
        // Suppression dun thesaurus
        getThesaurusHandler().deleteThesaurusSelected(this, helper);
    }
    
    protected void moveSelected(){
        // Move thesaurus
        getThesaurusHandler().moveThesaurusSelected(this, helper);
    }
    
    protected void changeColorSelected(){
        // Change color af selected detph
        getThesaurusHandler().changeThesaurusColor(this, helper);
    }
    
    protected void setExpandByDefault(){
        VradiHelper.storeOnClickThesaurusExpanded(expandByDefault.isSelected());
    }
    
    protected void sort() {
        thesaurus.setTreeTableModel(helper.createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI(JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        SwingUtil.initContext(this, parentContext);
        //    setContextValue(new ModifThesaurusModel(this, helper));
            this.helper = helper;
            setContextValue(helper);
            highlighter = new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT);
            $initialize();
    }

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getThesaurusHandler().importCSV(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getThesaurusHandler().exportThesaurusCSV(this);
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChildToSelected();
    }

    public void doActionPerformed__on__createNewRoot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createNewRoot();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        deleteSelected();
    }

    public void doActionPerformed__on__edit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editSelected();
    }

    public void doActionPerformed__on__expandByDefault(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setExpandByDefault();
    }

    public void doActionPerformed__on__sortButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sort();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCreate() {
        return create;
    }

    public JButton getCreateNewRoot() {
        return createNewRoot;
    }

    public JButton getDelete() {
        return delete;
    }

    public JButton getEdit() {
        return edit;
    }

    public JCheckBox getExpandByDefault() {
        return expandByDefault;
    }

    public JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public Boolean getModified() {
        return modified;
    }

    public Boolean getSelected() {
        return selected;
    }

    public JButton getSortButton() {
        return sortButton;
    }

    public JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public Boolean getThesaurusSelected() {
        return thesaurusSelected;
    }

    public Boolean isModified() {
        return modified !=null && modified;
    }

    public Boolean isSelected() {
        return selected !=null && selected;
    }

    public Boolean isThesaurusSelected() {
        return thesaurusSelected !=null && thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(Boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void setSelected(Boolean selected) {
        Boolean oldValue = this.selected;
        this.selected = selected;
        firePropertyChange(PROPERTY_SELECTED, oldValue, selected);
    }

    public void setThesaurusSelected(Boolean thesaurusSelected) {
        Boolean oldValue = this.thesaurusSelected;
        this.thesaurusSelected = thesaurusSelected;
        firePropertyChange(PROPERTY_THESAURUS_SELECTED, oldValue, thesaurusSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(createNewRoot);
        headerPanel.add(create);
        headerPanel.add(edit);
        headerPanel.add(delete);
        headerPanel.add(expandByDefault);
        headerPanel.add($JButton0);
        headerPanel.add($JButton1);
        headerPanel.add(sortButton);
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateNewRoot() {
        $objectMap.put("createNewRoot", createNewRoot = new JButton());
        
        createNewRoot.setName("createNewRoot");
        createNewRoot.setText(_("vradi.thesaurus.createNewRoot"));
        createNewRoot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewRoot"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new JButton());
        
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createExpandByDefault() {
        $objectMap.put("expandByDefault", expandByDefault = new JCheckBox());
        
        expandByDefault.setName("expandByDefault");
        expandByDefault.setText(_("vradi.thesaurus.expendByDefault"));
        expandByDefault.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__expandByDefault"));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BoxLayout(headerPanel, BoxLayout.X_AXIS));
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAdminThesaurusUI();
        addChildrenToHeaderPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        createNewRoot.setIcon(SwingUtil.getUIManagerActionIcon("add"));
        create.setIcon(SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
        expandByDefault.setSelected(VradiHelper.isOnClickThesaurusExpanded());
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("export"));
        sortButton.setIcon(SwingUtil.getUIManagerActionIcon("sort"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminThesaurusUI", adminThesaurusUI);
        createModified();
        createSelected();
        createThesaurusSelected();
        createHeaderPanel();
        createCreateNewRoot();
        createCreate();
        createEdit();
        createDelete();
        createExpandByDefault();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminThesaurus.importThesaurusCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminThesaurus.exportThesaurusCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSortButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_HIGHLIGHTERS, true ,"highlighter") {
        
            @Override
            public void processDataBinding() {
                thesaurus.setHighlighters(highlighter);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}