/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.StatusImpl;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.nuiton.validator.bean.BeanValidatorEvent;
import org.nuiton.validator.bean.BeanValidatorListener;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AdminStatusUI extends AdminContentUI {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Tu24TQRQdm9jOk5BEhABBMmClQDBOQ5UIEoIiYpmHMEgRbpjdHeKJxrvDzN1kQ4H4BD4BehokOipEQU1Bg/gFhChoEXfGj42TRUGkmNgz95x7zvW5b76TgtHk/DZLEqrjEESb09rq5uZdb5v7cJMbXwsFkSadv1ye5JtkLOjfGyAXm3ULr3bh1bWoraKQh/vQS3UyamBPctPiHICcG0T4xlQb/eelRMW6x9oXlcX66ueP/Mvgxes8IYlCdcNopXwUKnUyVCd5EQCZxk47rCpZuIUytAi3UO+EvVuTzJg7rM2fkuekVCdFxTSSAbnw75Ydh8MnCsgEC9oibACD2DzcAFKN9Bb1W5HmbbqjWSBoLKiroX4UAlLS1f0IpRxXEchMpeFabYQCBJPiGdeLQBacfR/1CMk17aihhypTmiEvCvZwBtZuQs0uuqe1eyzkMq0pVR4wT3KknxuYbqfavdnKyT5guFKrM4/LxYPE7tYWTQMZAQGS1/kT6MHGfc0Z8I5XdDgAvREDRKHD9vtMVGpoLZLSCsZmpwYQ6dMgqtSdrP06ZY95hcE5O2ANI0nTSKaZyTVJQcd4jbNoHk7xfXzq5HfuQH4toXv9PTvz5f23d+u90A5h75OZpft2DsOkdKS4BmFbT3YSG4OQ1dtMLTXJiOESF9Yt5HyGsEb3GcVhvykLpxZObzHTQopC6euHj7OPPx8j+XUyKiMWrDNbv4E/U0vjFCIZJOr6ilM0vjuM5wmrDQMEPMGNmF4WoRQhLzPAFfJi4NcSHMN8xhj6WryRT79mGm9XeqPIobTTfy1Px1F4RIqdbm6Du8uZubFjyvA4iNIlzFrLnP0/q7qBX3DnpUyvwkaHHF8OGLCyJ8IAg4Y+LYA6A/bTouM7cySfvb5sjyv/ywCkKNleFLsoX81mKSPLH3B276HnBQAA";
    private static final Log log = LogFactory.getLog(AdminStatusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminStatusUI adminStatusUI = this;
    protected JPanel content;
    protected JButton createStatus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Status> statuses;
    protected List<Status> deleted;
    
    
    void $afterCompleteSetup() {
        createStatuses(false);
        setValide(hasNoMoreError());
        revalidate();
    }
    
    public List<Status> getStatuses(){
        return statuses;
    }
    
    public List<Status> getDeleted(){
        return deleted;
    }
    
    public void createStatuses(boolean triggeredByCancelButton) {
        int confirm = JOptionPane.DEFAULT_OPTION;
        if(triggeredByCancelButton) {
            confirm = JOptionPane.showConfirmDialog(this,
                        _("vradi.admin.cancel.message"),
                        _("vradi.admin.cancel.title"),
                        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        if(!triggeredByCancelButton || confirm == JOptionPane.YES_OPTION) {
            content.removeAll();
            statuses = getHandler().getAllStatuses();
            for (Status status : statuses){
                createStatus(status);
            }
            deleted = new ArrayList<Status>();
            setModified(false);
        }
    }
    
    protected void createNewStatus() {
        Status status = new StatusImpl();
        status.setValue(content.getComponentCount());
        status.setModifiable(true);
        statuses.add(status);
        createStatus(status);
    }
    
    protected void createStatus(Status status) {
    
        StatusEditionUI editionUI = new StatusEditionUI(this);
    
        status.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                setModified(true);
            }
        });
    
        editionUI.getValidator().addBeanValidatorListener(new BeanValidatorListener() {
    
            @Override
            public void onFieldChanged(BeanValidatorEvent event) {
                 setValide(hasNoMoreError());
            }
        });
    
        editionUI.setBean(status);
    
        content.add(editionUI);
        validate();
        setValide(hasNoMoreError());
    }
    
    protected boolean hasNoMoreError() {
        Component[] components = content.getComponents();
        for (Component c : components) {
            StatusEditionUI editionUI = (StatusEditionUI)c;
            if (editionUI.getValidator().hasErrors()) {
                return false;
            }
        }
        return true;
    }
    
    public void up(StatusEditionUI editionUI) {
         move(editionUI, -1);
    }
    
    public void down(StatusEditionUI editionUI) {
         move(editionUI, 1);
    }
    
    public void delete(StatusEditionUI editionUI) {
        remove(editionUI);
        deleted.add(editionUI.getBean());
        setModified(true);
    }
    
    public void remove(StatusEditionUI editionUI) {
    
        Status status = editionUI.getBean();
    
        // Remove in list
        statuses.remove(status);
    
        // Remove in UI
        content.remove(editionUI);
    }
    
    protected void move(StatusEditionUI editionUI, int inc) {
        Status status = editionUI.getBean();
    
        // Get index
        int index = statuses.indexOf(status) + inc;
    
        if (index >= 0 && statuses.size() > index) {
    
            if (log.isDebugEnabled()) {
                log.debug("Move " + status.getName() + " to " + index);
            }
    
            remove(editionUI);
    
            // Add in list
            statuses.add(index, status);
    
            // Add in UI
            content.add(editionUI, index);
    
            revalidate();
            
            setModified(true);
        }
    }
    
    @Override
    public void save() {
        getHandler().saveStatuses(this);
        setModified(false);
    }
    
    @Override
    public Object getBean() {
        return null;
    }
    
    @Override
    public void setBean(Object bean) {
    }
    
    @Override
    protected void postLoadBean() {
    }
    
    @Override
    public void cancel() {
        createStatuses(true);
    }
    
    @Override
    protected void clearUI() {
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminStatusUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminStatusUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminStatusUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminStatusUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminStatusUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminStatusUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminStatusUI() {
        $initialize();
    }

    public AdminStatusUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createStatus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createNewStatus(); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public JButton getCreateStatus() {
        return createStatus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0, BorderLayout.CENTER);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createCreateStatus() {
        $objectMap.put("createStatus", createStatus = new JButton());
        
        createStatus.setName("createStatus");
        createStatus.setText(_("vradi.adminStatus.createStatus"));
        createStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createStatus"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(createStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(content);
        
        // apply 2 property setters
        createStatus.setIcon(SwingUtil.getUIManagerActionIcon("add"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminStatusUI", adminStatusUI);
        deleted = new ArrayList<Status>();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.title"));
        createCreateStatus();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createContent();
        // inline creation of adminStatusUI
        setName("adminStatusUI");
        
        $completeSetup();
    }

}