/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.widget.UserListSelectorHandler;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.renderers.EntityRenderer;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AdminGroupUI extends AdminContentUI<Group> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_GROUP_USER_HANDLER = "groupUserHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table adminGroupForm;
    protected Group bean;
    protected JButton createButton;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "groupName")
    protected JTextField groupName;
    protected UserListSelectorHandler groupUserHandler;
    protected ListSelectorUI<User> groupUsers;
    protected RequestListUI requestListUI;
    protected JLabel title;
    @Validator( validatorId = "validator")
    protected SwingValidator<Group> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private JPanel $JPanel0;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(groupUsers.getCombo(), EntityRenderer.getInstance());
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        groupUserHandler = new UserListSelectorHandler(groupUsers);
        groupUsers.setHandler(groupUserHandler);
    }
    
    /**
     * Fill groups and users ListSelectorUI.
     */
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        requestListUI.setBean(bean);
        groupUserHandler.setBean(bean);
        if (bean == null) {
    
            // Clear all user
            groupUsers.init(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    
            // Clear all requests
            requestListUI.init();
    
            return;
        }
    
        Set<String> users = bean.getUser();
    
        java.util.List<User> toUserList = new java.util.ArrayList<User>();
        if (users != null){
            toUserList = VradiService.getWikittyProxy().restore(User.class, new ArrayList<String>(users));
        }
    
        java.util.List<User> toUserCombo = new java.util.ArrayList<User>(getHandler().getAllUsers());
    
        toUserCombo.removeAll(toUserList);
    
        // Sort
        Collections.sort(toUserList, VradiComparators.USER_COMPARATOR);
    
        groupUsers.init(toUserCombo, toUserList);
    
        requestListUI.setBean(bean);
        requestListUI.init();
        groupUserHandler.setBean(bean);
    }
    
    @Override
    public void save() {
        setModified(false);
    
        //Use new list to avoid empty queries after clearing
        Group bean = requestListUI.getBean();
        java.util.List<String> queries = null;
        if (bean.getQueries()!=null){
            queries = new java.util.ArrayList<String>(requestListUI.getBean().getQueries());
        }
    
        //Store queries
        bean.clearQueries();
        if (queries!=null){
            for (String query : queries) {
                bean.addQueries(query);
            }
        }
    
        //Store users
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            log.debug("Store user : " + user.getName());
            bean.addUser(user.getWikittyId());
        }
    
        //Set modified to false just before saving to avoid multiple confirmation
        setModified(false);
        Group group = getHandler().saveGroup(this, getHelper(), bean);
    
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(group);
    
        groupUsers.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        groupName.setText("");
        groupUsers.init(null, null);
    }
    
    protected String updateTitle(String name) {
        return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminGroupUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminGroupUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminGroupUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminGroupUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminGroupUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminGroupUI() {
        $initialize();
    }

    public AdminGroupUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createGroup(this);setModified(true);
    }

    public void doKeyReleased__on__groupName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(groupName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public Group getBean() {
        return bean;
    }

    public JButton getCreateButton() {
        return createButton;
    }

    public JTextField getGroupName() {
        return groupName;
    }

    public UserListSelectorHandler getGroupUserHandler() {
        return groupUserHandler;
    }

    public ListSelectorUI<User> getGroupUsers() {
        return groupUsers;
    }

    public RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public JLabel getTitle() {
        return title;
    }

    public SwingValidator<Group> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Group bean) {
        Group oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setGroupUserHandler(UserListSelectorHandler groupUserHandler) {
        UserListSelectorHandler oldValue = this.groupUserHandler;
        this.groupUserHandler = groupUserHandler;
        firePropertyChange(PROPERTY_GROUP_USER_HANDLER, oldValue, groupUserHandler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(requestListUI, new GridBagConstraints(0, 2, 2, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new Table());
        
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminGroup.createGroup"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new JTextField());
        
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUserHandler() {
        $objectMap.put("groupUserHandler", groupUserHandler = null);
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new ListSelectorUI<User>());
        
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new RequestListUI(this));
        
        requestListUI.setName("requestListUI");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        toolbar.setLayout(
          new BoxLayout(toolbar, 0)
        );
        toolbar.putClientProperty("help", 
        "ui.main.toolbar"
        );
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Group.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        createButton.setIcon(SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("group.delete"));
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeUser"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setHandler(groupUserHandler);
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        title.setHorizontalTextPosition(
          JLabel . LEFT
        );
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AdminContentUI0", $AdminContentUI0);
        createValidator();
        createBean();
        createGroupUserHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminGroupForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(
          new BoxLayout(toolbar, 0)
        );
        
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUP_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(groupName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}