/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.CardLayout2;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.admin.models.AdminTreeSelectionModel;
import org.chorem.vradi.ui.admin.renderers.AdminCellRenderer;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.widget.datatips.DataTipManager;
import org.nuiton.widget.tree.FilterTreeModel;
import org.nuiton.wikitty.entities.BusinessEntity;
import static org.nuiton.i18n.I18n._;

public class AdminNavUI extends JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTER_TREE_MODEL = "filterTreeModel";
    public static final String PROPERTY_SHOW_IMPORT_EXPORT = "showImportExport";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_IMPORT_PANEL_VISIBLE = "importPanel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(AdminNavUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminNavUI adminNavUI = this;
    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected JTextField filterField;
    protected FilterTreeModel filterTreeModel;
    protected JToolBar headerPanel;
    protected JToolBar importPanel;
    protected JTree nav;
    protected JPanel navPanel;
    protected JLabel none;
    protected Boolean showImportExport;
    protected JButton sortButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private Document $Document0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String NONE = "none";
    
    
    public AdminContentUI getCurrentContent() {
        Component visibleComponent = contentLayout.getVisibleComponent(content);
        if (visibleComponent instanceof AdminContentUI) {
            return (AdminContentUI) visibleComponent;
        }
        return null;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    protected void $afterCompleteSetup() {
    
        SwingUtil.addExpandOnClickListener(nav);
    
        // extended tooltip for hidden content
        DataTipManager.get().register(nav);
    
        VradiDataProvider dataProvider = getHelper().getDataProvider();
    
        // Register decorator
        DecoratorProvider decoratorProvider = VradiContext.get().getDecoratorProvider();
    
        // Attach renderer
        nav.setCellRenderer(new AdminCellRenderer(decoratorProvider, dataProvider));
        nav.setSelectionModel(new AdminTreeSelectionModel(this, getHandler()));
    
        // Register tree
        getHelper().setUI(nav, true);
    
        // Single selection mode
        nav.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    }
    
    /**
     * Update tree filter on filter model and expand all tree.
     */
    protected void updateFilter() {
        String filterString = filterField.getText();
        AdminNavTreeFilter treeFilter = new AdminNavTreeFilter(filterString);
        filterTreeModel.setFilter(treeFilter);
    
        // si le filtre n'est pas vide, on etend completement l'arbre
        if (StringUtils.isNotEmpty(filterString)) {
    
            // expand the tree
            SwingUtil.expandTree(nav);
        }
    }
    
    /**
     * Reset filter (clear filter text).
     */
    public void resetFilter() {
        getFilterField().setText("");
    }
    
    protected void sort() {
        resetFilter();
        nav.setModel(getHelper().createTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminNavUI(JAXXContext parentContext, AdminNavigationTreeHelper helper) {
        SwingUtil.initContext(this, parentContext);
            setContextValue(helper);
            $initialize();
    }

    public AdminNavUI() {
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminNavUI(int param0) {
        super(param0);
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminNavUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminNavUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminNavUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AdminNavUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().exportClientUsersDBCSV(this);
    }

    public void doActionPerformed__on__sortButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sort();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateFilter();
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateFilter();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public JTextField getFilterField() {
        return filterField;
    }

    public FilterTreeModel getFilterTreeModel() {
        return filterTreeModel;
    }

    public JToolBar getHeaderPanel() {
        return headerPanel;
    }

    public JToolBar getImportPanel() {
        return importPanel;
    }

    public JTree getNav() {
        return nav;
    }

    public JPanel getNavPanel() {
        return navPanel;
    }

    public JLabel getNone() {
        return none;
    }

    public Boolean getShowImportExport() {
        return showImportExport;
    }

    public JButton getSortButton() {
        return sortButton;
    }

    public Boolean isShowImportExport() {
        return showImportExport !=null && showImportExport;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void setFilterTreeModel(FilterTreeModel filterTreeModel) {
        FilterTreeModel oldValue = this.filterTreeModel;
        this.filterTreeModel = filterTreeModel;
        firePropertyChange(PROPERTY_FILTER_TREE_MODEL, oldValue, filterTreeModel);
    }

    public void setShowImportExport(Boolean showImportExport) {
        Boolean oldValue = this.showImportExport;
        this.showImportExport = showImportExport;
        firePropertyChange(PROPERTY_SHOW_IMPORT_EXPORT, oldValue, showImportExport);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminNavUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(navPanel, JSplitPane.LEFT);
        add(content, JSplitPane.RIGHT);
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JPanel0, NONE);
    }

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add(filterField, BorderLayout.CENTER);
        headerPanel.add(sortButton, BorderLayout.EAST);
    }

    protected void addChildrenToImportPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importPanel.add($JButton0);
        importPanel.add($JButton1);
    }

    protected void addChildrenToNavPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navPanel.add($JScrollPane0, BorderLayout.CENTER);
        navPanel.add(importPanel, BorderLayout.SOUTH);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterTreeModel() {
        $objectMap.put("filterTreeModel", filterTreeModel = new org.nuiton.widget.tree.FilterTreeModel(getHelper().createTreeModel()));
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new JToolBar());
        
        headerPanel.setName("headerPanel");
        headerPanel.setFloatable(false);
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setOpaque(false);
        headerPanel.setBorderPainted(false);
    }

    protected void createImportPanel() {
        $objectMap.put("importPanel", importPanel = new JToolBar());
        
        importPanel.setName("importPanel");
        importPanel.setFloatable(false);
        importPanel.setLayout(new GridLayout(1, 2));
        importPanel.setOpaque(false);
        importPanel.setBorderPainted(false);
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new JTree());
        
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(false);
    }

    protected void createNavPanel() {
        $objectMap.put("navPanel", navPanel = new JPanel());
        
        navPanel.setName("navPanel");
        navPanel.setLayout(new BorderLayout());
    }

    protected void createNone() {
        $objectMap.put("none", none = new JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("vradi.email.noSelection"));
    }

    protected void createShowImportExport() {
        $objectMap.put("showImportExport", showImportExport = false);
    }

    protected void createSortButton() {
        $objectMap.put("sortButton", sortButton = new JButton());
        
        sortButton.setName("sortButton");
        sortButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sortButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAdminNavUI();
        addChildrenToNavPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        addChildrenToHeaderPanel();
        addChildrenToImportPanel();
        addChildrenToContent();
        // inline complete setup of $JPanel0
        $JPanel0.add(none, BorderLayout.CENTER);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setDividerLocation(200);
        setResizeWeight(0.1);
        $JScrollPane0.setColumnHeaderView(headerPanel);
        nav.setModel(filterTreeModel);
        sortButton.setIcon(SwingUtil.getUIManagerActionIcon("sort"));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("import"));
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("export"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminNavUI", adminNavUI);
        createContentLayout();
        createFilterTreeModel();
        createShowImportExport();
        createNavPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createHeaderPanel();
        createFilterField();
        createSortButton();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = filterField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createImportPanel();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.admin.importCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.admin.exportCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createContent();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createNone();
        // inline creation of adminNavUI
        setName("adminNavUI");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        setDividerSize(12);
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMPORT_PANEL_VISIBLE, true ,"showImportExport") {
        
            @Override
            public void processDataBinding() {
                importPanel.setVisible(isShowImportExport());
            }
        });
    }

}