/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConfigHelper;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.models.FormMenu;
import org.nuiton.util.ApplicationConfig;
import static org.nuiton.i18n.I18n._;

public class VradiMainUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(VradiMainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected VradiMainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenu menuAdmin;
    protected JMenuItem menuAdminClient;
    protected JMenuItem menuAdminEmail;
    protected JMenuItem menuAdminForm;
    protected JMenuItem menuAdminGroup;
    protected JMenuItem menuAdminStatus;
    protected JMenuItem menuAdminThesaurus;
    protected JMenuItem menuAdminXmlStream;
    protected JMenu menuDebug;
    protected JMenuItem menuDebugStat;
    protected JMenu menuEmail;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuFileLanguage;
    protected FormMenu menuForm;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuShowOfferListUI;
    protected StatusMessagePanel status;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ApplicationConfig getConfig() {
        return getContextValue(ApplicationConfig.class);
    }
    
    public VradiMainUIHandler getHandler() {
        return getContextValue(VradiMainUIHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public boolean acceptLocale(Locale l, String expected) {
      return l != null && l.toString().equals(expected);
    }
    
    void $afterCompleteSetup() {
        //getBroker().setHandler(getHandler());
        getMenuDebug().setVisible(VradiConfigHelper.isSwingDebug(getConfig()));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiMainUI() {
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiMainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiMainUI(String param0) {
        super(param0);
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VradiMainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuAdminClient(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminClient(this);
    }

    public void doActionPerformed__on__menuAdminEmail(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showEmail(this);
    }

    public void doActionPerformed__on__menuAdminForm(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminForm(this);
    }

    public void doActionPerformed__on__menuAdminGroup(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminGroup(this);
    }

    public void doActionPerformed__on__menuAdminStatus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminStatus(this);
    }

    public void doActionPerformed__on__menuAdminThesaurus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminThesaurus(this);
    }

    public void doActionPerformed__on__menuAdminXmlStream(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAdminXmlStream(this);
    }

    public void doActionPerformed__on__menuDebugStat(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showStat(this);
    }

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(mainFrame);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite(this);
    }

    public void doActionPerformed__on__menuShowOfferListUI(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showOfferListUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAdmin() {
        return menuAdmin;
    }

    public JMenuItem getMenuAdminClient() {
        return menuAdminClient;
    }

    public JMenuItem getMenuAdminEmail() {
        return menuAdminEmail;
    }

    public JMenuItem getMenuAdminForm() {
        return menuAdminForm;
    }

    public JMenuItem getMenuAdminGroup() {
        return menuAdminGroup;
    }

    public JMenuItem getMenuAdminStatus() {
        return menuAdminStatus;
    }

    public JMenuItem getMenuAdminThesaurus() {
        return menuAdminThesaurus;
    }

    public JMenuItem getMenuAdminXmlStream() {
        return menuAdminXmlStream;
    }

    public JMenu getMenuDebug() {
        return menuDebug;
    }

    public JMenuItem getMenuDebugStat() {
        return menuDebugStat;
    }

    public JMenu getMenuEmail() {
        return menuEmail;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public FormMenu getMenuForm() {
        return menuForm;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuShowOfferListUI() {
        return menuShowOfferListUI;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(content);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuForm);
        menu.add(menuAdmin);
        menu.add(menuEmail);
        menu.add(menuHelp);
        menu.add(menuDebug);
    }

    protected void addChildrenToMenuAdmin() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdmin.add(menuAdminClient);
        menuAdmin.add(menuAdminGroup);
        menuAdmin.add(menuAdminForm);
        menuAdmin.add(menuAdminXmlStream);
        menuAdmin.add(menuAdminStatus);
        menuAdmin.add(menuAdminThesaurus);
    }

    protected void addChildrenToMenuDebug() {
        if (!allComponentsCreated) {
            return;
        }
        menuDebug.add(menuDebugStat);
    }

    protected void addChildrenToMenuEmail() {
        if (!allComponentsCreated) {
            return;
        }
        menuEmail.add(menuAdminEmail);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuShowOfferListUI);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", 
        "ui.main.menu"
        );
    }

    protected void createMenuAdmin() {
        $objectMap.put("menuAdmin", menuAdmin = new JMenu());
        
        menuAdmin.setName("menuAdmin");
        menuAdmin.setText(_("vradi.menu.admin"));
        menuAdmin.setMnemonic(65);
        menuAdmin.putClientProperty("help", 
        "ui.main.menu.file"
        );
    }

    protected void createMenuAdminClient() {
        $objectMap.put("menuAdminClient", menuAdminClient = new JMenuItem());
        
        menuAdminClient.setName("menuAdminClient");
        menuAdminClient.setText(_("vradi.menu.client"));
        menuAdminClient.setMnemonic(67);
        menuAdminClient.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminClient"));
        menuAdminClient.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminEmail() {
        $objectMap.put("menuAdminEmail", menuAdminEmail = new JMenuItem());
        
        menuAdminEmail.setName("menuAdminEmail");
        menuAdminEmail.setText(_("vradi.menu.email.admin"));
        menuAdminEmail.setMnemonic(67);
        menuAdminEmail.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminEmail"));
        menuAdminEmail.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminForm() {
        $objectMap.put("menuAdminForm", menuAdminForm = new JMenuItem());
        
        menuAdminForm.setName("menuAdminForm");
        menuAdminForm.setText(_("vradi.menu.formType"));
        menuAdminForm.setMnemonic(70);
        menuAdminForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminForm"));
        menuAdminForm.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminGroup() {
        $objectMap.put("menuAdminGroup", menuAdminGroup = new JMenuItem());
        
        menuAdminGroup.setName("menuAdminGroup");
        menuAdminGroup.setText(_("vradi.menu.group"));
        menuAdminGroup.setMnemonic(71);
        menuAdminGroup.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminGroup"));
        menuAdminGroup.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminStatus() {
        $objectMap.put("menuAdminStatus", menuAdminStatus = new JMenuItem());
        
        menuAdminStatus.setName("menuAdminStatus");
        menuAdminStatus.setText(_("vradi.menu.status"));
        menuAdminStatus.setMnemonic(83);
        menuAdminStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminStatus"));
        menuAdminStatus.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminThesaurus() {
        $objectMap.put("menuAdminThesaurus", menuAdminThesaurus = new JMenuItem());
        
        menuAdminThesaurus.setName("menuAdminThesaurus");
        menuAdminThesaurus.setText(_("vradi.menu.thesaurus"));
        menuAdminThesaurus.setMnemonic(84);
        menuAdminThesaurus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminThesaurus"));
        menuAdminThesaurus.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuAdminXmlStream() {
        $objectMap.put("menuAdminXmlStream", menuAdminXmlStream = new JMenuItem());
        
        menuAdminXmlStream.setName("menuAdminXmlStream");
        menuAdminXmlStream.setText(_("vradi.menu.xmlStream"));
        menuAdminXmlStream.setMnemonic(88);
        menuAdminXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminXmlStream"));
        menuAdminXmlStream.putClientProperty("help", 
        "ui.main.menu.action"
        );
    }

    protected void createMenuDebug() {
        $objectMap.put("menuDebug", menuDebug = new JMenu());
        
        menuDebug.setName("menuDebug");
        menuDebug.setText(_("vradi.menu.debug"));
    }

    protected void createMenuDebugStat() {
        $objectMap.put("menuDebugStat", menuDebugStat = new JMenuItem());
        
        menuDebugStat.setName("menuDebugStat");
        menuDebugStat.setText(_("vradi.action.stat"));
        menuDebugStat.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuDebugStat"));
    }

    protected void createMenuEmail() {
        $objectMap.put("menuEmail", menuEmail = new JMenu());
        
        menuEmail.setName("menuEmail");
        menuEmail.setText(_("vradi.menu.email"));
        menuEmail.setMnemonic(69);
        menuEmail.putClientProperty("help", 
        "ui.main.menu.file"
        );
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("vradi.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", 
        "ui.main.menu.file"
        );
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("vradi.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("vradi.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", 
        "ui.main.menu.file.configuration"
        );
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("vradi.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("vradi.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", 
        "ui.main.menu.file.exit"
        );
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("vradi.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("vradi.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", 
        "ui.main.menu.file.locale"
        );
    }

    protected void createMenuForm() {
        $objectMap.put("menuForm", menuForm = new FormMenu(getHandler()));
        
        menuForm.setName("menuForm");
        menuForm.setText(_("vradi.menu.form"));
        menuForm.setMnemonic(77);
        menuForm.putClientProperty("help", 
        "ui.main.menu.form"
        );
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("vradi.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", 
        "ui.main.menu.help"
        );
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("vradi.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("vradi.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", 
        "ui.main.menu.help.about"
        );
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("vradi.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("vradi.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", 
        "ui.main.menu.help.help"
        );
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("vradi.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("vradi.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", 
        "ui.main.menu.help.site"
        );
    }

    protected void createMenuShowOfferListUI() {
        $objectMap.put("menuShowOfferListUI", menuShowOfferListUI = new JMenuItem());
        
        menuShowOfferListUI.setName("menuShowOfferListUI");
        menuShowOfferListUI.setText(_("vradi.menu.file.offerList"));
        menuShowOfferListUI.setMnemonic(79);
        menuShowOfferListUI.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowOfferListUI"));
        menuShowOfferListUI.putClientProperty("help", 
        "ui.main.menu.file.offerList"
        );
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
        status.putClientProperty("help", "ui.main.statusBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuAdmin();
        addChildrenToMenuEmail();
        addChildrenToMenuHelp();
        addChildrenToMenuDebug();
        
        // apply 7 property setters
        setUndecorated(VradiConfigHelper.isFullScreen(getConfig()));
        menuFileConfiguration.setIcon(SwingUtil.getUIManagerActionIcon("config"));
        menuFileLanguage.setIcon(SwingUtil.getUIManagerActionIcon("translate"));
        menuFileExit.setIcon(SwingUtil.getUIManagerActionIcon("exit"));
        menuHelpHelp.setIcon(SwingUtil.getUIManagerActionIcon("help"));
        menuHelpSite.setIcon(SwingUtil.getUIManagerActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.getUIManagerActionIcon("about"));
        // late initializer
        mainFrame.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createMenu();
        createMenuFile();
        createMenuShowOfferListUI();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileExit();
        createMenuForm();
        createMenuAdmin();
        createMenuAdminClient();
        createMenuAdminGroup();
        createMenuAdminForm();
        createMenuAdminXmlStream();
        createMenuAdminStatus();
        createMenuAdminThesaurus();
        createMenuEmail();
        createMenuAdminEmail();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuDebug();
        createMenuDebugStat();
        createContent();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        setTitle(_("vradi.title.welcome"));
        setDefaultCloseOperation(0);
        
        $completeSetup();
    }

}