/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    protected int mergeFactor = 10;
    protected long minMergeSize;
    protected long maxMergeSize;
    protected long maxMergeSizeForOptimize = Long.MAX_VALUE;
    protected int maxMergeDocs = Integer.MAX_VALUE;
    protected double noCFSRatio = 0.1;
    protected boolean calibrateSizeByDeletes = true;
    protected boolean useCompoundFile = true;

    protected boolean verbose() {
        IndexWriter w = (IndexWriter)this.writer.get();
        return w != null && w.verbose();
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public void setNoCFSRatio(double noCFSRatio) {
        if (noCFSRatio < 0.0 || noCFSRatio > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + noCFSRatio);
        }
        this.noCFSRatio = noCFSRatio;
    }

    protected void message(String message) {
        if (this.verbose()) {
            ((IndexWriter)this.writer.get()).message("LMP: " + message);
        }
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    @Override
    public boolean useCompoundFile(SegmentInfos infos, SegmentInfo mergedInfo) throws IOException {
        boolean doCFS;
        if (!this.useCompoundFile) {
            doCFS = false;
        } else if (this.noCFSRatio == 1.0) {
            doCFS = true;
        } else {
            long totalSize = 0L;
            for (SegmentInfo info : infos) {
                totalSize += this.size(info);
            }
            doCFS = (double)this.size(mergedInfo) <= this.noCFSRatio * (double)totalSize;
        }
        return doCFS;
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setCalibrateSizeByDeletes(boolean calibrateSizeByDeletes) {
        this.calibrateSizeByDeletes = calibrateSizeByDeletes;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    @Override
    public void close() {
    }

    protected abstract long size(SegmentInfo var1) throws IOException;

    protected long sizeDocs(SegmentInfo info) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int delCount = ((IndexWriter)this.writer.get()).numDeletedDocs(info);
            assert (delCount <= info.docCount);
            return (long)info.docCount - (long)delCount;
        }
        return info.docCount;
    }

    protected long sizeBytes(SegmentInfo info) throws IOException {
        long byteSize = info.sizeInBytes(true);
        if (this.calibrateSizeByDeletes) {
            int delCount = ((IndexWriter)this.writer.get()).numDeletedDocs(info);
            double delRatio = info.docCount <= 0 ? 0.0f : (float)delCount / (float)info.docCount;
            assert (delRatio <= 1.0);
            return info.docCount <= 0 ? byteSize : (long)((double)byteSize * (1.0 - delRatio));
        }
        return byteSize;
    }

    protected boolean isOptimized(SegmentInfos infos, int maxNumSegments, Set<SegmentInfo> segmentsToOptimize) throws IOException {
        int numSegments = infos.size();
        int numToOptimize = 0;
        SegmentInfo optimizeInfo = null;
        for (int i = 0; i < numSegments && numToOptimize <= maxNumSegments; ++i) {
            SegmentInfo info = infos.info(i);
            if (!segmentsToOptimize.contains(info)) continue;
            ++numToOptimize;
            optimizeInfo = info;
        }
        return numToOptimize <= maxNumSegments && (numToOptimize != 1 || this.isOptimized(optimizeInfo));
    }

    protected boolean isOptimized(SegmentInfo info) throws IOException {
        IndexWriter w = (IndexWriter)this.writer.get();
        assert (w != null);
        boolean hasDeletions = w.numDeletedDocs(info) > 0;
        return !hasDeletions && !info.hasSeparateNorms() && info.dir == w.getDirectory() && (info.getUseCompoundFile() == this.useCompoundFile || this.noCFSRatio < 1.0);
    }

    private MergePolicy.MergeSpecification findMergesForOptimizeSizeLimit(SegmentInfos infos, int maxNumSegments, int last) throws IOException {
        int start;
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        for (start = last - 1; start >= 0; --start) {
            SegmentInfo info = infos.info(start);
            if (this.size(info) > this.maxMergeSizeForOptimize || this.sizeDocs(info) > (long)this.maxMergeDocs) {
                if (this.verbose()) {
                    this.message("optimize: skip segment=" + info + ": size is > maxMergeSize (" + this.maxMergeSizeForOptimize + ") or sizeDocs is > maxMergeDocs (" + this.maxMergeDocs + ")");
                }
                if (last - start - 1 > 1 || start != last - 1 && !this.isOptimized(infos.info(start + 1))) {
                    spec.add(new MergePolicy.OneMerge(infos.range(start + 1, last)));
                }
                last = start;
                continue;
            }
            if (last - start != this.mergeFactor) continue;
            spec.add(new MergePolicy.OneMerge(infos.range(start, last)));
            last = start;
        }
        if (!(last <= 0 || ++start + 1 >= last && this.isOptimized(infos.info(start)))) {
            spec.add(new MergePolicy.OneMerge(infos.range(start, last)));
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    private MergePolicy.MergeSpecification findMergesForOptimizeMaxNumSegments(SegmentInfos infos, int maxNumSegments, int last) throws IOException {
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        while (last - maxNumSegments + 1 >= this.mergeFactor) {
            spec.add(new MergePolicy.OneMerge(infos.range(last - this.mergeFactor, last)));
            last -= this.mergeFactor;
        }
        if (0 == spec.merges.size()) {
            if (maxNumSegments == 1) {
                if (last > 1 || !this.isOptimized(infos.info(0))) {
                    spec.add(new MergePolicy.OneMerge(infos.range(0, last)));
                }
            } else if (last > maxNumSegments) {
                int finalMergeSize = last - maxNumSegments + 1;
                long bestSize = 0L;
                int bestStart = 0;
                for (int i = 0; i < last - finalMergeSize + 1; ++i) {
                    long sumSize = 0L;
                    for (int j = 0; j < finalMergeSize; ++j) {
                        sumSize += this.size(infos.info(j + i));
                    }
                    if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1)) || sumSize >= bestSize)) continue;
                    bestStart = i;
                    bestSize = sumSize;
                }
                spec.add(new MergePolicy.OneMerge(infos.range(bestStart, bestStart + finalMergeSize)));
            }
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, int maxNumSegments, Set<SegmentInfo> segmentsToOptimize) throws IOException {
        assert (maxNumSegments > 0);
        if (this.isOptimized(infos, maxNumSegments, segmentsToOptimize)) {
            return null;
        }
        int last = infos.size();
        while (last > 0) {
            SegmentInfo info;
            if (!segmentsToOptimize.contains(info = infos.info(--last))) continue;
            ++last;
            break;
        }
        if (last == 0) {
            return null;
        }
        if (maxNumSegments == 1 && last == 1 && this.isOptimized(infos.info(0))) {
            return null;
        }
        boolean anyTooLarge = false;
        for (int i = 0; i < last; ++i) {
            SegmentInfo info = infos.info(i);
            if (this.size(info) <= this.maxMergeSizeForOptimize && this.sizeDocs(info) <= (long)this.maxMergeDocs) continue;
            anyTooLarge = true;
            break;
        }
        if (anyTooLarge) {
            return this.findMergesForOptimizeSizeLimit(infos, maxNumSegments, last);
        }
        return this.findMergesForOptimizeMaxNumSegments(infos, maxNumSegments, last);
    }

    @Override
    public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        int numSegments = segmentInfos.size();
        if (this.verbose()) {
            this.message("findMergesToExpungeDeletes: " + numSegments + " segments");
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        int firstSegmentWithDeletions = -1;
        IndexWriter w = (IndexWriter)this.writer.get();
        assert (w != null);
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = segmentInfos.info(i);
            int delCount = w.numDeletedDocs(info);
            if (delCount > 0) {
                if (this.verbose()) {
                    this.message("  segment " + info.name + " has deletions");
                }
                if (firstSegmentWithDeletions == -1) {
                    firstSegmentWithDeletions = i;
                    continue;
                }
                if (i - firstSegmentWithDeletions != this.mergeFactor) continue;
                if (this.verbose()) {
                    this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive");
                }
                spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, i)));
                firstSegmentWithDeletions = i;
                continue;
            }
            if (firstSegmentWithDeletions == -1) continue;
            if (this.verbose()) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive");
            }
            spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, i)));
            firstSegmentWithDeletions = -1;
        }
        if (firstSegmentWithDeletions != -1) {
            if (this.verbose()) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (numSegments - 1) + " inclusive");
            }
            spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, numSegments)));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
        int numSegments = infos.size();
        if (this.verbose()) {
            this.message("findMerges: " + numSegments + " segments");
        }
        float[] levels = new float[numSegments];
        float norm = (float)Math.log(this.mergeFactor);
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = infos.info(i);
            long size = this.size(info);
            if (size < 1L) {
                size = 1L;
            }
            levels[i] = (float)Math.log(size) / norm;
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int start = 0;
        while (start < numSegments) {
            int upto;
            float levelBottom;
            float maxLevel = levels[start];
            for (int i = 1 + start; i < numSegments; ++i) {
                float level = levels[i];
                if (!(level > maxLevel)) continue;
                maxLevel = level;
            }
            if (maxLevel <= levelFloor) {
                levelBottom = -1.0f;
            } else {
                levelBottom = (float)((double)maxLevel - 0.75);
                if (levelBottom < levelFloor && maxLevel >= levelFloor) {
                    levelBottom = levelFloor;
                }
            }
            for (upto = numSegments - 1; upto >= start && !(levels[upto] >= levelBottom); --upto) {
            }
            if (this.verbose()) {
                this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments");
            }
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyTooLarge = false;
                for (int i = start; i < end; ++i) {
                    SegmentInfo info = infos.info(i);
                    anyTooLarge |= this.size(info) >= this.maxMergeSize || this.sizeDocs(info) >= (long)this.maxMergeDocs;
                }
                if (!anyTooLarge) {
                    if (spec == null) {
                        spec = new MergePolicy.MergeSpecification();
                    }
                    if (this.verbose()) {
                        this.message("    " + start + " to " + end + ": add this merge");
                    }
                    spec.add(new MergePolicy.OneMerge(infos.range(start, end)));
                } else if (this.verbose()) {
                    this.message("    " + start + " to " + end + ": contains segment over maxMergeSize or maxMergeDocs; skipping");
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("minMergeSize=").append(this.minMergeSize).append(", ");
        sb.append("mergeFactor=").append(this.mergeFactor).append(", ");
        sb.append("maxMergeSize=").append(this.maxMergeSize).append(", ");
        sb.append("maxMergeSizeForOptimize=").append(this.maxMergeSizeForOptimize).append(", ");
        sb.append("calibrateSizeByDeletes=").append(this.calibrateSizeByDeletes).append(", ");
        sb.append("maxMergeDocs=").append(this.maxMergeDocs).append(", ");
        sb.append("useCompoundFile=").append(this.useCompoundFile);
        sb.append("]");
        return sb.toString();
    }
}

