/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.managers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.services.VradiException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class FormTypeManager {
    private static final Log log = LogFactory.getLog(FormTypeManager.class);
    protected ApplicationConfig config;
    protected WikittyProxy wikittyProxy;

    public FormTypeManager(ApplicationConfig config, WikittyProxy wikittyProxy) {
        this.config = config;
        this.wikittyProxy = wikittyProxy;
    }

    public WikittyExtension getFormType(String name) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormType(" + name + ")"));
        }
        try {
            WikittyExtension wikittyExtension = this.wikittyProxy.restoreExtensionLastVersion(name);
            return wikittyExtension;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get form type", (Throwable)eee);
            }
            throw new VradiException("Can't get form type", eee);
        }
    }

    public Map<String, FieldType> getFormTypeFields(String name) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormTypeFields(" + name + ")"));
        }
        try {
            WikittyExtension extension = this.getFormType(name);
            HashMap<String, FieldType> fields = new HashMap<String, FieldType>();
            for (String fieldName : extension.getFieldNames()) {
                fields.put(fieldName, extension.getFieldType(fieldName));
            }
            return fields;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get form type fields", (Throwable)eee);
            }
            throw new VradiException("Can't get form type fields", eee);
        }
    }

    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + name + ", fields, requires, tagValues)"));
        }
        if (name != null) {
            try {
                WikittyExtension lastVersion = this.getFormType(name);
                String newVersion = null;
                newVersion = lastVersion != null ? WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()) : "0.0";
                WikittyExtension extension = new WikittyExtension(name, newVersion, requires, new LinkedHashMap<String, FieldType>(fields));
                if (tagValues != null) {
                    for (Map.Entry<String, String> entry : tagValues.entrySet()) {
                        extension.addTagValue(entry.getKey(), entry.getValue());
                    }
                }
                List<WikittyExtension> extensions = Arrays.asList(extension);
                this.wikittyProxy.storeExtension(extensions);
                log.info((Object)String.format("FormType named %s saved with id: %s and version: %s", name, extension.getId(), newVersion));
                return extension;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't update form type", (Throwable)eee);
                }
                throw new VradiException("Can't update form type", eee);
            }
        }
        return null;
    }

    public WikittyExtension updateFormType(WikittyExtension extension, String templateName) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + extension.toDefinition() + ")"));
        }
        try {
            if (templateName != null) {
                extension.addTagValue(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.getValue(), templateName);
            }
            LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
            for (String fieldName : extension.getFieldNames()) {
                FieldType fieldType = extension.getFieldType(fieldName);
                fields.put(fieldName, fieldType);
            }
            WikittyExtension updated = this.updateFormType(extension.getName(), fields, extension.getRequires(), extension.getTagValues());
            return updated;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't update form type", (Throwable)eee);
            }
            throw new VradiException("Can't update form type", eee);
        }
    }

    public File getTemplate(String extensionName, String templateName) {
        if (templateName == null) {
            return null;
        }
        File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(this.config);
        File template = new File(new File(templatesDir, extensionName), templateName);
        return template.exists() ? template : null;
    }

    public Collection<String> getTemplateFilenames(WikittyExtension extension) {
        ArrayList<String> filesNames = null;
        File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(this.config);
        File templateDir = new File(templatesDir, extension.getName());
        File[] result = templateDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && !file.getName().endsWith(".xml");
            }
        });
        if (result != null) {
            filesNames = new ArrayList<String>();
            for (File file : result) {
                String fileName = file.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Template for formType '" + extension.getName() + "' found : " + fileName));
                }
                filesNames.add(fileName);
            }
        }
        return filesNames;
    }

    public Map<String, String> getAssociatedFields(String extensionName, String templateName) throws VradiException {
        File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(this.config);
        File extensionTemplateDir = new File(templatesDir, extensionName);
        File templateFieldsFile = new File(extensionTemplateDir, templateName + ".xml");
        if (!templateFieldsFile.isFile()) {
            return null;
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        try {
            SAXBuilder sxb = new SAXBuilder();
            Document document = sxb.build(templateFieldsFile);
            Element root = document.getRootElement();
            for (Object child : root.getChildren(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.getValue())) {
                Element field = (Element)child;
                String templateField = field.getAttributeValue(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.getValue());
                String extensionField = field.getAttributeValue(VradiConstants.FormTypeTemplateEnum.FIELD_EXTENSION_ATTRIBUTE.getValue());
                fieldMap.put(templateField, extensionField);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Impossible d'associer les champs", (Throwable)eee);
            }
            throw new VradiException("Can't read association file", eee);
        }
        return fieldMap;
    }

    public void setAssociatedFields(String extensionName, String templateName, Map<String, String> fieldMap) throws VradiException {
        File templatesDir = VradiServiceConfigurationHelper.getTemplatesDir(this.config);
        File templateDir = new File(templatesDir, extensionName);
        templateDir.mkdirs();
        File targetFile = new File(templateDir, templateName + ".xml");
        try {
            Element root;
            Document document;
            if (targetFile.isFile()) {
                SAXBuilder sxb = new SAXBuilder();
                document = sxb.build(targetFile);
            } else {
                root = new Element(VradiConstants.FormTypeTemplateEnum.FIELDS_ELEMENT.getValue());
                document = new Document(root);
            }
            root = document.getRootElement();
            root.removeChildren(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.getValue());
            for (Map.Entry<String, String> field : fieldMap.entrySet()) {
                Element child = new Element(VradiConstants.FormTypeTemplateEnum.FIELD_ELEMENT.getValue());
                child.setAttribute(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.getValue(), field.getKey());
                if (field.getValue() != null) {
                    child.setAttribute(VradiConstants.FormTypeTemplateEnum.FIELD_EXTENSION_ATTRIBUTE.getValue(), field.getValue());
                }
                root.addContent((Content)child);
            }
            XMLOutputter xmlOuputter = new XMLOutputter();
            FileWriter writer = new FileWriter(targetFile);
            xmlOuputter.output(document, (Writer)writer);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save extension fields template association", (Throwable)eee);
            }
            throw new VradiException("Can't save extension fields template association", eee);
        }
    }

    public boolean isFormTypeExists(String formTypeName) throws VradiException {
        boolean result = false;
        WikittyExtension extension = this.wikittyProxy.restoreExtensionLastVersion(formTypeName);
        if (extension != null) {
            result = true;
        }
        return result;
    }

    public WikittyExtension createFormType(String formTypeName) throws VradiException {
        WikittyExtension formType;
        if (formTypeName == null) {
            throw new VradiException("Can't create new form type with null name !");
        }
        if (!formTypeName.matches("\\w+")) {
            throw new VradiException("Form name contains invalid characters : " + formTypeName);
        }
        if (this.isFormTypeExists(formTypeName)) {
            throw new VradiException("Form name \"" + formTypeName + "\" already exists !");
        }
        try {
            formType = new WikittyExtension(formTypeName, "0.0", "Form", new LinkedHashMap());
            this.wikittyProxy.storeExtension(formType);
        }
        catch (WikittyException ex) {
            throw new VradiException("Can't create form type", ex);
        }
        return formType;
    }

    public String getFormTypeTemplateName(WikittyExtension extension) {
        String result;
        String string = result = extension == null ? null : extension.getTagValue(VradiConstants.FormTypeTemplateEnum.FIELD_TEMPLATE_ATTRIBUTE.getValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template name for form type '" + extension.getName() + "' is : " + result));
        }
        return result;
    }
}

