/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiServiceConfiguration;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.beans.XmlStreamImportResult;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.QueryMaker;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.VradiUser;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.FileService;
import org.chorem.vradi.services.FileServiceImpl;
import org.chorem.vradi.services.ServiceFactory;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.services.managers.BindingManager;
import org.chorem.vradi.services.managers.ClientManager;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.FormTypeManager;
import org.chorem.vradi.services.managers.MailingManager;
import org.chorem.vradi.services.managers.SearchManager;
import org.chorem.vradi.services.managers.TemplateManager;
import org.chorem.vradi.services.managers.ThesaurusManager;
import org.chorem.vradi.services.tasks.TasksManager;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyListener;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected ApplicationConfig config;
    protected WikittyProxy wikittyProxy;
    protected WikittyImportExportService importExportService;
    protected ThesaurusManager thesaurusManager;
    protected BindingManager bindingManager;
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected ClientManager clientManager;
    protected SearchManager searchManager;
    protected MailingManager mailingManager;
    protected TasksManager tasksManager;
    protected FileService fileService;

    public VradiStorageServiceImpl() {
        this(VradiServiceConfiguration.getConfig(new String[0]), ServiceFactory.getWikittyProxy());
    }

    protected VradiStorageServiceImpl(ApplicationConfig config, WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
        this.config = config;
        this.thesaurusManager = new ThesaurusManager(wikittyProxy);
        this.clientManager = new ClientManager(config, wikittyProxy);
        this.formTypeManager = new FormTypeManager(config, wikittyProxy);
        this.mailingManager = new MailingManager(config, wikittyProxy, this.formTypeManager);
        this.fileService = new FileServiceImpl(config);
        this.searchManager = new SearchManager(wikittyProxy, this.thesaurusManager);
        this.formManager = new FormManager(config, wikittyProxy, this.thesaurusManager, this.searchManager);
        this.bindingManager = new BindingManager(config, wikittyProxy, this.formTypeManager, this.formManager);
        this.tasksManager = new TasksManager(config, wikittyProxy, this.thesaurusManager, this.formManager, this.mailingManager, this.bindingManager);
        this.tasksManager.initTasks();
        wikittyProxy.getWikittyService().addWikittyServiceListener((WikittyListener)this.tasksManager, WikittyService.ServiceListenerType.ALL);
    }

    protected WikittyImportExportService getImportExportService() {
        if (this.importExportService == null) {
            ApplicationConfig config = VradiServiceConfiguration.getConfig(new String[0]);
            this.importExportService = new WikittyImportExportService(config, this.wikittyProxy.getSecurityToken(), this.wikittyProxy.getWikittyService());
        }
        return this.importExportService;
    }

    @Override
    public List<Status> createDefaultStatuses() throws VradiException {
        return this.formManager.createDefaultStatuses();
    }

    @Override
    public Session createNewSession() throws VradiException {
        return this.formManager.createNewSession();
    }

    @Override
    public Session bindForms(Session session) throws VradiException {
        return this.formManager.bindForms(session);
    }

    @Override
    public List<Sending> createAllSending(String sessionId, Group group, List<String> formsIdsToBind) throws VradiException {
        return this.formManager.createAllSending(sessionId, group, formsIdsToBind);
    }

    @Override
    public Sending createSending(String sessionId, User user, List<String> formsIdsToBind) throws VradiException {
        return this.formManager.createUserSending(sessionId, user, formsIdsToBind);
    }

    @Override
    public List<Sending> removeAllSending(String sessionId, List<String> formsIds, Group group) throws VradiException {
        return this.formManager.removeAllSending(sessionId, formsIds, group);
    }

    @Override
    public Sending removeSending(String sessionId, List<String> formsIds, User user) throws VradiException {
        return this.formManager.removeSending(sessionId, formsIds, user);
    }

    @Override
    public XmlStreamImportResult importFormsFromWebHarvestStream(WebHarvestStream webHarvestStream) throws VradiException {
        return this.bindingManager.importFormsFromWebHarvestStream(webHarvestStream);
    }

    @Override
    public XmlStreamImportResult importFormsFromXmlStream(XmlStream xmlStream) throws VradiException {
        return this.bindingManager.importFormsFromXmlStream(xmlStream);
    }

    @Override
    public VradiUser createUser(VradiUser user) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateVradiUser(" + user.getLogin() + ")"));
        }
        Search search = Search.query().eq("login", user.getLogin());
        Criteria criteria = search.criteria();
        criteria.setEndIndex(1);
        PagedResult users = this.wikittyProxy.findAllByCriteria(VradiUser.class, criteria);
        if (users.getNumFound() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + user.getLogin() + " already exists"));
            }
            return null;
        }
        return (VradiUser)this.wikittyProxy.store((BusinessEntity)user);
    }

    @Override
    public VradiUser loginUser(String login, String mp5password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("logVradiUser(" + login + ", " + mp5password + ")"));
        }
        Criteria criteria = Search.query().eq("WikittyUser.login", login).eq("WikittyUser.password", mp5password).criteria();
        criteria.setEndIndex(1);
        VradiUser vradiUser = (VradiUser)this.wikittyProxy.findByCriteria(VradiUser.class, criteria);
        return vradiUser;
    }

    @Override
    public void importAsCSV(String uri) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing data as CSV with url = " + uri));
        }
        try {
            WikittyImportExportService ieService = this.getImportExportService();
            ieService.syncImportFromUri(WikittyImportExportService.FORMAT.CSV, uri);
        }
        catch (WikittyException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import data", (Throwable)eee);
            }
            throw new VradiException("Can't import data", eee);
        }
    }

    @Override
    public String exportAsCSV(Criteria criteria) throws VradiException {
        String result;
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exporting data as CSV with criteria " + criteria));
            }
            result = null;
            try {
                WikittyImportExportService ieService = this.getImportExportService();
                result = ieService.syncExportAllByCriteria(WikittyImportExportService.FORMAT.CSV, criteria);
            }
            catch (WikittyException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't export data", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public String exportThesaurusAsCSV() throws VradiException {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "WikittyTreeNode");
        Criteria criteria = search.criteria();
        return this.exportAsCSV(criteria);
    }

    @Override
    public void reindexData() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"reindexData()");
        }
        this.wikittyProxy.getWikittyService().syncSearchEngine(null);
    }

    @Override
    public void archiveQueries(QueryMaker queryMaker) throws VradiException {
        this.clientManager.archiveQueries(queryMaker);
    }

    @Override
    public void setAssociatedFields(String extensionName, String templateName, Map<String, String> fieldMap) throws VradiException {
        this.formTypeManager.setAssociatedFields(extensionName, templateName, fieldMap);
    }

    @Override
    public String generatePDF(String formId, boolean force) throws VradiException {
        return this.mailingManager.generatePDF(formId, force);
    }

    @Override
    public Collection<String> getTemplateFilenames(WikittyExtension extension) {
        return this.formTypeManager.getTemplateFilenames(extension);
    }

    @Override
    public Map<String, String> getAssociatedFields(String extensionName, String templateName) throws VradiException {
        return this.formTypeManager.getAssociatedFields(extensionName, templateName);
    }

    @Override
    public List<String> getDocumentFields(WikittyExtension extension, String templateName) throws VradiException {
        List<String> documentsFields;
        try {
            File templateDir = VradiServiceConfigurationHelper.getTemplatesDir(this.config);
            File extensionTemplate = new File(templateDir, extension.getName());
            File templateFile = new File(extensionTemplate, templateName);
            TemplateManager templateManager = new TemplateManager(this.config, templateFile);
            documentsFields = templateManager.getDocumentFields();
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get documents fields", (Throwable)ex);
            }
            throw ex;
        }
        return documentsFields;
    }

    @Override
    public String sendMessages(String sessionId) throws VradiException {
        return this.mailingManager.sendMessages(sessionId);
    }

    @Override
    public String sendMessage(String sendingId, String sessionParagraph, Collection<File> filesToAttach) throws VradiException {
        return this.sendMessage(sendingId, sessionParagraph, null, false, filesToAttach);
    }

    @Override
    public String sendMessage(String sendingId, String sessionParagraph, String email, Collection<File> filesToAttach) throws VradiException {
        return this.sendMessage(sendingId, sessionParagraph, email, true, filesToAttach);
    }

    public String sendMessage(String sendingId, String sessionParagraph, String email, boolean reSend, Collection<File> filesToAttach) throws VradiException {
        return this.mailingManager.sendMessage(sendingId, sessionParagraph, email, reSend, filesToAttach);
    }

    @Override
    public void receiveMessages() throws VradiException {
        this.mailingManager.receiveMails();
    }

    @Override
    public Session stopSentMail(Session session) throws VradiException {
        session.setStatus(VradiConstants.SessionStatus.STOPPED.getValue());
        session = (Session)this.wikittyProxy.store((BusinessEntity)session);
        return session;
    }

    @Override
    public void generatePDFForSession(String sessionId) throws VradiException {
        this.mailingManager.generatePDFForSession(sessionId);
    }

    public List<Group> getGroupsForUser(String userId) throws VradiException {
        return this.clientManager.getGroupsForUser(userId);
    }

    @Override
    public String exportClientDB() throws VradiException {
        Search restriction = Search.query().or();
        restriction.eq(Element.ELT_EXTENSION, "Group");
        restriction.eq(Element.ELT_EXTENSION, "Client");
        restriction.eq(Element.ELT_EXTENSION, "User");
        Criteria criteria = restriction.criteria();
        String vscContent = this.exportAsCSV(criteria);
        return vscContent;
    }

    @Override
    public void deleteSession(String sessionId) throws VradiException {
        this.formManager.deleteSession(sessionId);
    }

    @Override
    public boolean checkTemplateExist(String extensionName) throws VradiException {
        boolean fileExists;
        try {
            WikittyExtension extension = this.formTypeManager.getFormType(extensionName);
            String templateName = this.formTypeManager.getFormTypeTemplateName(extension);
            if (templateName == null) {
                return false;
            }
            File template = this.formTypeManager.getTemplate(extensionName, templateName);
            fileExists = template != null && template.exists();
        }
        catch (Exception eee) {
            throw new VradiException("Can't check if template existe : ", eee);
        }
        return fileExists;
    }

    @Override
    public boolean removeFormsFromSession(String sessionId, List<String> formsIds) throws VradiException {
        return this.formManager.removeFormsFromSession(sessionId, formsIds);
    }

    @Override
    public Sending revertDeletion(String sendingId, List<String> formsIdsToUpdate) {
        return this.formManager.revertDeletion(sendingId, formsIdsToUpdate);
    }

    @Override
    public Sending revertUserDeletion(String sessionId, String userId, String formId) {
        return this.formManager.revertUserDeletion(sessionId, userId, formId);
    }

    @Override
    public List<Sending> revertGroupDeletion(String sessionId, String groupId, String formId) {
        return this.formManager.revertGroupDeletion(sessionId, groupId, formId);
    }

    @Override
    public Form updateForms(Form form, List<String> thesaurusIdsToAttach) throws VradiException {
        return this.formManager.updateForm(form, thesaurusIdsToAttach);
    }
}

